<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notice StructType
 * @subpackage Structs
 */
class Notice extends AbstractStructBase
{
    /**
     * The NoticeId
     * @var int
     */
    public $NoticeId;
    /**
     * The SurveyId
     * @var int
     */
    public $SurveyId;
    /**
     * The UserId
     * @var int
     */
    public $UserId;
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * Constructor method for Notice
     * @uses Notice::setNoticeId()
     * @uses Notice::setSurveyId()
     * @uses Notice::setUserId()
     * @uses Notice::setText()
     * @uses Notice::setDate()
     * @param int $noticeId
     * @param int $surveyId
     * @param int $userId
     * @param string $text
     * @param string $date
     */
    public function __construct($noticeId = null, $surveyId = null, $userId = null, $text = null, $date = null)
    {
        $this
            ->setNoticeId($noticeId)
            ->setSurveyId($surveyId)
            ->setUserId($userId)
            ->setText($text)
            ->setDate($date);
    }
    /**
     * Get NoticeId value
     * @return int|null
     */
    public function getNoticeId()
    {
        return $this->NoticeId;
    }
    /**
     * Set NoticeId value
     * @param int $noticeId
     * @return \StructType\Notice
     */
    public function setNoticeId($noticeId = null)
    {
        // validation for constraint: int
        if (!is_null($noticeId) && !is_numeric($noticeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noticeId)), __LINE__);
        }
        $this->NoticeId = $noticeId;
        return $this;
    }
    /**
     * Get SurveyId value
     * @return int|null
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param int $surveyId
     * @return \StructType\Notice
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: int
        if (!is_null($surveyId) && !is_numeric($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get UserId value
     * @return int|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \StructType\Notice
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !is_numeric($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\Notice
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Notice
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Notice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
