<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModuleCourse StructType
 * @subpackage Structs
 */
class ModuleCourse extends AbstractStructBase
{
    /**
     * The Uid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Uid;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The InstructorList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\InstructorList
     */
    public $InstructorList;
    /**
     * The ProgramOfStudy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramOfStudy;
    /**
     * The Enrollment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Enrollment;
    /**
     * The CustomFieldsJSON
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomFieldsJSON;
    /**
     * The RoomName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomName;
    /**
     * Constructor method for ModuleCourse
     * @uses ModuleCourse::setUid()
     * @uses ModuleCourse::setName()
     * @uses ModuleCourse::setCode()
     * @uses ModuleCourse::setType()
     * @uses ModuleCourse::setInstructorList()
     * @uses ModuleCourse::setProgramOfStudy()
     * @uses ModuleCourse::setEnrollment()
     * @uses ModuleCourse::setCustomFieldsJSON()
     * @uses ModuleCourse::setRoomName()
     * @param string $uid
     * @param string $name
     * @param string $code
     * @param string $type
     * @param \StructType\InstructorList $instructorList
     * @param string $programOfStudy
     * @param int $enrollment
     * @param string $customFieldsJSON
     * @param string $roomName
     */
    public function __construct($uid = null, $name = null, $code = null, $type = null, \StructType\InstructorList $instructorList = null, $programOfStudy = null, $enrollment = null, $customFieldsJSON = null, $roomName = null)
    {
        $this
            ->setUid($uid)
            ->setName($name)
            ->setCode($code)
            ->setType($type)
            ->setInstructorList($instructorList)
            ->setProgramOfStudy($programOfStudy)
            ->setEnrollment($enrollment)
            ->setCustomFieldsJSON($customFieldsJSON)
            ->setRoomName($roomName);
    }
    /**
     * Get Uid value
     * @return string
     */
    public function getUid()
    {
        return $this->Uid;
    }
    /**
     * Set Uid value
     * @param string $uid
     * @return \StructType\ModuleCourse
     */
    public function setUid($uid = null)
    {
        // validation for constraint: string
        if (!is_null($uid) && !is_string($uid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uid)), __LINE__);
        }
        $this->Uid = $uid;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ModuleCourse
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ModuleCourse
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ModuleCourse
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get InstructorList value
     * @return \StructType\InstructorList
     */
    public function getInstructorList()
    {
        return $this->InstructorList;
    }
    /**
     * Set InstructorList value
     * @param \StructType\InstructorList $instructorList
     * @return \StructType\ModuleCourse
     */
    public function setInstructorList(\StructType\InstructorList $instructorList = null)
    {
        $this->InstructorList = $instructorList;
        return $this;
    }
    /**
     * Get ProgramOfStudy value
     * @return string|null
     */
    public function getProgramOfStudy()
    {
        return $this->ProgramOfStudy;
    }
    /**
     * Set ProgramOfStudy value
     * @param string $programOfStudy
     * @return \StructType\ModuleCourse
     */
    public function setProgramOfStudy($programOfStudy = null)
    {
        // validation for constraint: string
        if (!is_null($programOfStudy) && !is_string($programOfStudy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programOfStudy)), __LINE__);
        }
        $this->ProgramOfStudy = $programOfStudy;
        return $this;
    }
    /**
     * Get Enrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEnrollment()
    {
        return isset($this->Enrollment) ? $this->Enrollment : null;
    }
    /**
     * Set Enrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $enrollment
     * @return \StructType\ModuleCourse
     */
    public function setEnrollment($enrollment = null)
    {
        // validation for constraint: int
        if (!is_null($enrollment) && !is_numeric($enrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($enrollment)), __LINE__);
        }
        if (is_null($enrollment) || (is_array($enrollment) && empty($enrollment))) {
            unset($this->Enrollment);
        } else {
            $this->Enrollment = $enrollment;
        }
        return $this;
    }
    /**
     * Get CustomFieldsJSON value
     * @return string|null
     */
    public function getCustomFieldsJSON()
    {
        return $this->CustomFieldsJSON;
    }
    /**
     * Set CustomFieldsJSON value
     * @param string $customFieldsJSON
     * @return \StructType\ModuleCourse
     */
    public function setCustomFieldsJSON($customFieldsJSON = null)
    {
        // validation for constraint: string
        if (!is_null($customFieldsJSON) && !is_string($customFieldsJSON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customFieldsJSON)), __LINE__);
        }
        $this->CustomFieldsJSON = $customFieldsJSON;
        return $this;
    }
    /**
     * Get RoomName value
     * @return string|null
     */
    public function getRoomName()
    {
        return $this->RoomName;
    }
    /**
     * Set RoomName value
     * @param string $roomName
     * @return \StructType\ModuleCourse
     */
    public function setRoomName($roomName = null)
    {
        // validation for constraint: string
        if (!is_null($roomName) && !is_string($roomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomName)), __LINE__);
        }
        $this->RoomName = $roomName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModuleCourse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
