<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailSummary StructType
 * @subpackage Structs
 */
class MailSummary extends AbstractStructBase
{
    /**
     * The PendingMails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\IDList
     */
    public $PendingMails;
    /**
     * The PendingSchedulerMailsCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PendingSchedulerMailsCount;
    /**
     * The DeliveredMails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\IDList
     */
    public $DeliveredMails;
    /**
     * The UndeliveredMails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\IDList
     */
    public $UndeliveredMails;
    /**
     * Constructor method for MailSummary
     * @uses MailSummary::setPendingMails()
     * @uses MailSummary::setPendingSchedulerMailsCount()
     * @uses MailSummary::setDeliveredMails()
     * @uses MailSummary::setUndeliveredMails()
     * @param \StructType\IDList $pendingMails
     * @param int $pendingSchedulerMailsCount
     * @param \StructType\IDList $deliveredMails
     * @param \StructType\IDList $undeliveredMails
     */
    public function __construct(\StructType\IDList $pendingMails = null, $pendingSchedulerMailsCount = null, \StructType\IDList $deliveredMails = null, \StructType\IDList $undeliveredMails = null)
    {
        $this
            ->setPendingMails($pendingMails)
            ->setPendingSchedulerMailsCount($pendingSchedulerMailsCount)
            ->setDeliveredMails($deliveredMails)
            ->setUndeliveredMails($undeliveredMails);
    }
    /**
     * Get PendingMails value
     * @return \StructType\IDList
     */
    public function getPendingMails()
    {
        return $this->PendingMails;
    }
    /**
     * Set PendingMails value
     * @param \StructType\IDList $pendingMails
     * @return \StructType\MailSummary
     */
    public function setPendingMails(\StructType\IDList $pendingMails = null)
    {
        $this->PendingMails = $pendingMails;
        return $this;
    }
    /**
     * Get PendingSchedulerMailsCount value
     * @return int
     */
    public function getPendingSchedulerMailsCount()
    {
        return $this->PendingSchedulerMailsCount;
    }
    /**
     * Set PendingSchedulerMailsCount value
     * @param int $pendingSchedulerMailsCount
     * @return \StructType\MailSummary
     */
    public function setPendingSchedulerMailsCount($pendingSchedulerMailsCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingSchedulerMailsCount) && !is_numeric($pendingSchedulerMailsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pendingSchedulerMailsCount)), __LINE__);
        }
        $this->PendingSchedulerMailsCount = $pendingSchedulerMailsCount;
        return $this;
    }
    /**
     * Get DeliveredMails value
     * @return \StructType\IDList
     */
    public function getDeliveredMails()
    {
        return $this->DeliveredMails;
    }
    /**
     * Set DeliveredMails value
     * @param \StructType\IDList $deliveredMails
     * @return \StructType\MailSummary
     */
    public function setDeliveredMails(\StructType\IDList $deliveredMails = null)
    {
        $this->DeliveredMails = $deliveredMails;
        return $this;
    }
    /**
     * Get UndeliveredMails value
     * @return \StructType\IDList
     */
    public function getUndeliveredMails()
    {
        return $this->UndeliveredMails;
    }
    /**
     * Set UndeliveredMails value
     * @param \StructType\IDList $undeliveredMails
     * @return \StructType\MailSummary
     */
    public function setUndeliveredMails(\StructType\IDList $undeliveredMails = null)
    {
        $this->UndeliveredMails = $undeliveredMails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MailSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
