<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailList StructType
 * @subpackage Structs
 */
class MailList extends AbstractStructBase
{
    /**
     * The Mail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Mail[]
     */
    public $Mail;
    /**
     * Constructor method for MailList
     * @uses MailList::setMail()
     * @param \StructType\Mail[] $mail
     */
    public function __construct(array $mail = array())
    {
        $this
            ->setMail($mail);
    }
    /**
     * Get Mail value
     * @return \StructType\Mail[]
     */
    public function getMail()
    {
        return $this->Mail;
    }
    /**
     * Set Mail value
     * @throws \InvalidArgumentException
     * @param \StructType\Mail[] $mail
     * @return \StructType\MailList
     */
    public function setMail(array $mail = array())
    {
        foreach ($mail as $mailListMailItem) {
            // validation for constraint: itemType
            if (!$mailListMailItem instanceof \StructType\Mail) {
                throw new \InvalidArgumentException(sprintf('The Mail property can only contain items of \StructType\Mail, "%s" given', is_object($mailListMailItem) ? get_class($mailListMailItem) : gettype($mailListMailItem)), __LINE__);
            }
        }
        $this->Mail = $mail;
        return $this;
    }
    /**
     * Add item to Mail value
     * @throws \InvalidArgumentException
     * @param \StructType\Mail $item
     * @return \StructType\MailList
     */
    public function addToMail(\StructType\Mail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mail) {
            throw new \InvalidArgumentException(sprintf('The Mail property can only contain items of \StructType\Mail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Mail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MailList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
