<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailAddressList StructType
 * @subpackage Structs
 */
class MailAddressList extends AbstractStructBase
{
    /**
     * The MailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $MailAddress;
    /**
     * Constructor method for MailAddressList
     * @uses MailAddressList::setMailAddress()
     * @param string[] $mailAddress
     */
    public function __construct(array $mailAddress = array())
    {
        $this
            ->setMailAddress($mailAddress);
    }
    /**
     * Get MailAddress value
     * @return string[]
     */
    public function getMailAddress()
    {
        return $this->MailAddress;
    }
    /**
     * Set MailAddress value
     * @throws \InvalidArgumentException
     * @param string[] $mailAddress
     * @return \StructType\MailAddressList
     */
    public function setMailAddress(array $mailAddress = array())
    {
        foreach ($mailAddress as $mailAddressListMailAddressItem) {
            // validation for constraint: itemType
            if (!is_string($mailAddressListMailAddressItem)) {
                throw new \InvalidArgumentException(sprintf('The MailAddress property can only contain items of string, "%s" given', is_object($mailAddressListMailAddressItem) ? get_class($mailAddressListMailAddressItem) : gettype($mailAddressListMailAddressItem)), __LINE__);
            }
        }
        $this->MailAddress = $mailAddress;
        return $this;
    }
    /**
     * Add item to MailAddress value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MailAddressList
     */
    public function addToMailAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MailAddress property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MailAddress[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MailAddressList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
