<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mail StructType
 * @subpackage Structs
 */
class Mail extends AbstractStructBase
{
    /**
     * The FromMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromMail;
    /**
     * The FromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromName;
    /**
     * The ToList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\MailAddressList
     */
    public $ToList;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Subject;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Body;
    /**
     * The DeliveryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryType;
    /**
     * The CcList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MailAddressList
     */
    public $CcList;
    /**
     * The BccList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MailAddressList
     */
    public $BccList;
    /**
     * The ScheduledDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Status;
    /**
     * The SurveyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SurveyID;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Errors;
    /**
     * The AttachmentPaths
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $AttachmentPaths;
    /**
     * Constructor method for Mail
     * @uses Mail::setFromMail()
     * @uses Mail::setFromName()
     * @uses Mail::setToList()
     * @uses Mail::setSubject()
     * @uses Mail::setBody()
     * @uses Mail::setDeliveryType()
     * @uses Mail::setCcList()
     * @uses Mail::setBccList()
     * @uses Mail::setScheduledDate()
     * @uses Mail::setStatus()
     * @uses Mail::setSurveyID()
     * @uses Mail::setCreationDate()
     * @uses Mail::setID()
     * @uses Mail::setErrors()
     * @uses Mail::setAttachmentPaths()
     * @param string $fromMail
     * @param string $fromName
     * @param \StructType\MailAddressList $toList
     * @param string $subject
     * @param string $body
     * @param int $deliveryType
     * @param \StructType\MailAddressList $ccList
     * @param \StructType\MailAddressList $bccList
     * @param string $scheduledDate
     * @param int $status
     * @param int $surveyID
     * @param string $creationDate
     * @param int $iD
     * @param \StructType\StringList $errors
     * @param \StructType\StringList $attachmentPaths
     */
    public function __construct($fromMail = null, $fromName = null, \StructType\MailAddressList $toList = null, $subject = null, $body = null, $deliveryType = null, \StructType\MailAddressList $ccList = null, \StructType\MailAddressList $bccList = null, $scheduledDate = null, $status = null, $surveyID = null, $creationDate = null, $iD = null, \StructType\StringList $errors = null, \StructType\StringList $attachmentPaths = null)
    {
        $this
            ->setFromMail($fromMail)
            ->setFromName($fromName)
            ->setToList($toList)
            ->setSubject($subject)
            ->setBody($body)
            ->setDeliveryType($deliveryType)
            ->setCcList($ccList)
            ->setBccList($bccList)
            ->setScheduledDate($scheduledDate)
            ->setStatus($status)
            ->setSurveyID($surveyID)
            ->setCreationDate($creationDate)
            ->setID($iD)
            ->setErrors($errors)
            ->setAttachmentPaths($attachmentPaths);
    }
    /**
     * Get FromMail value
     * @return string
     */
    public function getFromMail()
    {
        return $this->FromMail;
    }
    /**
     * Set FromMail value
     * @param string $fromMail
     * @return \StructType\Mail
     */
    public function setFromMail($fromMail = null)
    {
        // validation for constraint: string
        if (!is_null($fromMail) && !is_string($fromMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromMail)), __LINE__);
        }
        $this->FromMail = $fromMail;
        return $this;
    }
    /**
     * Get FromName value
     * @return string
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \StructType\Mail
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get ToList value
     * @return \StructType\MailAddressList
     */
    public function getToList()
    {
        return $this->ToList;
    }
    /**
     * Set ToList value
     * @param \StructType\MailAddressList $toList
     * @return \StructType\Mail
     */
    public function setToList(\StructType\MailAddressList $toList = null)
    {
        $this->ToList = $toList;
        return $this;
    }
    /**
     * Get Subject value
     * @return string
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\Mail
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Body value
     * @return string
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param string $body
     * @return \StructType\Mail
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($body)), __LINE__);
        }
        $this->Body = $body;
        return $this;
    }
    /**
     * Get DeliveryType value
     * @return int
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @param int $deliveryType
     * @return \StructType\Mail
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryType) && !is_numeric($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deliveryType)), __LINE__);
        }
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get CcList value
     * @return \StructType\MailAddressList|null
     */
    public function getCcList()
    {
        return $this->CcList;
    }
    /**
     * Set CcList value
     * @param \StructType\MailAddressList $ccList
     * @return \StructType\Mail
     */
    public function setCcList(\StructType\MailAddressList $ccList = null)
    {
        $this->CcList = $ccList;
        return $this;
    }
    /**
     * Get BccList value
     * @return \StructType\MailAddressList|null
     */
    public function getBccList()
    {
        return $this->BccList;
    }
    /**
     * Set BccList value
     * @param \StructType\MailAddressList $bccList
     * @return \StructType\Mail
     */
    public function setBccList(\StructType\MailAddressList $bccList = null)
    {
        $this->BccList = $bccList;
        return $this;
    }
    /**
     * Get ScheduledDate value
     * @return string|null
     */
    public function getScheduledDate()
    {
        return $this->ScheduledDate;
    }
    /**
     * Set ScheduledDate value
     * @param string $scheduledDate
     * @return \StructType\Mail
     */
    public function setScheduledDate($scheduledDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDate) && !is_string($scheduledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledDate)), __LINE__);
        }
        $this->ScheduledDate = $scheduledDate;
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\Mail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SurveyID value
     * @return int|null
     */
    public function getSurveyID()
    {
        return $this->SurveyID;
    }
    /**
     * Set SurveyID value
     * @param int $surveyID
     * @return \StructType\Mail
     */
    public function setSurveyID($surveyID = null)
    {
        // validation for constraint: int
        if (!is_null($surveyID) && !is_numeric($surveyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surveyID)), __LINE__);
        }
        $this->SurveyID = $surveyID;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\Mail
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Mail
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\StringList|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\StringList $errors
     * @return \StructType\Mail
     */
    public function setErrors(\StructType\StringList $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get AttachmentPaths value
     * @return \StructType\StringList|null
     */
    public function getAttachmentPaths()
    {
        return $this->AttachmentPaths;
    }
    /**
     * Set AttachmentPaths value
     * @param \StructType\StringList $attachmentPaths
     * @return \StructType\Mail
     */
    public function setAttachmentPaths(\StructType\StringList $attachmentPaths = null)
    {
        $this->AttachmentPaths = $attachmentPaths;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Mail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
