<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValueList StructType
 * @subpackage Structs
 */
class KeyValueList extends AbstractStructBase
{
    /**
     * The KeyValuePair
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValuePair[]
     */
    public $KeyValuePair;
    /**
     * Constructor method for KeyValueList
     * @uses KeyValueList::setKeyValuePair()
     * @param \StructType\KeyValuePair[] $keyValuePair
     */
    public function __construct(array $keyValuePair = array())
    {
        $this
            ->setKeyValuePair($keyValuePair);
    }
    /**
     * Get KeyValuePair value
     * @return \StructType\KeyValuePair[]|null
     */
    public function getKeyValuePair()
    {
        return $this->KeyValuePair;
    }
    /**
     * Set KeyValuePair value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePair[] $keyValuePair
     * @return \StructType\KeyValueList
     */
    public function setKeyValuePair(array $keyValuePair = array())
    {
        foreach ($keyValuePair as $keyValueListKeyValuePairItem) {
            // validation for constraint: itemType
            if (!$keyValueListKeyValuePairItem instanceof \StructType\KeyValuePair) {
                throw new \InvalidArgumentException(sprintf('The KeyValuePair property can only contain items of \StructType\KeyValuePair, "%s" given', is_object($keyValueListKeyValuePairItem) ? get_class($keyValueListKeyValuePairItem) : gettype($keyValueListKeyValuePairItem)), __LINE__);
            }
        }
        $this->KeyValuePair = $keyValuePair;
        return $this;
    }
    /**
     * Add item to KeyValuePair value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePair $item
     * @return \StructType\KeyValueList
     */
    public function addToKeyValuePair(\StructType\KeyValuePair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePair) {
            throw new \InvalidArgumentException(sprintf('The KeyValuePair property can only contain items of \StructType\KeyValuePair, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KeyValuePair[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KeyValueList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
