<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemTranslationList StructType
 * @subpackage Structs
 */
class ItemTranslationList extends AbstractStructBase
{
    /**
     * The ItemTranslation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemTranslation[]
     */
    public $ItemTranslation;
    /**
     * Constructor method for ItemTranslationList
     * @uses ItemTranslationList::setItemTranslation()
     * @param \StructType\ItemTranslation[] $itemTranslation
     */
    public function __construct(array $itemTranslation = array())
    {
        $this
            ->setItemTranslation($itemTranslation);
    }
    /**
     * Get ItemTranslation value
     * @return \StructType\ItemTranslation[]|null
     */
    public function getItemTranslation()
    {
        return $this->ItemTranslation;
    }
    /**
     * Set ItemTranslation value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemTranslation[] $itemTranslation
     * @return \StructType\ItemTranslationList
     */
    public function setItemTranslation(array $itemTranslation = array())
    {
        foreach ($itemTranslation as $itemTranslationListItemTranslationItem) {
            // validation for constraint: itemType
            if (!$itemTranslationListItemTranslationItem instanceof \StructType\ItemTranslation) {
                throw new \InvalidArgumentException(sprintf('The ItemTranslation property can only contain items of \StructType\ItemTranslation, "%s" given', is_object($itemTranslationListItemTranslationItem) ? get_class($itemTranslationListItemTranslationItem) : gettype($itemTranslationListItemTranslationItem)), __LINE__);
            }
        }
        $this->ItemTranslation = $itemTranslation;
        return $this;
    }
    /**
     * Add item to ItemTranslation value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemTranslation $item
     * @return \StructType\ItemTranslationList
     */
    public function addToItemTranslation(\StructType\ItemTranslation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemTranslation) {
            throw new \InvalidArgumentException(sprintf('The ItemTranslation property can only contain items of \StructType\ItemTranslation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemTranslation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemTranslationList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
