<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemTranslation StructType
 * @subpackage Structs
 */
class ItemTranslation extends AbstractStructBase
{
    /**
     * The ItemId
     * @var int
     */
    public $ItemId;
    /**
     * The ItemText
     * @var string
     */
    public $ItemText;
    /**
     * The Left
     * @var string
     */
    public $Left;
    /**
     * The Right
     * @var string
     */
    public $Right;
    /**
     * The Abstention
     * @var string
     */
    public $Abstention;
    /**
     * Constructor method for ItemTranslation
     * @uses ItemTranslation::setItemId()
     * @uses ItemTranslation::setItemText()
     * @uses ItemTranslation::setLeft()
     * @uses ItemTranslation::setRight()
     * @uses ItemTranslation::setAbstention()
     * @param int $itemId
     * @param string $itemText
     * @param string $left
     * @param string $right
     * @param string $abstention
     */
    public function __construct($itemId = null, $itemText = null, $left = null, $right = null, $abstention = null)
    {
        $this
            ->setItemId($itemId)
            ->setItemText($itemText)
            ->setLeft($left)
            ->setRight($right)
            ->setAbstention($abstention);
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \StructType\ItemTranslation
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !is_numeric($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ItemText value
     * @return string|null
     */
    public function getItemText()
    {
        return $this->ItemText;
    }
    /**
     * Set ItemText value
     * @param string $itemText
     * @return \StructType\ItemTranslation
     */
    public function setItemText($itemText = null)
    {
        // validation for constraint: string
        if (!is_null($itemText) && !is_string($itemText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemText)), __LINE__);
        }
        $this->ItemText = $itemText;
        return $this;
    }
    /**
     * Get Left value
     * @return string|null
     */
    public function getLeft()
    {
        return $this->Left;
    }
    /**
     * Set Left value
     * @param string $left
     * @return \StructType\ItemTranslation
     */
    public function setLeft($left = null)
    {
        // validation for constraint: string
        if (!is_null($left) && !is_string($left)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($left)), __LINE__);
        }
        $this->Left = $left;
        return $this;
    }
    /**
     * Get Right value
     * @return string|null
     */
    public function getRight()
    {
        return $this->Right;
    }
    /**
     * Set Right value
     * @param string $right
     * @return \StructType\ItemTranslation
     */
    public function setRight($right = null)
    {
        // validation for constraint: string
        if (!is_null($right) && !is_string($right)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($right)), __LINE__);
        }
        $this->Right = $right;
        return $this;
    }
    /**
     * Get Abstention value
     * @return string|null
     */
    public function getAbstention()
    {
        return $this->Abstention;
    }
    /**
     * Set Abstention value
     * @param string $abstention
     * @return \StructType\ItemTranslation
     */
    public function setAbstention($abstention = null)
    {
        // validation for constraint: string
        if (!is_null($abstention) && !is_string($abstention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abstention)), __LINE__);
        }
        $this->Abstention = $abstention;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemTranslation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
