<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndicatorList StructType
 * @subpackage Structs
 */
class IndicatorList extends AbstractStructBase
{
    /**
     * The Indicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Indicator[]
     */
    public $Indicator;
    /**
     * Constructor method for IndicatorList
     * @uses IndicatorList::setIndicator()
     * @param \StructType\Indicator[] $indicator
     */
    public function __construct(array $indicator = array())
    {
        $this
            ->setIndicator($indicator);
    }
    /**
     * Get Indicator value
     * @return \StructType\Indicator[]|null
     */
    public function getIndicator()
    {
        return $this->Indicator;
    }
    /**
     * Set Indicator value
     * @throws \InvalidArgumentException
     * @param \StructType\Indicator[] $indicator
     * @return \StructType\IndicatorList
     */
    public function setIndicator(array $indicator = array())
    {
        foreach ($indicator as $indicatorListIndicatorItem) {
            // validation for constraint: itemType
            if (!$indicatorListIndicatorItem instanceof \StructType\Indicator) {
                throw new \InvalidArgumentException(sprintf('The Indicator property can only contain items of \StructType\Indicator, "%s" given', is_object($indicatorListIndicatorItem) ? get_class($indicatorListIndicatorItem) : gettype($indicatorListIndicatorItem)), __LINE__);
            }
        }
        $this->Indicator = $indicator;
        return $this;
    }
    /**
     * Add item to Indicator value
     * @throws \InvalidArgumentException
     * @param \StructType\Indicator $item
     * @return \StructType\IndicatorList
     */
    public function addToIndicator(\StructType\Indicator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Indicator) {
            throw new \InvalidArgumentException(sprintf('The Indicator property can only contain items of \StructType\Indicator, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Indicator[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IndicatorList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
