<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Indicator StructType
 * @subpackage Structs
 */
class Indicator extends AbstractStructBase
{
    /**
     * The Position
     * @var int
     */
    public $Position;
    /**
     * The Names
     * @var \StructType\IndicatorNameList
     */
    public $Names;
    /**
     * The Items
     * @var \StructType\IDList
     */
    public $Items;
    /**
     * The Mean
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $Mean;
    /**
     * The StdDev
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $StdDev;
    /**
     * Constructor method for Indicator
     * @uses Indicator::setPosition()
     * @uses Indicator::setNames()
     * @uses Indicator::setItems()
     * @uses Indicator::setMean()
     * @uses Indicator::setStdDev()
     * @param int $position
     * @param \StructType\IndicatorNameList $names
     * @param \StructType\IDList $items
     * @param float $mean
     * @param float $stdDev
     */
    public function __construct($position = null, \StructType\IndicatorNameList $names = null, \StructType\IDList $items = null, $mean = null, $stdDev = null)
    {
        $this
            ->setPosition($position)
            ->setNames($names)
            ->setItems($items)
            ->setMean($mean)
            ->setStdDev($stdDev);
    }
    /**
     * Get Position value
     * @return int|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \StructType\Indicator
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !is_numeric($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Names value
     * @return \StructType\IndicatorNameList|null
     */
    public function getNames()
    {
        return $this->Names;
    }
    /**
     * Set Names value
     * @param \StructType\IndicatorNameList $names
     * @return \StructType\Indicator
     */
    public function setNames(\StructType\IndicatorNameList $names = null)
    {
        $this->Names = $names;
        return $this;
    }
    /**
     * Get Items value
     * @return \StructType\IDList|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \StructType\IDList $items
     * @return \StructType\Indicator
     */
    public function setItems(\StructType\IDList $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get Mean value
     * @return float|null
     */
    public function getMean()
    {
        return $this->Mean;
    }
    /**
     * Set Mean value
     * @param float $mean
     * @return \StructType\Indicator
     */
    public function setMean($mean = null)
    {
        $this->Mean = $mean;
        return $this;
    }
    /**
     * Get StdDev value
     * @return float|null
     */
    public function getStdDev()
    {
        return $this->StdDev;
    }
    /**
     * Set StdDev value
     * @param float $stdDev
     * @return \StructType\Indicator
     */
    public function setStdDev($stdDev = null)
    {
        $this->StdDev = $stdDev;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Indicator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
