<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupTranslationList StructType
 * @subpackage Structs
 */
class GroupTranslationList extends AbstractStructBase
{
    /**
     * The GroupTranslation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GroupTranslation[]
     */
    public $GroupTranslation;
    /**
     * Constructor method for GroupTranslationList
     * @uses GroupTranslationList::setGroupTranslation()
     * @param \StructType\GroupTranslation[] $groupTranslation
     */
    public function __construct(array $groupTranslation = array())
    {
        $this
            ->setGroupTranslation($groupTranslation);
    }
    /**
     * Get GroupTranslation value
     * @return \StructType\GroupTranslation[]|null
     */
    public function getGroupTranslation()
    {
        return $this->GroupTranslation;
    }
    /**
     * Set GroupTranslation value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupTranslation[] $groupTranslation
     * @return \StructType\GroupTranslationList
     */
    public function setGroupTranslation(array $groupTranslation = array())
    {
        foreach ($groupTranslation as $groupTranslationListGroupTranslationItem) {
            // validation for constraint: itemType
            if (!$groupTranslationListGroupTranslationItem instanceof \StructType\GroupTranslation) {
                throw new \InvalidArgumentException(sprintf('The GroupTranslation property can only contain items of \StructType\GroupTranslation, "%s" given', is_object($groupTranslationListGroupTranslationItem) ? get_class($groupTranslationListGroupTranslationItem) : gettype($groupTranslationListGroupTranslationItem)), __LINE__);
            }
        }
        $this->GroupTranslation = $groupTranslation;
        return $this;
    }
    /**
     * Add item to GroupTranslation value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupTranslation $item
     * @return \StructType\GroupTranslationList
     */
    public function addToGroupTranslation(\StructType\GroupTranslation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupTranslation) {
            throw new \InvalidArgumentException(sprintf('The GroupTranslation property can only contain items of \StructType\GroupTranslation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GroupTranslation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupTranslationList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
