<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupTranslation StructType
 * @subpackage Structs
 */
class GroupTranslation extends AbstractStructBase
{
    /**
     * The GroupId
     * @var int
     */
    public $GroupId;
    /**
     * The GroupTitle
     * @var string
     */
    public $GroupTitle;
    /**
     * The GroupDescription
     * @var string
     */
    public $GroupDescription;
    /**
     * Constructor method for GroupTranslation
     * @uses GroupTranslation::setGroupId()
     * @uses GroupTranslation::setGroupTitle()
     * @uses GroupTranslation::setGroupDescription()
     * @param int $groupId
     * @param string $groupTitle
     * @param string $groupDescription
     */
    public function __construct($groupId = null, $groupTitle = null, $groupDescription = null)
    {
        $this
            ->setGroupId($groupId)
            ->setGroupTitle($groupTitle)
            ->setGroupDescription($groupDescription);
    }
    /**
     * Get GroupId value
     * @return int|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \StructType\GroupTranslation
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !is_numeric($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get GroupTitle value
     * @return string|null
     */
    public function getGroupTitle()
    {
        return $this->GroupTitle;
    }
    /**
     * Set GroupTitle value
     * @param string $groupTitle
     * @return \StructType\GroupTranslation
     */
    public function setGroupTitle($groupTitle = null)
    {
        // validation for constraint: string
        if (!is_null($groupTitle) && !is_string($groupTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupTitle)), __LINE__);
        }
        $this->GroupTitle = $groupTitle;
        return $this;
    }
    /**
     * Get GroupDescription value
     * @return string|null
     */
    public function getGroupDescription()
    {
        return $this->GroupDescription;
    }
    /**
     * Set GroupDescription value
     * @param string $groupDescription
     * @return \StructType\GroupTranslation
     */
    public function setGroupDescription($groupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($groupDescription) && !is_string($groupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupDescription)), __LINE__);
        }
        $this->GroupDescription = $groupDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupTranslation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
