<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormTranslation StructType
 * @subpackage Structs
 */
class FormTranslation extends AbstractStructBase
{
    /**
     * The FormTranslationId
     * @var int
     */
    public $FormTranslationId;
    /**
     * The FormId
     * @var int
     */
    public $FormId;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Abbreviation
     * @var string
     */
    public $Abbreviation;
    /**
     * The PDFFilename
     * @var string
     */
    public $PDFFilename;
    /**
     * The LogoFile
     * @var string
     */
    public $LogoFile;
    /**
     * The SystemLanguage
     * @var int
     */
    public $SystemLanguage;
    /**
     * The SystemLanguageAbbreviation
     * @var string
     */
    public $SystemLanguageAbbreviation;
    /**
     * The LanguageSet
     * @var int
     */
    public $LanguageSet;
    /**
     * The IsEnabled
     * @var bool
     */
    public $IsEnabled;
    /**
     * The GroupTranslations
     * @var \StructType\GroupTranslationList
     */
    public $GroupTranslations;
    /**
     * The ItemTranslations
     * @var \StructType\ItemTranslationList
     */
    public $ItemTranslations;
    /**
     * Constructor method for FormTranslation
     * @uses FormTranslation::setFormTranslationId()
     * @uses FormTranslation::setFormId()
     * @uses FormTranslation::setName()
     * @uses FormTranslation::setAbbreviation()
     * @uses FormTranslation::setPDFFilename()
     * @uses FormTranslation::setLogoFile()
     * @uses FormTranslation::setSystemLanguage()
     * @uses FormTranslation::setSystemLanguageAbbreviation()
     * @uses FormTranslation::setLanguageSet()
     * @uses FormTranslation::setIsEnabled()
     * @uses FormTranslation::setGroupTranslations()
     * @uses FormTranslation::setItemTranslations()
     * @param int $formTranslationId
     * @param int $formId
     * @param string $name
     * @param string $abbreviation
     * @param string $pDFFilename
     * @param string $logoFile
     * @param int $systemLanguage
     * @param string $systemLanguageAbbreviation
     * @param int $languageSet
     * @param bool $isEnabled
     * @param \StructType\GroupTranslationList $groupTranslations
     * @param \StructType\ItemTranslationList $itemTranslations
     */
    public function __construct($formTranslationId = null, $formId = null, $name = null, $abbreviation = null, $pDFFilename = null, $logoFile = null, $systemLanguage = null, $systemLanguageAbbreviation = null, $languageSet = null, $isEnabled = null, \StructType\GroupTranslationList $groupTranslations = null, \StructType\ItemTranslationList $itemTranslations = null)
    {
        $this
            ->setFormTranslationId($formTranslationId)
            ->setFormId($formId)
            ->setName($name)
            ->setAbbreviation($abbreviation)
            ->setPDFFilename($pDFFilename)
            ->setLogoFile($logoFile)
            ->setSystemLanguage($systemLanguage)
            ->setSystemLanguageAbbreviation($systemLanguageAbbreviation)
            ->setLanguageSet($languageSet)
            ->setIsEnabled($isEnabled)
            ->setGroupTranslations($groupTranslations)
            ->setItemTranslations($itemTranslations);
    }
    /**
     * Get FormTranslationId value
     * @return int|null
     */
    public function getFormTranslationId()
    {
        return $this->FormTranslationId;
    }
    /**
     * Set FormTranslationId value
     * @param int $formTranslationId
     * @return \StructType\FormTranslation
     */
    public function setFormTranslationId($formTranslationId = null)
    {
        // validation for constraint: int
        if (!is_null($formTranslationId) && !is_numeric($formTranslationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($formTranslationId)), __LINE__);
        }
        $this->FormTranslationId = $formTranslationId;
        return $this;
    }
    /**
     * Get FormId value
     * @return int|null
     */
    public function getFormId()
    {
        return $this->FormId;
    }
    /**
     * Set FormId value
     * @param int $formId
     * @return \StructType\FormTranslation
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: int
        if (!is_null($formId) && !is_numeric($formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($formId)), __LINE__);
        }
        $this->FormId = $formId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\FormTranslation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Abbreviation value
     * @return string|null
     */
    public function getAbbreviation()
    {
        return $this->Abbreviation;
    }
    /**
     * Set Abbreviation value
     * @param string $abbreviation
     * @return \StructType\FormTranslation
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviation)), __LINE__);
        }
        $this->Abbreviation = $abbreviation;
        return $this;
    }
    /**
     * Get PDFFilename value
     * @return string|null
     */
    public function getPDFFilename()
    {
        return $this->PDFFilename;
    }
    /**
     * Set PDFFilename value
     * @param string $pDFFilename
     * @return \StructType\FormTranslation
     */
    public function setPDFFilename($pDFFilename = null)
    {
        // validation for constraint: string
        if (!is_null($pDFFilename) && !is_string($pDFFilename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pDFFilename)), __LINE__);
        }
        $this->PDFFilename = $pDFFilename;
        return $this;
    }
    /**
     * Get LogoFile value
     * @return string|null
     */
    public function getLogoFile()
    {
        return $this->LogoFile;
    }
    /**
     * Set LogoFile value
     * @param string $logoFile
     * @return \StructType\FormTranslation
     */
    public function setLogoFile($logoFile = null)
    {
        // validation for constraint: string
        if (!is_null($logoFile) && !is_string($logoFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logoFile)), __LINE__);
        }
        $this->LogoFile = $logoFile;
        return $this;
    }
    /**
     * Get SystemLanguage value
     * @return int|null
     */
    public function getSystemLanguage()
    {
        return $this->SystemLanguage;
    }
    /**
     * Set SystemLanguage value
     * @param int $systemLanguage
     * @return \StructType\FormTranslation
     */
    public function setSystemLanguage($systemLanguage = null)
    {
        // validation for constraint: int
        if (!is_null($systemLanguage) && !is_numeric($systemLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemLanguage)), __LINE__);
        }
        $this->SystemLanguage = $systemLanguage;
        return $this;
    }
    /**
     * Get SystemLanguageAbbreviation value
     * @return string|null
     */
    public function getSystemLanguageAbbreviation()
    {
        return $this->SystemLanguageAbbreviation;
    }
    /**
     * Set SystemLanguageAbbreviation value
     * @param string $systemLanguageAbbreviation
     * @return \StructType\FormTranslation
     */
    public function setSystemLanguageAbbreviation($systemLanguageAbbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($systemLanguageAbbreviation) && !is_string($systemLanguageAbbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemLanguageAbbreviation)), __LINE__);
        }
        $this->SystemLanguageAbbreviation = $systemLanguageAbbreviation;
        return $this;
    }
    /**
     * Get LanguageSet value
     * @return int|null
     */
    public function getLanguageSet()
    {
        return $this->LanguageSet;
    }
    /**
     * Set LanguageSet value
     * @param int $languageSet
     * @return \StructType\FormTranslation
     */
    public function setLanguageSet($languageSet = null)
    {
        // validation for constraint: int
        if (!is_null($languageSet) && !is_numeric($languageSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageSet)), __LINE__);
        }
        $this->LanguageSet = $languageSet;
        return $this;
    }
    /**
     * Get IsEnabled value
     * @return bool|null
     */
    public function getIsEnabled()
    {
        return $this->IsEnabled;
    }
    /**
     * Set IsEnabled value
     * @param bool $isEnabled
     * @return \StructType\FormTranslation
     */
    public function setIsEnabled($isEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnabled) && !is_bool($isEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEnabled)), __LINE__);
        }
        $this->IsEnabled = $isEnabled;
        return $this;
    }
    /**
     * Get GroupTranslations value
     * @return \StructType\GroupTranslationList|null
     */
    public function getGroupTranslations()
    {
        return $this->GroupTranslations;
    }
    /**
     * Set GroupTranslations value
     * @param \StructType\GroupTranslationList $groupTranslations
     * @return \StructType\FormTranslation
     */
    public function setGroupTranslations(\StructType\GroupTranslationList $groupTranslations = null)
    {
        $this->GroupTranslations = $groupTranslations;
        return $this;
    }
    /**
     * Get ItemTranslations value
     * @return \StructType\ItemTranslationList|null
     */
    public function getItemTranslations()
    {
        return $this->ItemTranslations;
    }
    /**
     * Set ItemTranslations value
     * @param \StructType\ItemTranslationList $itemTranslations
     * @return \StructType\FormTranslation
     */
    public function setItemTranslations(\StructType\ItemTranslationList $itemTranslations = null)
    {
        $this->ItemTranslations = $itemTranslations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormTranslation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
