<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormSelectFieldList StructType
 * @subpackage Structs
 */
class FormSelectFieldList extends AbstractStructBase
{
    /**
     * The FormSelectField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FormSelectField;
    /**
     * Constructor method for FormSelectFieldList
     * @uses FormSelectFieldList::setFormSelectField()
     * @param string[] $formSelectField
     */
    public function __construct(array $formSelectField = array())
    {
        $this
            ->setFormSelectField($formSelectField);
    }
    /**
     * Get FormSelectField value
     * @return string[]|null
     */
    public function getFormSelectField()
    {
        return $this->FormSelectField;
    }
    /**
     * Set FormSelectField value
     * @uses \EnumType\FormSelectField::valueIsValid()
     * @uses \EnumType\FormSelectField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $formSelectField
     * @return \StructType\FormSelectFieldList
     */
    public function setFormSelectField(array $formSelectField = array())
    {
        $invalidValues = array();
        foreach ($formSelectField as $formSelectFieldListFormSelectFieldItem) {
            if (!\EnumType\FormSelectField::valueIsValid($formSelectFieldListFormSelectFieldItem)) {
                $invalidValues[] = var_export($formSelectFieldListFormSelectFieldItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\FormSelectField::getValidValues())), __LINE__);
        }
        $this->FormSelectField = $formSelectField;
        return $this;
    }
    /**
     * Add item to FormSelectField value
     * @uses \EnumType\FormSelectField::valueIsValid()
     * @uses \EnumType\FormSelectField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\FormSelectFieldList
     */
    public function addToFormSelectField($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormSelectField::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\FormSelectField::getValidValues())), __LINE__);
        }
        $this->FormSelectField[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormSelectFieldList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
