<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormProperties StructType
 * @subpackage Structs
 */
class FormProperties extends AbstractStructBase
{
    /**
     * The FormId
     * @var string
     */
    public $FormId;
    /**
     * The IdType
     * @var string
     */
    public $IdType;
    /**
     * The FormName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormName;
    /**
     * The FormTitle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormTitle;
    /**
     * The IsActivated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActivated;
    /**
     * The IsExtensible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExtensible;
    /**
     * The ResultAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResultAccess;
    /**
     * The FormProcedure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormProcedure;
    /**
     * The FormSurveyType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormSurveyType;
    /**
     * The FormFolderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormFolderName;
    /**
     * Constructor method for FormProperties
     * @uses FormProperties::setFormId()
     * @uses FormProperties::setIdType()
     * @uses FormProperties::setFormName()
     * @uses FormProperties::setFormTitle()
     * @uses FormProperties::setIsActivated()
     * @uses FormProperties::setIsExtensible()
     * @uses FormProperties::setResultAccess()
     * @uses FormProperties::setFormProcedure()
     * @uses FormProperties::setFormSurveyType()
     * @uses FormProperties::setFormFolderName()
     * @param string $formId
     * @param string $idType
     * @param string $formName
     * @param string $formTitle
     * @param bool $isActivated
     * @param bool $isExtensible
     * @param bool $resultAccess
     * @param string $formProcedure
     * @param string $formSurveyType
     * @param string $formFolderName
     */
    public function __construct($formId = null, $idType = null, $formName = null, $formTitle = null, $isActivated = null, $isExtensible = null, $resultAccess = null, $formProcedure = null, $formSurveyType = null, $formFolderName = null)
    {
        $this
            ->setFormId($formId)
            ->setIdType($idType)
            ->setFormName($formName)
            ->setFormTitle($formTitle)
            ->setIsActivated($isActivated)
            ->setIsExtensible($isExtensible)
            ->setResultAccess($resultAccess)
            ->setFormProcedure($formProcedure)
            ->setFormSurveyType($formSurveyType)
            ->setFormFolderName($formFolderName);
    }
    /**
     * Get FormId value
     * @return string|null
     */
    public function getFormId()
    {
        return $this->FormId;
    }
    /**
     * Set FormId value
     * @param string $formId
     * @return \StructType\FormProperties
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: string
        if (!is_null($formId) && !is_string($formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formId)), __LINE__);
        }
        $this->FormId = $formId;
        return $this;
    }
    /**
     * Get IdType value
     * @return string|null
     */
    public function getIdType()
    {
        return $this->IdType;
    }
    /**
     * Set IdType value
     * @uses \EnumType\FormIdType::valueIsValid()
     * @uses \EnumType\FormIdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idType
     * @return \StructType\FormProperties
     */
    public function setIdType($idType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormIdType::valueIsValid($idType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $idType, implode(', ', \EnumType\FormIdType::getValidValues())), __LINE__);
        }
        $this->IdType = $idType;
        return $this;
    }
    /**
     * Get FormName value
     * @return string|null
     */
    public function getFormName()
    {
        return $this->FormName;
    }
    /**
     * Set FormName value
     * @param string $formName
     * @return \StructType\FormProperties
     */
    public function setFormName($formName = null)
    {
        // validation for constraint: string
        if (!is_null($formName) && !is_string($formName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formName)), __LINE__);
        }
        $this->FormName = $formName;
        return $this;
    }
    /**
     * Get FormTitle value
     * @return string|null
     */
    public function getFormTitle()
    {
        return $this->FormTitle;
    }
    /**
     * Set FormTitle value
     * @param string $formTitle
     * @return \StructType\FormProperties
     */
    public function setFormTitle($formTitle = null)
    {
        // validation for constraint: string
        if (!is_null($formTitle) && !is_string($formTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formTitle)), __LINE__);
        }
        $this->FormTitle = $formTitle;
        return $this;
    }
    /**
     * Get IsActivated value
     * @return bool|null
     */
    public function getIsActivated()
    {
        return $this->IsActivated;
    }
    /**
     * Set IsActivated value
     * @param bool $isActivated
     * @return \StructType\FormProperties
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActivated) && !is_bool($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->IsActivated = $isActivated;
        return $this;
    }
    /**
     * Get IsExtensible value
     * @return bool|null
     */
    public function getIsExtensible()
    {
        return $this->IsExtensible;
    }
    /**
     * Set IsExtensible value
     * @param bool $isExtensible
     * @return \StructType\FormProperties
     */
    public function setIsExtensible($isExtensible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtensible) && !is_bool($isExtensible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isExtensible)), __LINE__);
        }
        $this->IsExtensible = $isExtensible;
        return $this;
    }
    /**
     * Get ResultAccess value
     * @return bool|null
     */
    public function getResultAccess()
    {
        return $this->ResultAccess;
    }
    /**
     * Set ResultAccess value
     * @param bool $resultAccess
     * @return \StructType\FormProperties
     */
    public function setResultAccess($resultAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultAccess) && !is_bool($resultAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($resultAccess)), __LINE__);
        }
        $this->ResultAccess = $resultAccess;
        return $this;
    }
    /**
     * Get FormProcedure value
     * @return string|null
     */
    public function getFormProcedure()
    {
        return $this->FormProcedure;
    }
    /**
     * Set FormProcedure value
     * @uses \EnumType\FormProcedure::valueIsValid()
     * @uses \EnumType\FormProcedure::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formProcedure
     * @return \StructType\FormProperties
     */
    public function setFormProcedure($formProcedure = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormProcedure::valueIsValid($formProcedure)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $formProcedure, implode(', ', \EnumType\FormProcedure::getValidValues())), __LINE__);
        }
        $this->FormProcedure = $formProcedure;
        return $this;
    }
    /**
     * Get FormSurveyType value
     * @return string|null
     */
    public function getFormSurveyType()
    {
        return $this->FormSurveyType;
    }
    /**
     * Set FormSurveyType value
     * @uses \EnumType\FormSurveyType::valueIsValid()
     * @uses \EnumType\FormSurveyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formSurveyType
     * @return \StructType\FormProperties
     */
    public function setFormSurveyType($formSurveyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormSurveyType::valueIsValid($formSurveyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $formSurveyType, implode(', ', \EnumType\FormSurveyType::getValidValues())), __LINE__);
        }
        $this->FormSurveyType = $formSurveyType;
        return $this;
    }
    /**
     * Get FormFolderName value
     * @return string|null
     */
    public function getFormFolderName()
    {
        return $this->FormFolderName;
    }
    /**
     * Set FormFolderName value
     * @param string $formFolderName
     * @return \StructType\FormProperties
     */
    public function setFormFolderName($formFolderName = null)
    {
        // validation for constraint: string
        if (!is_null($formFolderName) && !is_string($formFolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formFolderName)), __LINE__);
        }
        $this->FormFolderName = $formFolderName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormProperties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
