<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormParams StructType
 * @subpackage Structs
 */
class FormParams extends AbstractStructBase
{
    /**
     * The Users
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\StringList
     */
    public $Users;
    /**
     * The SearchQuery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchQuery;
    /**
     * The IncludeFormsOfOtherSubunitAdministrators
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeFormsOfOtherSubunitAdministrators;
    /**
     * The OrderBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * The OrderByDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderByDirection;
    /**
     * The Limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Limit;
    /**
     * The IncludeDeactivatedForms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeDeactivatedForms;
    /**
     * The ExcludeActiveForms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludeActiveForms;
    /**
     * The IncludeChildForms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeChildForms;
    /**
     * The FolderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FolderId;
    /**
     * The SelectFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FormSelectFieldList
     */
    public $SelectFields;
    /**
     * The FormSearchType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormSearchType;
    /**
     * Constructor method for FormParams
     * @uses FormParams::setUsers()
     * @uses FormParams::setSearchQuery()
     * @uses FormParams::setIncludeFormsOfOtherSubunitAdministrators()
     * @uses FormParams::setOrderBy()
     * @uses FormParams::setOrderByDirection()
     * @uses FormParams::setLimit()
     * @uses FormParams::setIncludeDeactivatedForms()
     * @uses FormParams::setExcludeActiveForms()
     * @uses FormParams::setIncludeChildForms()
     * @uses FormParams::setFolderId()
     * @uses FormParams::setSelectFields()
     * @uses FormParams::setFormSearchType()
     * @param \StructType\StringList $users
     * @param string $searchQuery
     * @param bool $includeFormsOfOtherSubunitAdministrators
     * @param string $orderBy
     * @param string $orderByDirection
     * @param int $limit
     * @param bool $includeDeactivatedForms
     * @param bool $excludeActiveForms
     * @param bool $includeChildForms
     * @param int $folderId
     * @param \StructType\FormSelectFieldList $selectFields
     * @param string $formSearchType
     */
    public function __construct(\StructType\StringList $users = null, $searchQuery = null, $includeFormsOfOtherSubunitAdministrators = null, $orderBy = null, $orderByDirection = null, $limit = null, $includeDeactivatedForms = null, $excludeActiveForms = null, $includeChildForms = null, $folderId = null, \StructType\FormSelectFieldList $selectFields = null, $formSearchType = null)
    {
        $this
            ->setUsers($users)
            ->setSearchQuery($searchQuery)
            ->setIncludeFormsOfOtherSubunitAdministrators($includeFormsOfOtherSubunitAdministrators)
            ->setOrderBy($orderBy)
            ->setOrderByDirection($orderByDirection)
            ->setLimit($limit)
            ->setIncludeDeactivatedForms($includeDeactivatedForms)
            ->setExcludeActiveForms($excludeActiveForms)
            ->setIncludeChildForms($includeChildForms)
            ->setFolderId($folderId)
            ->setSelectFields($selectFields)
            ->setFormSearchType($formSearchType);
    }
    /**
     * Get Users value
     * @return \StructType\StringList
     */
    public function getUsers()
    {
        return $this->Users;
    }
    /**
     * Set Users value
     * @param \StructType\StringList $users
     * @return \StructType\FormParams
     */
    public function setUsers(\StructType\StringList $users = null)
    {
        $this->Users = $users;
        return $this;
    }
    /**
     * Get SearchQuery value
     * @return string|null
     */
    public function getSearchQuery()
    {
        return $this->SearchQuery;
    }
    /**
     * Set SearchQuery value
     * @param string $searchQuery
     * @return \StructType\FormParams
     */
    public function setSearchQuery($searchQuery = null)
    {
        // validation for constraint: string
        if (!is_null($searchQuery) && !is_string($searchQuery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchQuery)), __LINE__);
        }
        $this->SearchQuery = $searchQuery;
        return $this;
    }
    /**
     * Get IncludeFormsOfOtherSubunitAdministrators value
     * @return bool|null
     */
    public function getIncludeFormsOfOtherSubunitAdministrators()
    {
        return $this->IncludeFormsOfOtherSubunitAdministrators;
    }
    /**
     * Set IncludeFormsOfOtherSubunitAdministrators value
     * @param bool $includeFormsOfOtherSubunitAdministrators
     * @return \StructType\FormParams
     */
    public function setIncludeFormsOfOtherSubunitAdministrators($includeFormsOfOtherSubunitAdministrators = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFormsOfOtherSubunitAdministrators) && !is_bool($includeFormsOfOtherSubunitAdministrators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeFormsOfOtherSubunitAdministrators)), __LINE__);
        }
        $this->IncludeFormsOfOtherSubunitAdministrators = $includeFormsOfOtherSubunitAdministrators;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \StructType\FormParams
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
    /**
     * Get OrderByDirection value
     * @return string|null
     */
    public function getOrderByDirection()
    {
        return $this->OrderByDirection;
    }
    /**
     * Set OrderByDirection value
     * @param string $orderByDirection
     * @return \StructType\FormParams
     */
    public function setOrderByDirection($orderByDirection = null)
    {
        // validation for constraint: string
        if (!is_null($orderByDirection) && !is_string($orderByDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderByDirection)), __LINE__);
        }
        $this->OrderByDirection = $orderByDirection;
        return $this;
    }
    /**
     * Get Limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \StructType\FormParams
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get IncludeDeactivatedForms value
     * @return bool|null
     */
    public function getIncludeDeactivatedForms()
    {
        return $this->IncludeDeactivatedForms;
    }
    /**
     * Set IncludeDeactivatedForms value
     * @param bool $includeDeactivatedForms
     * @return \StructType\FormParams
     */
    public function setIncludeDeactivatedForms($includeDeactivatedForms = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDeactivatedForms) && !is_bool($includeDeactivatedForms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeDeactivatedForms)), __LINE__);
        }
        $this->IncludeDeactivatedForms = $includeDeactivatedForms;
        return $this;
    }
    /**
     * Get ExcludeActiveForms value
     * @return bool|null
     */
    public function getExcludeActiveForms()
    {
        return $this->ExcludeActiveForms;
    }
    /**
     * Set ExcludeActiveForms value
     * @param bool $excludeActiveForms
     * @return \StructType\FormParams
     */
    public function setExcludeActiveForms($excludeActiveForms = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeActiveForms) && !is_bool($excludeActiveForms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludeActiveForms)), __LINE__);
        }
        $this->ExcludeActiveForms = $excludeActiveForms;
        return $this;
    }
    /**
     * Get IncludeChildForms value
     * @return bool|null
     */
    public function getIncludeChildForms()
    {
        return $this->IncludeChildForms;
    }
    /**
     * Set IncludeChildForms value
     * @param bool $includeChildForms
     * @return \StructType\FormParams
     */
    public function setIncludeChildForms($includeChildForms = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildForms) && !is_bool($includeChildForms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeChildForms)), __LINE__);
        }
        $this->IncludeChildForms = $includeChildForms;
        return $this;
    }
    /**
     * Get FolderId value
     * @return int|null
     */
    public function getFolderId()
    {
        return $this->FolderId;
    }
    /**
     * Set FolderId value
     * @param int $folderId
     * @return \StructType\FormParams
     */
    public function setFolderId($folderId = null)
    {
        // validation for constraint: int
        if (!is_null($folderId) && !is_numeric($folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($folderId)), __LINE__);
        }
        $this->FolderId = $folderId;
        return $this;
    }
    /**
     * Get SelectFields value
     * @return \StructType\FormSelectFieldList|null
     */
    public function getSelectFields()
    {
        return $this->SelectFields;
    }
    /**
     * Set SelectFields value
     * @param \StructType\FormSelectFieldList $selectFields
     * @return \StructType\FormParams
     */
    public function setSelectFields(\StructType\FormSelectFieldList $selectFields = null)
    {
        $this->SelectFields = $selectFields;
        return $this;
    }
    /**
     * Get FormSearchType value
     * @return string|null
     */
    public function getFormSearchType()
    {
        return $this->FormSearchType;
    }
    /**
     * Set FormSearchType value
     * @uses \EnumType\FormSearchType::valueIsValid()
     * @uses \EnumType\FormSearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formSearchType
     * @return \StructType\FormParams
     */
    public function setFormSearchType($formSearchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormSearchType::valueIsValid($formSearchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $formSearchType, implode(', ', \EnumType\FormSearchType::getValidValues())), __LINE__);
        }
        $this->FormSearchType = $formSearchType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormParams
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
