<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormMainLanguage StructType
 * @subpackage Structs
 */
class FormMainLanguage extends AbstractStructBase
{
    /**
     * The FormId
     * @var int
     */
    public $FormId;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The PDFFilename
     * @var string
     */
    public $PDFFilename;
    /**
     * The LogoFile
     * @var string
     */
    public $LogoFile;
    /**
     * The SystemLanguage
     * @var int
     */
    public $SystemLanguage;
    /**
     * The IsEnabled
     * @var bool
     */
    public $IsEnabled;
    /**
     * The LanguageSet
     * @var int
     */
    public $LanguageSet;
    /**
     * The Abbreviation
     * @var string
     */
    public $Abbreviation;
    /**
     * Constructor method for FormMainLanguage
     * @uses FormMainLanguage::setFormId()
     * @uses FormMainLanguage::setName()
     * @uses FormMainLanguage::setPDFFilename()
     * @uses FormMainLanguage::setLogoFile()
     * @uses FormMainLanguage::setSystemLanguage()
     * @uses FormMainLanguage::setIsEnabled()
     * @uses FormMainLanguage::setLanguageSet()
     * @uses FormMainLanguage::setAbbreviation()
     * @param int $formId
     * @param string $name
     * @param string $pDFFilename
     * @param string $logoFile
     * @param int $systemLanguage
     * @param bool $isEnabled
     * @param int $languageSet
     * @param string $abbreviation
     */
    public function __construct($formId = null, $name = null, $pDFFilename = null, $logoFile = null, $systemLanguage = null, $isEnabled = null, $languageSet = null, $abbreviation = null)
    {
        $this
            ->setFormId($formId)
            ->setName($name)
            ->setPDFFilename($pDFFilename)
            ->setLogoFile($logoFile)
            ->setSystemLanguage($systemLanguage)
            ->setIsEnabled($isEnabled)
            ->setLanguageSet($languageSet)
            ->setAbbreviation($abbreviation);
    }
    /**
     * Get FormId value
     * @return int|null
     */
    public function getFormId()
    {
        return $this->FormId;
    }
    /**
     * Set FormId value
     * @param int $formId
     * @return \StructType\FormMainLanguage
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: int
        if (!is_null($formId) && !is_numeric($formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($formId)), __LINE__);
        }
        $this->FormId = $formId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\FormMainLanguage
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PDFFilename value
     * @return string|null
     */
    public function getPDFFilename()
    {
        return $this->PDFFilename;
    }
    /**
     * Set PDFFilename value
     * @param string $pDFFilename
     * @return \StructType\FormMainLanguage
     */
    public function setPDFFilename($pDFFilename = null)
    {
        // validation for constraint: string
        if (!is_null($pDFFilename) && !is_string($pDFFilename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pDFFilename)), __LINE__);
        }
        $this->PDFFilename = $pDFFilename;
        return $this;
    }
    /**
     * Get LogoFile value
     * @return string|null
     */
    public function getLogoFile()
    {
        return $this->LogoFile;
    }
    /**
     * Set LogoFile value
     * @param string $logoFile
     * @return \StructType\FormMainLanguage
     */
    public function setLogoFile($logoFile = null)
    {
        // validation for constraint: string
        if (!is_null($logoFile) && !is_string($logoFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logoFile)), __LINE__);
        }
        $this->LogoFile = $logoFile;
        return $this;
    }
    /**
     * Get SystemLanguage value
     * @return int|null
     */
    public function getSystemLanguage()
    {
        return $this->SystemLanguage;
    }
    /**
     * Set SystemLanguage value
     * @param int $systemLanguage
     * @return \StructType\FormMainLanguage
     */
    public function setSystemLanguage($systemLanguage = null)
    {
        // validation for constraint: int
        if (!is_null($systemLanguage) && !is_numeric($systemLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemLanguage)), __LINE__);
        }
        $this->SystemLanguage = $systemLanguage;
        return $this;
    }
    /**
     * Get IsEnabled value
     * @return bool|null
     */
    public function getIsEnabled()
    {
        return $this->IsEnabled;
    }
    /**
     * Set IsEnabled value
     * @param bool $isEnabled
     * @return \StructType\FormMainLanguage
     */
    public function setIsEnabled($isEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnabled) && !is_bool($isEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEnabled)), __LINE__);
        }
        $this->IsEnabled = $isEnabled;
        return $this;
    }
    /**
     * Get LanguageSet value
     * @return int|null
     */
    public function getLanguageSet()
    {
        return $this->LanguageSet;
    }
    /**
     * Set LanguageSet value
     * @param int $languageSet
     * @return \StructType\FormMainLanguage
     */
    public function setLanguageSet($languageSet = null)
    {
        // validation for constraint: int
        if (!is_null($languageSet) && !is_numeric($languageSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageSet)), __LINE__);
        }
        $this->LanguageSet = $languageSet;
        return $this;
    }
    /**
     * Get Abbreviation value
     * @return string|null
     */
    public function getAbbreviation()
    {
        return $this->Abbreviation;
    }
    /**
     * Set Abbreviation value
     * @param string $abbreviation
     * @return \StructType\FormMainLanguage
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviation)), __LINE__);
        }
        $this->Abbreviation = $abbreviation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormMainLanguage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
