<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FolderList StructType
 * @subpackage Structs
 */
class FolderList extends AbstractStructBase
{
    /**
     * The Folders
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Folder[]
     */
    public $Folders;
    /**
     * Constructor method for FolderList
     * @uses FolderList::setFolders()
     * @param \StructType\Folder[] $folders
     */
    public function __construct(array $folders = array())
    {
        $this
            ->setFolders($folders);
    }
    /**
     * Get Folders value
     * @return \StructType\Folder[]|null
     */
    public function getFolders()
    {
        return $this->Folders;
    }
    /**
     * Set Folders value
     * @throws \InvalidArgumentException
     * @param \StructType\Folder[] $folders
     * @return \StructType\FolderList
     */
    public function setFolders(array $folders = array())
    {
        foreach ($folders as $folderListFoldersItem) {
            // validation for constraint: itemType
            if (!$folderListFoldersItem instanceof \StructType\Folder) {
                throw new \InvalidArgumentException(sprintf('The Folders property can only contain items of \StructType\Folder, "%s" given', is_object($folderListFoldersItem) ? get_class($folderListFoldersItem) : gettype($folderListFoldersItem)), __LINE__);
            }
        }
        $this->Folders = $folders;
        return $this;
    }
    /**
     * Add item to Folders value
     * @throws \InvalidArgumentException
     * @param \StructType\Folder $item
     * @return \StructType\FolderList
     */
    public function addToFolders(\StructType\Folder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Folder) {
            throw new \InvalidArgumentException(sprintf('The Folders property can only contain items of \StructType\Folder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Folders[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FolderList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
