<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Folder StructType
 * @subpackage Structs
 */
class Folder extends AbstractStructBase
{
    /**
     * The FolderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FolderId;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserId;
    /**
     * The DirTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DirTypeId;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The FolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FolderName;
    /**
     * Constructor method for Folder
     * @uses Folder::setFolderId()
     * @uses Folder::setUserId()
     * @uses Folder::setDirTypeId()
     * @uses Folder::setCreateDate()
     * @uses Folder::setFolderName()
     * @param int $folderId
     * @param int $userId
     * @param int $dirTypeId
     * @param string $createDate
     * @param string $folderName
     */
    public function __construct($folderId = null, $userId = null, $dirTypeId = null, $createDate = null, $folderName = null)
    {
        $this
            ->setFolderId($folderId)
            ->setUserId($userId)
            ->setDirTypeId($dirTypeId)
            ->setCreateDate($createDate)
            ->setFolderName($folderName);
    }
    /**
     * Get FolderId value
     * @return int
     */
    public function getFolderId()
    {
        return $this->FolderId;
    }
    /**
     * Set FolderId value
     * @param int $folderId
     * @return \StructType\Folder
     */
    public function setFolderId($folderId = null)
    {
        // validation for constraint: int
        if (!is_null($folderId) && !is_numeric($folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($folderId)), __LINE__);
        }
        $this->FolderId = $folderId;
        return $this;
    }
    /**
     * Get UserId value
     * @return int
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \StructType\Folder
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !is_numeric($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get DirTypeId value
     * @return int
     */
    public function getDirTypeId()
    {
        return $this->DirTypeId;
    }
    /**
     * Set DirTypeId value
     * @param int $dirTypeId
     * @return \StructType\Folder
     */
    public function setDirTypeId($dirTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($dirTypeId) && !is_numeric($dirTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dirTypeId)), __LINE__);
        }
        $this->DirTypeId = $dirTypeId;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Folder
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get FolderName value
     * @return string|null
     */
    public function getFolderName()
    {
        return $this->FolderName;
    }
    /**
     * Set FolderName value
     * @param string $folderName
     * @return \StructType\Folder
     */
    public function setFolderName($folderName = null)
    {
        // validation for constraint: string
        if (!is_null($folderName) && !is_string($folderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($folderName)), __LINE__);
        }
        $this->FolderName = $folderName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Folder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
