<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterSetList StructType
 * @subpackage Structs
 */
class FilterSetList extends AbstractStructBase
{
    /**
     * The FilterSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\FilterSet[]
     */
    public $FilterSet;
    /**
     * Constructor method for FilterSetList
     * @uses FilterSetList::setFilterSet()
     * @param \StructType\FilterSet[] $filterSet
     */
    public function __construct(array $filterSet = array())
    {
        $this
            ->setFilterSet($filterSet);
    }
    /**
     * Get FilterSet value
     * @return \StructType\FilterSet[]
     */
    public function getFilterSet()
    {
        return $this->FilterSet;
    }
    /**
     * Set FilterSet value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterSet[] $filterSet
     * @return \StructType\FilterSetList
     */
    public function setFilterSet(array $filterSet = array())
    {
        foreach ($filterSet as $filterSetListFilterSetItem) {
            // validation for constraint: itemType
            if (!$filterSetListFilterSetItem instanceof \StructType\FilterSet) {
                throw new \InvalidArgumentException(sprintf('The FilterSet property can only contain items of \StructType\FilterSet, "%s" given', is_object($filterSetListFilterSetItem) ? get_class($filterSetListFilterSetItem) : gettype($filterSetListFilterSetItem)), __LINE__);
            }
        }
        $this->FilterSet = $filterSet;
        return $this;
    }
    /**
     * Add item to FilterSet value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterSet $item
     * @return \StructType\FilterSetList
     */
    public function addToFilterSet(\StructType\FilterSet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FilterSet) {
            throw new \InvalidArgumentException(sprintf('The FilterSet property can only contain items of \StructType\FilterSet, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FilterSet[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterSetList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
