<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterSet StructType
 * @subpackage Structs
 */
class FilterSet extends AbstractStructBase
{
    /**
     * The TriggerItemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TriggerItemId;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Action;
    /**
     * The TargetItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\IDList
     */
    public $TargetItems;
    /**
     * The TriggerValues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ValueList
     */
    public $TriggerValues;
    /**
     * The IsInitialFilterSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsInitialFilterSet;
    /**
     * The Operator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Operator;
    /**
     * Constructor method for FilterSet
     * @uses FilterSet::setTriggerItemId()
     * @uses FilterSet::setAction()
     * @uses FilterSet::setTargetItems()
     * @uses FilterSet::setTriggerValues()
     * @uses FilterSet::setIsInitialFilterSet()
     * @uses FilterSet::setOperator()
     * @param int $triggerItemId
     * @param int $action
     * @param \StructType\IDList $targetItems
     * @param \StructType\ValueList $triggerValues
     * @param bool $isInitialFilterSet
     * @param int $operator
     */
    public function __construct($triggerItemId = null, $action = null, \StructType\IDList $targetItems = null, \StructType\ValueList $triggerValues = null, $isInitialFilterSet = null, $operator = null)
    {
        $this
            ->setTriggerItemId($triggerItemId)
            ->setAction($action)
            ->setTargetItems($targetItems)
            ->setTriggerValues($triggerValues)
            ->setIsInitialFilterSet($isInitialFilterSet)
            ->setOperator($operator);
    }
    /**
     * Get TriggerItemId value
     * @return int
     */
    public function getTriggerItemId()
    {
        return $this->TriggerItemId;
    }
    /**
     * Set TriggerItemId value
     * @param int $triggerItemId
     * @return \StructType\FilterSet
     */
    public function setTriggerItemId($triggerItemId = null)
    {
        // validation for constraint: int
        if (!is_null($triggerItemId) && !is_numeric($triggerItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($triggerItemId)), __LINE__);
        }
        $this->TriggerItemId = $triggerItemId;
        return $this;
    }
    /**
     * Get Action value
     * @return int
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param int $action
     * @return \StructType\FilterSet
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !is_numeric($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get TargetItems value
     * @return \StructType\IDList
     */
    public function getTargetItems()
    {
        return $this->TargetItems;
    }
    /**
     * Set TargetItems value
     * @param \StructType\IDList $targetItems
     * @return \StructType\FilterSet
     */
    public function setTargetItems(\StructType\IDList $targetItems = null)
    {
        $this->TargetItems = $targetItems;
        return $this;
    }
    /**
     * Get TriggerValues value
     * @return \StructType\ValueList|null
     */
    public function getTriggerValues()
    {
        return $this->TriggerValues;
    }
    /**
     * Set TriggerValues value
     * @param \StructType\ValueList $triggerValues
     * @return \StructType\FilterSet
     */
    public function setTriggerValues(\StructType\ValueList $triggerValues = null)
    {
        $this->TriggerValues = $triggerValues;
        return $this;
    }
    /**
     * Get IsInitialFilterSet value
     * @return bool|null
     */
    public function getIsInitialFilterSet()
    {
        return $this->IsInitialFilterSet;
    }
    /**
     * Set IsInitialFilterSet value
     * @param bool $isInitialFilterSet
     * @return \StructType\FilterSet
     */
    public function setIsInitialFilterSet($isInitialFilterSet = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInitialFilterSet) && !is_bool($isInitialFilterSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isInitialFilterSet)), __LINE__);
        }
        $this->IsInitialFilterSet = $isInitialFilterSet;
        return $this;
    }
    /**
     * Get Operator value
     * @return int|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @param int $operator
     * @return \StructType\FilterSet
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: int
        if (!is_null($operator) && !is_numeric($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($operator)), __LINE__);
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
