<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityList StructType
 * @subpackage Structs
 */
class EntityList extends AbstractStructBase
{
    /**
     * The EntityListValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $EntityListValue;
    /**
     * Constructor method for EntityList
     * @uses EntityList::setEntityListValue()
     * @param string[] $entityListValue
     */
    public function __construct(array $entityListValue = array())
    {
        $this
            ->setEntityListValue($entityListValue);
    }
    /**
     * Get EntityListValue value
     * @return string[]|null
     */
    public function getEntityListValue()
    {
        return $this->EntityListValue;
    }
    /**
     * Set EntityListValue value
     * @uses \EnumType\EntityListValue::valueIsValid()
     * @uses \EnumType\EntityListValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $entityListValue
     * @return \StructType\EntityList
     */
    public function setEntityListValue(array $entityListValue = array())
    {
        $invalidValues = array();
        foreach ($entityListValue as $entityListEntityListValueItem) {
            if (!\EnumType\EntityListValue::valueIsValid($entityListEntityListValueItem)) {
                $invalidValues[] = var_export($entityListEntityListValueItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\EntityListValue::getValidValues())), __LINE__);
        }
        $this->EntityListValue = $entityListValue;
        return $this;
    }
    /**
     * Add item to EntityListValue value
     * @uses \EnumType\EntityListValue::valueIsValid()
     * @uses \EnumType\EntityListValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EntityList
     */
    public function addToEntityListValue($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityListValue::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\EntityListValue::getValidValues())), __LINE__);
        }
        $this->EntityListValue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
