<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomUserSettingsList StructType
 * @subpackage Structs
 */
class CustomUserSettingsList extends AbstractStructBase
{
    /**
     * The CustomUserSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomUserSetting[]
     */
    public $CustomUserSetting;
    /**
     * Constructor method for CustomUserSettingsList
     * @uses CustomUserSettingsList::setCustomUserSetting()
     * @param \StructType\CustomUserSetting[] $customUserSetting
     */
    public function __construct(array $customUserSetting = array())
    {
        $this
            ->setCustomUserSetting($customUserSetting);
    }
    /**
     * Get CustomUserSetting value
     * @return \StructType\CustomUserSetting[]|null
     */
    public function getCustomUserSetting()
    {
        return $this->CustomUserSetting;
    }
    /**
     * Set CustomUserSetting value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomUserSetting[] $customUserSetting
     * @return \StructType\CustomUserSettingsList
     */
    public function setCustomUserSetting(array $customUserSetting = array())
    {
        foreach ($customUserSetting as $customUserSettingsListCustomUserSettingItem) {
            // validation for constraint: itemType
            if (!$customUserSettingsListCustomUserSettingItem instanceof \StructType\CustomUserSetting) {
                throw new \InvalidArgumentException(sprintf('The CustomUserSetting property can only contain items of \StructType\CustomUserSetting, "%s" given', is_object($customUserSettingsListCustomUserSettingItem) ? get_class($customUserSettingsListCustomUserSettingItem) : gettype($customUserSettingsListCustomUserSettingItem)), __LINE__);
            }
        }
        $this->CustomUserSetting = $customUserSetting;
        return $this;
    }
    /**
     * Add item to CustomUserSetting value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomUserSetting $item
     * @return \StructType\CustomUserSettingsList
     */
    public function addToCustomUserSetting(\StructType\CustomUserSetting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomUserSetting) {
            throw new \InvalidArgumentException(sprintf('The CustomUserSetting property can only contain items of \StructType\CustomUserSetting, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomUserSetting[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomUserSettingsList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
