<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomUserSetting StructType
 * @subpackage Structs
 */
class CustomUserSetting extends AbstractStructBase
{
    /**
     * The SettingKey
     * @var string
     */
    public $SettingKey;
    /**
     * The SettingValue
     * @var string
     */
    public $SettingValue;
    /**
     * Constructor method for CustomUserSetting
     * @uses CustomUserSetting::setSettingKey()
     * @uses CustomUserSetting::setSettingValue()
     * @param string $settingKey
     * @param string $settingValue
     */
    public function __construct($settingKey = null, $settingValue = null)
    {
        $this
            ->setSettingKey($settingKey)
            ->setSettingValue($settingValue);
    }
    /**
     * Get SettingKey value
     * @return string|null
     */
    public function getSettingKey()
    {
        return $this->SettingKey;
    }
    /**
     * Set SettingKey value
     * @param string $settingKey
     * @return \StructType\CustomUserSetting
     */
    public function setSettingKey($settingKey = null)
    {
        // validation for constraint: string
        if (!is_null($settingKey) && !is_string($settingKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($settingKey)), __LINE__);
        }
        $this->SettingKey = $settingKey;
        return $this;
    }
    /**
     * Get SettingValue value
     * @return string|null
     */
    public function getSettingValue()
    {
        return $this->SettingValue;
    }
    /**
     * Set SettingValue value
     * @param string $settingValue
     * @return \StructType\CustomUserSetting
     */
    public function setSettingValue($settingValue = null)
    {
        // validation for constraint: string
        if (!is_null($settingValue) && !is_string($settingValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($settingValue)), __LINE__);
        }
        $this->SettingValue = $settingValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomUserSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
