<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CourseParams StructType
 * @subpackage Structs
 */
class CourseParams extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The CourseIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $CourseIds;
    /**
     * The Instructors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Instructors;
    /**
     * The Subunits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Subunits;
    /**
     * The Periods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Periods;
    /**
     * The CourseTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $CourseTypes;
    /**
     * The ProgramOfStudies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramOfStudies;
    /**
     * The CourseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CourseCode;
    /**
     * The Room
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Room;
    /**
     * The ExternalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalID;
    /**
     * The CustomFieldEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomFieldEntry;
    /**
     * The Limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Limit;
    /**
     * The OrderBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * The OrderByDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderByDirection;
    /**
     * The ExtendedResponseAsJSON
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExtendedResponseAsJSON;
    /**
     * Constructor method for CourseParams
     * @uses CourseParams::setName()
     * @uses CourseParams::setCourseIds()
     * @uses CourseParams::setInstructors()
     * @uses CourseParams::setSubunits()
     * @uses CourseParams::setPeriods()
     * @uses CourseParams::setCourseTypes()
     * @uses CourseParams::setProgramOfStudies()
     * @uses CourseParams::setCourseCode()
     * @uses CourseParams::setRoom()
     * @uses CourseParams::setExternalID()
     * @uses CourseParams::setCustomFieldEntry()
     * @uses CourseParams::setLimit()
     * @uses CourseParams::setOrderBy()
     * @uses CourseParams::setOrderByDirection()
     * @uses CourseParams::setExtendedResponseAsJSON()
     * @param string $name
     * @param \StructType\StringList $courseIds
     * @param \StructType\StringList $instructors
     * @param \StructType\StringList $subunits
     * @param \StructType\StringList $periods
     * @param \StructType\StringList $courseTypes
     * @param string $programOfStudies
     * @param string $courseCode
     * @param string $room
     * @param string $externalID
     * @param string $customFieldEntry
     * @param int $limit
     * @param string $orderBy
     * @param string $orderByDirection
     * @param bool $extendedResponseAsJSON
     */
    public function __construct($name = null, \StructType\StringList $courseIds = null, \StructType\StringList $instructors = null, \StructType\StringList $subunits = null, \StructType\StringList $periods = null, \StructType\StringList $courseTypes = null, $programOfStudies = null, $courseCode = null, $room = null, $externalID = null, $customFieldEntry = null, $limit = null, $orderBy = null, $orderByDirection = null, $extendedResponseAsJSON = null)
    {
        $this
            ->setName($name)
            ->setCourseIds($courseIds)
            ->setInstructors($instructors)
            ->setSubunits($subunits)
            ->setPeriods($periods)
            ->setCourseTypes($courseTypes)
            ->setProgramOfStudies($programOfStudies)
            ->setCourseCode($courseCode)
            ->setRoom($room)
            ->setExternalID($externalID)
            ->setCustomFieldEntry($customFieldEntry)
            ->setLimit($limit)
            ->setOrderBy($orderBy)
            ->setOrderByDirection($orderByDirection)
            ->setExtendedResponseAsJSON($extendedResponseAsJSON);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CourseParams
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CourseIds value
     * @return \StructType\StringList|null
     */
    public function getCourseIds()
    {
        return $this->CourseIds;
    }
    /**
     * Set CourseIds value
     * @param \StructType\StringList $courseIds
     * @return \StructType\CourseParams
     */
    public function setCourseIds(\StructType\StringList $courseIds = null)
    {
        $this->CourseIds = $courseIds;
        return $this;
    }
    /**
     * Get Instructors value
     * @return \StructType\StringList|null
     */
    public function getInstructors()
    {
        return $this->Instructors;
    }
    /**
     * Set Instructors value
     * @param \StructType\StringList $instructors
     * @return \StructType\CourseParams
     */
    public function setInstructors(\StructType\StringList $instructors = null)
    {
        $this->Instructors = $instructors;
        return $this;
    }
    /**
     * Get Subunits value
     * @return \StructType\StringList|null
     */
    public function getSubunits()
    {
        return $this->Subunits;
    }
    /**
     * Set Subunits value
     * @param \StructType\StringList $subunits
     * @return \StructType\CourseParams
     */
    public function setSubunits(\StructType\StringList $subunits = null)
    {
        $this->Subunits = $subunits;
        return $this;
    }
    /**
     * Get Periods value
     * @return \StructType\StringList|null
     */
    public function getPeriods()
    {
        return $this->Periods;
    }
    /**
     * Set Periods value
     * @param \StructType\StringList $periods
     * @return \StructType\CourseParams
     */
    public function setPeriods(\StructType\StringList $periods = null)
    {
        $this->Periods = $periods;
        return $this;
    }
    /**
     * Get CourseTypes value
     * @return \StructType\StringList|null
     */
    public function getCourseTypes()
    {
        return $this->CourseTypes;
    }
    /**
     * Set CourseTypes value
     * @param \StructType\StringList $courseTypes
     * @return \StructType\CourseParams
     */
    public function setCourseTypes(\StructType\StringList $courseTypes = null)
    {
        $this->CourseTypes = $courseTypes;
        return $this;
    }
    /**
     * Get ProgramOfStudies value
     * @return string|null
     */
    public function getProgramOfStudies()
    {
        return $this->ProgramOfStudies;
    }
    /**
     * Set ProgramOfStudies value
     * @param string $programOfStudies
     * @return \StructType\CourseParams
     */
    public function setProgramOfStudies($programOfStudies = null)
    {
        // validation for constraint: string
        if (!is_null($programOfStudies) && !is_string($programOfStudies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programOfStudies)), __LINE__);
        }
        $this->ProgramOfStudies = $programOfStudies;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string|null
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\CourseParams
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Get Room value
     * @return string|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param string $room
     * @return \StructType\CourseParams
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($room)), __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Get ExternalID value
     * @return string|null
     */
    public function getExternalID()
    {
        return $this->ExternalID;
    }
    /**
     * Set ExternalID value
     * @param string $externalID
     * @return \StructType\CourseParams
     */
    public function setExternalID($externalID = null)
    {
        // validation for constraint: string
        if (!is_null($externalID) && !is_string($externalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalID)), __LINE__);
        }
        $this->ExternalID = $externalID;
        return $this;
    }
    /**
     * Get CustomFieldEntry value
     * @return string|null
     */
    public function getCustomFieldEntry()
    {
        return $this->CustomFieldEntry;
    }
    /**
     * Set CustomFieldEntry value
     * @param string $customFieldEntry
     * @return \StructType\CourseParams
     */
    public function setCustomFieldEntry($customFieldEntry = null)
    {
        // validation for constraint: string
        if (!is_null($customFieldEntry) && !is_string($customFieldEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customFieldEntry)), __LINE__);
        }
        $this->CustomFieldEntry = $customFieldEntry;
        return $this;
    }
    /**
     * Get Limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \StructType\CourseParams
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \StructType\CourseParams
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
    /**
     * Get OrderByDirection value
     * @return string|null
     */
    public function getOrderByDirection()
    {
        return $this->OrderByDirection;
    }
    /**
     * Set OrderByDirection value
     * @param string $orderByDirection
     * @return \StructType\CourseParams
     */
    public function setOrderByDirection($orderByDirection = null)
    {
        // validation for constraint: string
        if (!is_null($orderByDirection) && !is_string($orderByDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderByDirection)), __LINE__);
        }
        $this->OrderByDirection = $orderByDirection;
        return $this;
    }
    /**
     * Get ExtendedResponseAsJSON value
     * @return bool|null
     */
    public function getExtendedResponseAsJSON()
    {
        return $this->ExtendedResponseAsJSON;
    }
    /**
     * Set ExtendedResponseAsJSON value
     * @param bool $extendedResponseAsJSON
     * @return \StructType\CourseParams
     */
    public function setExtendedResponseAsJSON($extendedResponseAsJSON = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedResponseAsJSON) && !is_bool($extendedResponseAsJSON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extendedResponseAsJSON)), __LINE__);
        }
        $this->ExtendedResponseAsJSON = $extendedResponseAsJSON;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CourseParams
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
