<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CourseCreatorList StructType
 * @subpackage Structs
 */
class CourseCreatorList extends AbstractStructBase
{
    /**
     * The CourseCreators
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\CourseCreator[]
     */
    public $CourseCreators;
    /**
     * Constructor method for CourseCreatorList
     * @uses CourseCreatorList::setCourseCreators()
     * @param \StructType\CourseCreator[] $courseCreators
     */
    public function __construct(array $courseCreators = array())
    {
        $this
            ->setCourseCreators($courseCreators);
    }
    /**
     * Get CourseCreators value
     * @return \StructType\CourseCreator[]
     */
    public function getCourseCreators()
    {
        return $this->CourseCreators;
    }
    /**
     * Set CourseCreators value
     * @throws \InvalidArgumentException
     * @param \StructType\CourseCreator[] $courseCreators
     * @return \StructType\CourseCreatorList
     */
    public function setCourseCreators(array $courseCreators = array())
    {
        foreach ($courseCreators as $courseCreatorListCourseCreatorsItem) {
            // validation for constraint: itemType
            if (!$courseCreatorListCourseCreatorsItem instanceof \StructType\CourseCreator) {
                throw new \InvalidArgumentException(sprintf('The CourseCreators property can only contain items of \StructType\CourseCreator, "%s" given', is_object($courseCreatorListCourseCreatorsItem) ? get_class($courseCreatorListCourseCreatorsItem) : gettype($courseCreatorListCourseCreatorsItem)), __LINE__);
            }
        }
        $this->CourseCreators = $courseCreators;
        return $this;
    }
    /**
     * Add item to CourseCreators value
     * @throws \InvalidArgumentException
     * @param \StructType\CourseCreator $item
     * @return \StructType\CourseCreatorList
     */
    public function addToCourseCreators(\StructType\CourseCreator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CourseCreator) {
            throw new \InvalidArgumentException(sprintf('The CourseCreators property can only contain items of \StructType\CourseCreator, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CourseCreators[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CourseCreatorList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
