<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CourseCreator StructType
 * @subpackage Structs
 */
class CourseCreator extends AbstractStructBase
{
    /**
     * The CourseUid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CourseUid;
    /**
     * The CourseName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CourseName;
    /**
     * The CourseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CourseCode;
    /**
     * The CourseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CourseType;
    /**
     * The InstructorList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\InstructorList
     */
    public $InstructorList;
    /**
     * The SubunitName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SubunitName;
    /**
     * The CourseProgramOfStudy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CourseProgramOfStudy;
    /**
     * The CourseEnrollment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CourseEnrollment;
    /**
     * The CustomFieldsJSON
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomFieldsJSON;
    /**
     * The CoursePeriodId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoursePeriodId;
    /**
     * The CoursePeriodIdType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoursePeriodIdType;
    /**
     * The RoomName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomName;
    /**
     * The ParticipantList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonList
     */
    public $ParticipantList;
    /**
     * The AnonymousParticipants
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AnonymousParticipants;
    /**
     * The SurveyCreatorList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SurveyCreatorList
     */
    public $SurveyCreatorList;
    /**
     * Constructor method for CourseCreator
     * @uses CourseCreator::setCourseUid()
     * @uses CourseCreator::setCourseName()
     * @uses CourseCreator::setCourseCode()
     * @uses CourseCreator::setCourseType()
     * @uses CourseCreator::setInstructorList()
     * @uses CourseCreator::setSubunitName()
     * @uses CourseCreator::setCourseProgramOfStudy()
     * @uses CourseCreator::setCourseEnrollment()
     * @uses CourseCreator::setCustomFieldsJSON()
     * @uses CourseCreator::setCoursePeriodId()
     * @uses CourseCreator::setCoursePeriodIdType()
     * @uses CourseCreator::setRoomName()
     * @uses CourseCreator::setParticipantList()
     * @uses CourseCreator::setAnonymousParticipants()
     * @uses CourseCreator::setSurveyCreatorList()
     * @param string $courseUid
     * @param string $courseName
     * @param string $courseCode
     * @param string $courseType
     * @param \StructType\InstructorList $instructorList
     * @param string $subunitName
     * @param string $courseProgramOfStudy
     * @param int $courseEnrollment
     * @param string $customFieldsJSON
     * @param string $coursePeriodId
     * @param string $coursePeriodIdType
     * @param string $roomName
     * @param \StructType\PersonList $participantList
     * @param bool $anonymousParticipants
     * @param \StructType\SurveyCreatorList $surveyCreatorList
     */
    public function __construct($courseUid = null, $courseName = null, $courseCode = null, $courseType = null, \StructType\InstructorList $instructorList = null, $subunitName = null, $courseProgramOfStudy = null, $courseEnrollment = null, $customFieldsJSON = null, $coursePeriodId = null, $coursePeriodIdType = null, $roomName = null, \StructType\PersonList $participantList = null, $anonymousParticipants = null, \StructType\SurveyCreatorList $surveyCreatorList = null)
    {
        $this
            ->setCourseUid($courseUid)
            ->setCourseName($courseName)
            ->setCourseCode($courseCode)
            ->setCourseType($courseType)
            ->setInstructorList($instructorList)
            ->setSubunitName($subunitName)
            ->setCourseProgramOfStudy($courseProgramOfStudy)
            ->setCourseEnrollment($courseEnrollment)
            ->setCustomFieldsJSON($customFieldsJSON)
            ->setCoursePeriodId($coursePeriodId)
            ->setCoursePeriodIdType($coursePeriodIdType)
            ->setRoomName($roomName)
            ->setParticipantList($participantList)
            ->setAnonymousParticipants($anonymousParticipants)
            ->setSurveyCreatorList($surveyCreatorList);
    }
    /**
     * Get CourseUid value
     * @return string
     */
    public function getCourseUid()
    {
        return $this->CourseUid;
    }
    /**
     * Set CourseUid value
     * @param string $courseUid
     * @return \StructType\CourseCreator
     */
    public function setCourseUid($courseUid = null)
    {
        // validation for constraint: string
        if (!is_null($courseUid) && !is_string($courseUid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseUid)), __LINE__);
        }
        $this->CourseUid = $courseUid;
        return $this;
    }
    /**
     * Get CourseName value
     * @return string
     */
    public function getCourseName()
    {
        return $this->CourseName;
    }
    /**
     * Set CourseName value
     * @param string $courseName
     * @return \StructType\CourseCreator
     */
    public function setCourseName($courseName = null)
    {
        // validation for constraint: string
        if (!is_null($courseName) && !is_string($courseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseName)), __LINE__);
        }
        $this->CourseName = $courseName;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\CourseCreator
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Get CourseType value
     * @return string
     */
    public function getCourseType()
    {
        return $this->CourseType;
    }
    /**
     * Set CourseType value
     * @param string $courseType
     * @return \StructType\CourseCreator
     */
    public function setCourseType($courseType = null)
    {
        // validation for constraint: string
        if (!is_null($courseType) && !is_string($courseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseType)), __LINE__);
        }
        $this->CourseType = $courseType;
        return $this;
    }
    /**
     * Get InstructorList value
     * @return \StructType\InstructorList
     */
    public function getInstructorList()
    {
        return $this->InstructorList;
    }
    /**
     * Set InstructorList value
     * @param \StructType\InstructorList $instructorList
     * @return \StructType\CourseCreator
     */
    public function setInstructorList(\StructType\InstructorList $instructorList = null)
    {
        $this->InstructorList = $instructorList;
        return $this;
    }
    /**
     * Get SubunitName value
     * @return string
     */
    public function getSubunitName()
    {
        return $this->SubunitName;
    }
    /**
     * Set SubunitName value
     * @param string $subunitName
     * @return \StructType\CourseCreator
     */
    public function setSubunitName($subunitName = null)
    {
        // validation for constraint: string
        if (!is_null($subunitName) && !is_string($subunitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subunitName)), __LINE__);
        }
        $this->SubunitName = $subunitName;
        return $this;
    }
    /**
     * Get CourseProgramOfStudy value
     * @return string|null
     */
    public function getCourseProgramOfStudy()
    {
        return $this->CourseProgramOfStudy;
    }
    /**
     * Set CourseProgramOfStudy value
     * @param string $courseProgramOfStudy
     * @return \StructType\CourseCreator
     */
    public function setCourseProgramOfStudy($courseProgramOfStudy = null)
    {
        // validation for constraint: string
        if (!is_null($courseProgramOfStudy) && !is_string($courseProgramOfStudy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseProgramOfStudy)), __LINE__);
        }
        $this->CourseProgramOfStudy = $courseProgramOfStudy;
        return $this;
    }
    /**
     * Get CourseEnrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCourseEnrollment()
    {
        return isset($this->CourseEnrollment) ? $this->CourseEnrollment : null;
    }
    /**
     * Set CourseEnrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $courseEnrollment
     * @return \StructType\CourseCreator
     */
    public function setCourseEnrollment($courseEnrollment = null)
    {
        // validation for constraint: int
        if (!is_null($courseEnrollment) && !is_numeric($courseEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($courseEnrollment)), __LINE__);
        }
        if (is_null($courseEnrollment) || (is_array($courseEnrollment) && empty($courseEnrollment))) {
            unset($this->CourseEnrollment);
        } else {
            $this->CourseEnrollment = $courseEnrollment;
        }
        return $this;
    }
    /**
     * Get CustomFieldsJSON value
     * @return string|null
     */
    public function getCustomFieldsJSON()
    {
        return $this->CustomFieldsJSON;
    }
    /**
     * Set CustomFieldsJSON value
     * @param string $customFieldsJSON
     * @return \StructType\CourseCreator
     */
    public function setCustomFieldsJSON($customFieldsJSON = null)
    {
        // validation for constraint: string
        if (!is_null($customFieldsJSON) && !is_string($customFieldsJSON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customFieldsJSON)), __LINE__);
        }
        $this->CustomFieldsJSON = $customFieldsJSON;
        return $this;
    }
    /**
     * Get CoursePeriodId value
     * @return string|null
     */
    public function getCoursePeriodId()
    {
        return $this->CoursePeriodId;
    }
    /**
     * Set CoursePeriodId value
     * @param string $coursePeriodId
     * @return \StructType\CourseCreator
     */
    public function setCoursePeriodId($coursePeriodId = null)
    {
        // validation for constraint: string
        if (!is_null($coursePeriodId) && !is_string($coursePeriodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coursePeriodId)), __LINE__);
        }
        $this->CoursePeriodId = $coursePeriodId;
        return $this;
    }
    /**
     * Get CoursePeriodIdType value
     * @return string|null
     */
    public function getCoursePeriodIdType()
    {
        return $this->CoursePeriodIdType;
    }
    /**
     * Set CoursePeriodIdType value
     * @uses \EnumType\PeriodIdType::valueIsValid()
     * @uses \EnumType\PeriodIdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $coursePeriodIdType
     * @return \StructType\CourseCreator
     */
    public function setCoursePeriodIdType($coursePeriodIdType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PeriodIdType::valueIsValid($coursePeriodIdType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $coursePeriodIdType, implode(', ', \EnumType\PeriodIdType::getValidValues())), __LINE__);
        }
        $this->CoursePeriodIdType = $coursePeriodIdType;
        return $this;
    }
    /**
     * Get RoomName value
     * @return string|null
     */
    public function getRoomName()
    {
        return $this->RoomName;
    }
    /**
     * Set RoomName value
     * @param string $roomName
     * @return \StructType\CourseCreator
     */
    public function setRoomName($roomName = null)
    {
        // validation for constraint: string
        if (!is_null($roomName) && !is_string($roomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomName)), __LINE__);
        }
        $this->RoomName = $roomName;
        return $this;
    }
    /**
     * Get ParticipantList value
     * @return \StructType\PersonList|null
     */
    public function getParticipantList()
    {
        return $this->ParticipantList;
    }
    /**
     * Set ParticipantList value
     * @param \StructType\PersonList $participantList
     * @return \StructType\CourseCreator
     */
    public function setParticipantList(\StructType\PersonList $participantList = null)
    {
        $this->ParticipantList = $participantList;
        return $this;
    }
    /**
     * Get AnonymousParticipants value
     * @return bool|null
     */
    public function getAnonymousParticipants()
    {
        return $this->AnonymousParticipants;
    }
    /**
     * Set AnonymousParticipants value
     * @param bool $anonymousParticipants
     * @return \StructType\CourseCreator
     */
    public function setAnonymousParticipants($anonymousParticipants = null)
    {
        // validation for constraint: boolean
        if (!is_null($anonymousParticipants) && !is_bool($anonymousParticipants)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($anonymousParticipants)), __LINE__);
        }
        $this->AnonymousParticipants = $anonymousParticipants;
        return $this;
    }
    /**
     * Get SurveyCreatorList value
     * @return \StructType\SurveyCreatorList|null
     */
    public function getSurveyCreatorList()
    {
        return $this->SurveyCreatorList;
    }
    /**
     * Set SurveyCreatorList value
     * @param \StructType\SurveyCreatorList $surveyCreatorList
     * @return \StructType\CourseCreator
     */
    public function setSurveyCreatorList(\StructType\SurveyCreatorList $surveyCreatorList = null)
    {
        $this->SurveyCreatorList = $surveyCreatorList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CourseCreator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
