<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coord StructType
 * @subpackage Structs
 */
class Coord extends AbstractStructBase
{
    /**
     * The x
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $x;
    /**
     * The y
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $y;
    /**
     * The w
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $w;
    /**
     * The h
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $h;
    /**
     * Constructor method for Coord
     * @uses Coord::setX()
     * @uses Coord::setY()
     * @uses Coord::setW()
     * @uses Coord::setH()
     * @param int $x
     * @param int $y
     * @param int $w
     * @param int $h
     */
    public function __construct($x = null, $y = null, $w = null, $h = null)
    {
        $this
            ->setX($x)
            ->setY($y)
            ->setW($w)
            ->setH($h);
    }
    /**
     * Get x value
     * @return int
     */
    public function getX()
    {
        return $this->x;
    }
    /**
     * Set x value
     * @param int $x
     * @return \StructType\Coord
     */
    public function setX($x = null)
    {
        // validation for constraint: int
        if (!is_null($x) && !is_numeric($x)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($x)), __LINE__);
        }
        $this->x = $x;
        return $this;
    }
    /**
     * Get y value
     * @return int
     */
    public function getY()
    {
        return $this->y;
    }
    /**
     * Set y value
     * @param int $y
     * @return \StructType\Coord
     */
    public function setY($y = null)
    {
        // validation for constraint: int
        if (!is_null($y) && !is_numeric($y)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($y)), __LINE__);
        }
        $this->y = $y;
        return $this;
    }
    /**
     * Get w value
     * @return int
     */
    public function getW()
    {
        return $this->w;
    }
    /**
     * Set w value
     * @param int $w
     * @return \StructType\Coord
     */
    public function setW($w = null)
    {
        // validation for constraint: int
        if (!is_null($w) && !is_numeric($w)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($w)), __LINE__);
        }
        $this->w = $w;
        return $this;
    }
    /**
     * Get h value
     * @return int
     */
    public function getH()
    {
        return $this->h;
    }
    /**
     * Set h value
     * @param int $h
     * @return \StructType\Coord
     */
    public function setH($h = null)
    {
        // validation for constraint: int
        if (!is_null($h) && !is_numeric($h)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($h)), __LINE__);
        }
        $this->h = $h;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Coord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
