<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloseTask StructType
 * @subpackage Structs
 */
class CloseTask extends AbstractStructBase
{
    /**
     * The SurveyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SurveyID;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The TaskID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaskID;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The SendReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SendReport;
    /**
     * The SendParticipantMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendParticipantMail;
    /**
     * The SenderNameParticipantMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderNameParticipantMail;
    /**
     * The SenderEmailParticipantMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderEmailParticipantMail;
    /**
     * The EmailSubjectParticipantMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSubjectParticipantMail;
    /**
     * The EmailTextParticipantMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailTextParticipantMail;
    /**
     * Constructor method for CloseTask
     * @uses CloseTask::setSurveyID()
     * @uses CloseTask::setStartTime()
     * @uses CloseTask::setTaskID()
     * @uses CloseTask::setStatus()
     * @uses CloseTask::setSendReport()
     * @uses CloseTask::setSendParticipantMail()
     * @uses CloseTask::setSenderNameParticipantMail()
     * @uses CloseTask::setSenderEmailParticipantMail()
     * @uses CloseTask::setEmailSubjectParticipantMail()
     * @uses CloseTask::setEmailTextParticipantMail()
     * @param string $surveyID
     * @param string $startTime
     * @param string $taskID
     * @param string $status
     * @param bool $sendReport
     * @param bool $sendParticipantMail
     * @param string $senderNameParticipantMail
     * @param string $senderEmailParticipantMail
     * @param string $emailSubjectParticipantMail
     * @param string $emailTextParticipantMail
     */
    public function __construct($surveyID = null, $startTime = null, $taskID = null, $status = null, $sendReport = null, $sendParticipantMail = null, $senderNameParticipantMail = null, $senderEmailParticipantMail = null, $emailSubjectParticipantMail = null, $emailTextParticipantMail = null)
    {
        $this
            ->setSurveyID($surveyID)
            ->setStartTime($startTime)
            ->setTaskID($taskID)
            ->setStatus($status)
            ->setSendReport($sendReport)
            ->setSendParticipantMail($sendParticipantMail)
            ->setSenderNameParticipantMail($senderNameParticipantMail)
            ->setSenderEmailParticipantMail($senderEmailParticipantMail)
            ->setEmailSubjectParticipantMail($emailSubjectParticipantMail)
            ->setEmailTextParticipantMail($emailTextParticipantMail);
    }
    /**
     * Get SurveyID value
     * @return string
     */
    public function getSurveyID()
    {
        return $this->SurveyID;
    }
    /**
     * Set SurveyID value
     * @param string $surveyID
     * @return \StructType\CloseTask
     */
    public function setSurveyID($surveyID = null)
    {
        // validation for constraint: string
        if (!is_null($surveyID) && !is_string($surveyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyID)), __LINE__);
        }
        $this->SurveyID = $surveyID;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\CloseTask
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get TaskID value
     * @return string|null
     */
    public function getTaskID()
    {
        return $this->TaskID;
    }
    /**
     * Set TaskID value
     * @param string $taskID
     * @return \StructType\CloseTask
     */
    public function setTaskID($taskID = null)
    {
        // validation for constraint: string
        if (!is_null($taskID) && !is_string($taskID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taskID)), __LINE__);
        }
        $this->TaskID = $taskID;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\CloseTask
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SendReport value
     * @return bool|null
     */
    public function getSendReport()
    {
        return $this->SendReport;
    }
    /**
     * Set SendReport value
     * @param bool $sendReport
     * @return \StructType\CloseTask
     */
    public function setSendReport($sendReport = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendReport) && !is_bool($sendReport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendReport)), __LINE__);
        }
        $this->SendReport = $sendReport;
        return $this;
    }
    /**
     * Get SendParticipantMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendParticipantMail()
    {
        return isset($this->SendParticipantMail) ? $this->SendParticipantMail : null;
    }
    /**
     * Set SendParticipantMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendParticipantMail
     * @return \StructType\CloseTask
     */
    public function setSendParticipantMail($sendParticipantMail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendParticipantMail) && !is_bool($sendParticipantMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendParticipantMail)), __LINE__);
        }
        if (is_null($sendParticipantMail) || (is_array($sendParticipantMail) && empty($sendParticipantMail))) {
            unset($this->SendParticipantMail);
        } else {
            $this->SendParticipantMail = $sendParticipantMail;
        }
        return $this;
    }
    /**
     * Get SenderNameParticipantMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderNameParticipantMail()
    {
        return isset($this->SenderNameParticipantMail) ? $this->SenderNameParticipantMail : null;
    }
    /**
     * Set SenderNameParticipantMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderNameParticipantMail
     * @return \StructType\CloseTask
     */
    public function setSenderNameParticipantMail($senderNameParticipantMail = null)
    {
        // validation for constraint: string
        if (!is_null($senderNameParticipantMail) && !is_string($senderNameParticipantMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderNameParticipantMail)), __LINE__);
        }
        if (is_null($senderNameParticipantMail) || (is_array($senderNameParticipantMail) && empty($senderNameParticipantMail))) {
            unset($this->SenderNameParticipantMail);
        } else {
            $this->SenderNameParticipantMail = $senderNameParticipantMail;
        }
        return $this;
    }
    /**
     * Get SenderEmailParticipantMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderEmailParticipantMail()
    {
        return isset($this->SenderEmailParticipantMail) ? $this->SenderEmailParticipantMail : null;
    }
    /**
     * Set SenderEmailParticipantMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderEmailParticipantMail
     * @return \StructType\CloseTask
     */
    public function setSenderEmailParticipantMail($senderEmailParticipantMail = null)
    {
        // validation for constraint: string
        if (!is_null($senderEmailParticipantMail) && !is_string($senderEmailParticipantMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderEmailParticipantMail)), __LINE__);
        }
        if (is_null($senderEmailParticipantMail) || (is_array($senderEmailParticipantMail) && empty($senderEmailParticipantMail))) {
            unset($this->SenderEmailParticipantMail);
        } else {
            $this->SenderEmailParticipantMail = $senderEmailParticipantMail;
        }
        return $this;
    }
    /**
     * Get EmailSubjectParticipantMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSubjectParticipantMail()
    {
        return isset($this->EmailSubjectParticipantMail) ? $this->EmailSubjectParticipantMail : null;
    }
    /**
     * Set EmailSubjectParticipantMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSubjectParticipantMail
     * @return \StructType\CloseTask
     */
    public function setEmailSubjectParticipantMail($emailSubjectParticipantMail = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubjectParticipantMail) && !is_string($emailSubjectParticipantMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailSubjectParticipantMail)), __LINE__);
        }
        if (is_null($emailSubjectParticipantMail) || (is_array($emailSubjectParticipantMail) && empty($emailSubjectParticipantMail))) {
            unset($this->EmailSubjectParticipantMail);
        } else {
            $this->EmailSubjectParticipantMail = $emailSubjectParticipantMail;
        }
        return $this;
    }
    /**
     * Get EmailTextParticipantMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailTextParticipantMail()
    {
        return isset($this->EmailTextParticipantMail) ? $this->EmailTextParticipantMail : null;
    }
    /**
     * Set EmailTextParticipantMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailTextParticipantMail
     * @return \StructType\CloseTask
     */
    public function setEmailTextParticipantMail($emailTextParticipantMail = null)
    {
        // validation for constraint: string
        if (!is_null($emailTextParticipantMail) && !is_string($emailTextParticipantMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailTextParticipantMail)), __LINE__);
        }
        if (is_null($emailTextParticipantMail) || (is_array($emailTextParticipantMail) && empty($emailTextParticipantMail))) {
            unset($this->EmailTextParticipantMail);
        } else {
            $this->EmailTextParticipantMail = $emailTextParticipantMail;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CloseTask
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
