<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Sets the Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Header $header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderHeader(\StructType\Header $header, $nameSpace = 'soapserver-v71-2152.wsdl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Header', $header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ListTasks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Description: Returns all scheduled tasks that fit the given criteria. Returned list can be reduced specific subunits, forms, surveys and/or users. Possible values for TaskTypeIDList:<br/>1: PSWD to respondents<br/>2: Online survey
     * reminder<br/>3: Finish survey<br/>4: Response Rate Notification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IDList $subunitIDList
     * @param \StructType\IDList $formIDList
     * @param \StructType\IDList $surveyIDList
     * @param \StructType\IDList $userIDList
     * @param \StructType\IDList $taskTypeIDList
     * @return \StructType\TaskList|bool
     */
    public function ListTasks(\StructType\IDList $subunitIDList, \StructType\IDList $formIDList, \StructType\IDList $surveyIDList, \StructType\IDList $userIDList, \StructType\IDList $taskTypeIDList)
    {
        try {
            $this->setResult(self::getSoapClient()->ListTasks($subunitIDList, $formIDList, $surveyIDList, $userIDList, $taskTypeIDList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TaskList
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
