<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Header $header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderHeader(\StructType\Header $header, $nameSpace = 'soapserver-v71-2152.wsdl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Header', $header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Updates the presented user in the database. Please note: Child objects, like courses, will not be updated by this method. Please use the method "InsertCourses" for mass import/update of course and instructor data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\User $user
     * @return \StructType\User|bool
     */
    public function UpdateUser(\StructType\User $user)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateUser($user));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCourse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Updates the presented course in the database. Please note: 1) Child objects of type "Survey" will not be updated by this method. An update of existing surveys is not possible at all. 2) New course participants should be given by the
     * 4th parameter . In order to delete existing participants prior to the import of new participants, the second parameter has to be set to "true". Participants of existing surveys will not be affected by this function.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Course $course
     * @param string $deleteExistingParticipants
     * @return \StructType\Course|bool
     */
    public function UpdateCourse(\StructType\Course $course, $deleteExistingParticipants)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCourse($course, $deleteExistingParticipants));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSurvey
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Updates the displayed survey in the database. Please note: This method has to be used very carefully. Incorrect usage could cause several problems including data loss. Use "OpenSurvey" and "CloseSurvey" instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Survey $oSurvey
     * @return boolean|bool
     */
    public function UpdateSurvey(\StructType\Survey $oSurvey)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSurvey($oSurvey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateInvitationTask
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Store the changes made to the invitation task in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InvitationTask $invitationTask
     * @return int|bool
     */
    public function UpdateInvitationTask(\StructType\InvitationTask $invitationTask)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateInvitationTask($invitationTask));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateRemindTask
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Store the changes made to the reminder task in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemindTask $remindTask
     * @return int|bool
     */
    public function UpdateRemindTask(\StructType\RemindTask $remindTask)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateRemindTask($remindTask));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateResponseRateTask
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Updates a scheduled task type "OnlineSurveyEmailsResponseRate" in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResponseRateTask $responseRateTask
     * @return int|bool
     */
    public function UpdateResponseRateTask(\StructType\ResponseRateTask $responseRateTask)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateResponseRateTask($responseRateTask));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCloseTask
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Store the changes made to the closing task in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CloseTask $closeTask
     * @return int|bool
     */
    public function UpdateCloseTask(\StructType\CloseTask $closeTask)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCloseTask($closeTask));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCourseType
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Updates an existing course type. Optional it is possible to link to a module questionnaire.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $courseTypeId
     * @param string $name
     * @param string $moduleFormId
     * @param string $addConnectionToForms
     * @return \StructType\CourseType|bool
     */
    public function UpdateCourseType($courseTypeId, $name, $moduleFormId, $addConnectionToForms)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCourseType($courseTypeId, $name, $moduleFormId, $addConnectionToForms));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSurveyNotice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Updates a survey notice text by the given ID. Optionally the date is updated.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $noticeId
     * @param string $text
     * @param string $updateDate
     * @return \StructType\Notice|bool
     */
    public function UpdateSurveyNotice($noticeId, $text, $updateDate)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSurveyNotice($noticeId, $text, $updateDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateGroupTitles
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Updates the group titles for automatically created module questionnaires. Please note: The transaction should not be used for questionnaires that have already been distributed, since the recognition set is rewritten and the data may
     * no longer be read.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $idType
     * @param \StructType\KeyValueList $moduleFields
     * @return boolean|bool
     */
    public function UpdateGroupTitles($formId, $idType, \StructType\KeyValueList $moduleFields)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateGroupTitles($formId, $idType, $moduleFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateProfileImage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Sets an image for an user account based on the internal user ID that is loaded from an URL or an accessible local server path. If an empty string is passed for the path, only the previous image is removed.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userId
     * @param string $profileImagePath
     * @return boolean|bool
     */
    public function UpdateProfileImage($userId, $profileImagePath)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateProfileImage($userId, $profileImagePath));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|int|\StructType\Course|\StructType\CourseType|\StructType\Notice|\StructType\User
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
