<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Sets the Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Header $header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderHeader(\StructType\Header $header, $nameSpace = 'soapserver-v71-2152.wsdl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Header', $header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SetFormActivationStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Set the activation status of a form to activated or deactivated.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $activationStatus
     * @return boolean|bool
     */
    public function SetFormActivationStatus($formId, $activationStatus)
    {
        try {
            $this->setResult(self::getSoapClient()->SetFormActivationStatus($formId, $activationStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetFiltersForForm
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Set the filters for a specific form. Existing filters on form level are overwritten. The filters are used for hiding/deactivating questions in online surveys. The filters are also considered when paper-based surveys are processed. If
     * a survey ID is given, the filters are overwritten on survey level. In that case the filters on form level are left untouched. There are 3 values available to define the filter action: 0 - disable; 1 - disable and hide; 2 - enable and show
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $surveyId
     * @param \StructType\FilterSetList $filterSets
     * @return boolean|bool
     */
    public function SetFiltersForForm($formId, $surveyId, \StructType\FilterSetList $filterSets)
    {
        try {
            $this->setResult(self::getSoapClient()->SetFiltersForForm($formId, $surveyId, $filterSets));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetFormUsageRestrictions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Sets access of subunits, course types and periods to a specific form.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param \StructType\UsageRestrictionList $usageRestrictionList
     * @return \StructType\UsageRestrictionList|bool
     */
    public function SetFormUsageRestrictions($formId, \StructType\UsageRestrictionList $usageRestrictionList)
    {
        try {
            $this->setResult(self::getSoapClient()->SetFormUsageRestrictions($formId, $usageRestrictionList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetFormTranslations
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Sets the translations for one or more form(s) with its group and item lists. The request body is equivalent to the response body of GetFormTranslations.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FormTranslationList $formTranslationList
     * @return boolean|bool
     */
    public function SetFormTranslations(\StructType\FormTranslationList $formTranslationList)
    {
        try {
            $this->setResult(self::getSoapClient()->SetFormTranslations($formTranslationList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetFormMainLanguage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Sets the main language for a form or changes an existing main language. This can be used to set the main language before a call of the SOAP transaction SetFormTranslations.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FormMainLanguage $formMainLanguage
     * @return boolean|bool
     */
    public function SetFormMainLanguage(\StructType\FormMainLanguage $formMainLanguage)
    {
        try {
            $this->setResult(self::getSoapClient()->SetFormMainLanguage($formMainLanguage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetFormProperties
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Update the properties of a questionnaire of an administrator or subunit administrator. It is possible to update these properties: FormName, FormTitle, Activated, Extensible, ResultAccess, FormProcedure, FormSurveyType, FormFolder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FormProperties $formProperties
     * @return boolean|bool
     */
    public function SetFormProperties(\StructType\FormProperties $formProperties)
    {
        try {
            $this->setResult(self::getSoapClient()->SetFormProperties($formProperties));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetUserPassword
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Internal Transaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $login
     * @param string $password
     * @return boolean|bool
     */
    public function SetUserPassword($login, $password)
    {
        try {
            $this->setResult(self::getSoapClient()->SetUserPassword($login, $password));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetGlobalConfiguration
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Internal Transaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KeyValueList $configurationInfo
     * @return boolean|bool
     */
    public function SetGlobalConfiguration(\StructType\KeyValueList $configurationInfo)
    {
        try {
            $this->setResult(self::getSoapClient()->SetGlobalConfiguration($configurationInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|\StructType\UsageRestrictionList
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
