<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prefill ServiceType
 * @subpackage Services
 */
class Prefill extends AbstractSoapClientBase
{
    /**
     * Sets the Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Header $header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderHeader(\StructType\Header $header, $nameSpace = 'soapserver-v71-2152.wsdl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Header', $header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named PrefillDataIntoOnlineSurvey
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Inserts data for an existing online survey. The data is stored like temporary save has been used. When the participant opens the survey, the participant can check the pre-filled data, complete the survey and submit the data. The PSWD
     * and all IDs have to correct and there if there is already temporarily saved data, the function doesn't add or change anything.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param \StructType\KeyValueList $fieldValueList
     * @param \StructType\StringList $pSWDList
     * @return int|bool
     */
    public function PrefillDataIntoOnlineSurvey($surveyId, \StructType\KeyValueList $fieldValueList, \StructType\StringList $pSWDList)
    {
        try {
            $this->setResult(self::getSoapClient()->PrefillDataIntoOnlineSurvey($surveyId, $fieldValueList, $pSWDList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
