<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Move ServiceType
 * @subpackage Services
 */
class Move extends AbstractSoapClientBase
{
    /**
     * Sets the Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Header $header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderHeader(\StructType\Header $header, $nameSpace = 'soapserver-v71-2152.wsdl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Header', $header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named MoveSurveyToSubstituteUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Moves a survey to a substitute user. The current PDF report can be sent to the substitute user. The course of the survey can be moved (if only one survey exists) or copied to the substitute user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyID
     * @param string $substituteUserID
     * @param string $sendReport
     * @param string $moveCourse
     * @return string|bool
     */
    public function MoveSurveyToSubstituteUser($surveyID, $substituteUserID, $sendReport, $moveCourse)
    {
        try {
            $this->setResult(self::getSoapClient()->MoveSurveyToSubstituteUser($surveyID, $substituteUserID, $sendReport, $moveCourse));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MoveUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Moves the given user to another subunit. Subunit administrators cannot be moved. The parameter OverwriteSimilarUser defines what should happen with users that already exists in the target subunit (same title, first name, surname,
     * unit name, user type). Should the user be moved as new user, or should the existing user be overwritten? Default: Move as new user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userID
     * @param string $targetSubunitID
     * @param string $overwriteSimilarUser
     * @return string|bool
     */
    public function MoveUser($userID, $targetSubunitID, $overwriteSimilarUser)
    {
        try {
            $this->setResult(self::getSoapClient()->MoveUser($userID, $targetSubunitID, $overwriteSimilarUser));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
