<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Sets the Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Header $header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderHeader(\StructType\Header $header, $nameSpace = 'soapserver-v71-2152.wsdl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Header', $header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named InsertCourse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Inserts the presented course into the database. Please note: 1) Child objects of type "Survey" will not be imported by this method. Please use the method "InsertCentralSurvey" for inserting surveys. 2) Child objects of type
     * "Participant" have to be imported accordingly. Please use the method "InsertCentralSurvey" for inserting surveys, too.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Course $oCourse
     * @return \StructType\Course|bool
     */
    public function InsertCourse(\StructType\Course $oCourse)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertCourse($oCourse));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertCentralSurvey
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates a new survey for central evaluation based on internal IDs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nUserId
     * @param string $nCourseId
     * @param string $nFormId
     * @param string $nPeriodId
     * @param string $sSurveyType
     * @param string $sNotice
     * @return \StructType\Survey|bool
     */
    public function InsertCentralSurvey($nUserId, $nCourseId, $nFormId, $nPeriodId, $sSurveyType, $sNotice)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertCentralSurvey($nUserId, $nCourseId, $nFormId, $nPeriodId, $sSurveyType, $sNotice));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Inserts the user shown into the database. Please note: Child objects like courses will not be inserted by this method. Please use the method "InsertCourses" in order to mass import/update course and instructor data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\User $user
     * @return \StructType\User|bool
     */
    public function InsertUser(\StructType\User $user)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertUser($user));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertSubunit
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Inserts the presented subunit into the database. Please note: Child objects of type "User" will not be inserted by this method. Please use the method "InsertCourses" for mass import of course and instructor data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Unit $unit
     * @return \StructType\Unit|bool
     */
    public function InsertSubunit(\StructType\Unit $unit)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertSubunit($unit));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertCourses
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Transaction for mass structure data uploads. The transaction determines whether the presented courses and instructors already exist in the system and performs an INSERT or UPDATE operation. This method provides the opportunity to
     * upload multiple instructors (first instructor will be setup as main instructor) as well as a list of course participants. Since V5.0 this method includes the following sub-functions: - Create surveys - Configure scheduled tasks for online surveys -
     * Send email with PDF questionnaire to defined email address - Send email invitation for online surveys to given participants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CourseCreatorList $courseCreatorList
     * @param string $deleteExistingParticipants
     * @return \StructType\UploadStatusList|bool
     */
    public function InsertCourses(\StructType\CourseCreatorList $courseCreatorList, $deleteExistingParticipants)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertCourses($courseCreatorList, $deleteExistingParticipants));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertForm
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: This method inserts a complete form/questionnaire into the database. The object returned contains the given internal database keys. The owner of the form will always be the main administrator. Notes: <ul><li>An update of existing
     * forms is not possible.</li><li>Deleting forms via SOAP is not possible.</li><li>The form elements "Picture" and "Double scaled question" are not yet supported by this transaction.</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VFForm $vFForm
     * @return \StructType\VFForm|bool
     */
    public function InsertForm(\StructType\VFForm $vFForm)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertForm($vFForm));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertParticipants
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: This method accepts anonymous participants (email must be set) and non-anonymous participants (other person properties can be set). With the boolean parameter, it is possible to remove all existing course participants before the new
     * given participants are added. Please note: It is also possible to include the participants into the course object and to call either "InsertCourse" or "UpdateCourse".
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PersonList $personList
     * @param string $courseId
     * @param string $idType
     * @param string $deleteExisting
     * @return boolean|bool
     */
    public function InsertParticipants(\StructType\PersonList $personList, $courseId, $idType, $deleteExisting)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertParticipants($personList, $courseId, $idType, $deleteExisting));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertSurveyNotice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Inserts a notice to a survey for a specified user. The user can be referenced by internal (PK), external (FK) or login (username).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param string $notice
     * @param string $userId
     * @param string $idType
     * @return \StructType\Notice|bool
     */
    public function InsertSurveyNotice($surveyId, $notice, $userId, $idType)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertSurveyNotice($surveyId, $notice, $userId, $idType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertModules
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Inserts a group of modules (that can contain groups of courses) into the system, It supports both Inserting and Updating of the data. It is also able to create a module-survey on them. The function determines if the courses are
     * already in the system and then calls the UpdateCourse method. This method includes the following sub-functions: - Insert module participants - Insert secondary instructors - Create surveys - Configure scheduled tasks for online surveys - Send email
     * with PDF questionnaire to defined email address - Send email invitation for online surveys to given participants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModuleList $moduleList
     * @return \StructType\UploadStatusList|bool
     */
    public function InsertModules(\StructType\ModuleList $moduleList)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertModules($moduleList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertInvitationTask
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Add an invitation task in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InvitationTask $invitationTask
     * @param \StructType\PersonList $participants
     * @return int|bool
     */
    public function InsertInvitationTask(\StructType\InvitationTask $invitationTask, \StructType\PersonList $participants)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertInvitationTask($invitationTask, $participants));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertRemindTask
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Store the changes made to the reminder task in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemindTask $remindTask
     * @return int|bool
     */
    public function InsertRemindTask(\StructType\RemindTask $remindTask)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertRemindTask($remindTask));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertResponseRateTask
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Insert a scheduled task of type "OnlineSurveyEmailsResponseRate".
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResponseRateTask $responseRateTask
     * @return int|bool
     */
    public function InsertResponseRateTask(\StructType\ResponseRateTask $responseRateTask)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertResponseRateTask($responseRateTask));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertCloseTask
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Store the changes made to the closing task in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CloseTask $closeTask
     * @return int|bool
     */
    public function InsertCloseTask(\StructType\CloseTask $closeTask)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertCloseTask($closeTask));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertCourseType
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Inserts a new course type. Optional it is possible to link to a module questionnaire.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $name
     * @param string $moduleFormId
     * @param string $addConnectionToForms
     * @return \StructType\CourseType|bool
     */
    public function InsertCourseType($name, $moduleFormId, $addConnectionToForms)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertCourseType($name, $moduleFormId, $addConnectionToForms));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertSurveyRawData
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Inserts raw data for the given survey ID. Optionally the time span used for the date of each result can be set.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param string $startTime
     * @param string $endTime
     * @param string $useExportValues
     * @param \StructType\ItemAnswerListList $sheetResults
     * @return \StructType\SurveyStatus|bool
     */
    public function InsertSurveyRawData($surveyId, $startTime, $endTime, $useExportValues, \StructType\ItemAnswerListList $sheetResults)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertSurveyRawData($surveyId, $startTime, $endTime, $useExportValues, $sheetResults));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|int|\StructType\Course|\StructType\CourseType|\StructType\Notice|\StructType\Survey|\StructType\SurveyStatus|\StructType\Unit|\StructType\UploadStatusList|\StructType\User|\StructType\VFForm
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
