<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Header $header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderHeader(\StructType\Header $header, $nameSpace = 'soapserver-v71-2152.wsdl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Header', $header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetPswdsByParticipant
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns unused online access codes (PSWD) for the shown email address and course ID in the period of the current date. The course ID is optional. If it is empty all courses are considered. Closed surveys are ignored. The participant
     * needs to be assigned to the corresponding course. Optionally, the given value for the user mail address can be matched against a custom field (1-3) of the participant.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userMailAddress
     * @param string $courseCode
     * @param string $customFieldToConsider
     * @return \StructType\OnlineSurveyKeyList|bool
     */
    public function GetPswdsByParticipant($userMailAddress, $courseCode, $customFieldToConsider)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPswdsByParticipant($userMailAddress, $courseCode, $customFieldToConsider));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns user, referenced by his internal user ID, an external ID which was imported previously into the system or a user name. If no user is found, an error is returned. The boolean variables determine if the parent object user will
     * also contain the child objects course, survey and participant.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userId
     * @param string $idType
     * @param string $includeCourses
     * @param string $includeSurveys
     * @param string $includeParticipants
     * @param string $includeSecondaryCourses
     * @return \StructType\User|bool
     */
    public function GetUser($userId, $idType, $includeCourses, $includeSurveys, $includeParticipants, $includeSecondaryCourses)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUser($userId, $idType, $includeCourses, $includeSurveys, $includeParticipants, $includeSecondaryCourses));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUsersBySubunit
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns all users of the subunit of the type instructor. The boolean variables determine if the parent object user will also contain the child objects course, survey and participant.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nSubunitId
     * @param string $includeCourses
     * @param string $includeSurveys
     * @param string $includeParticipants
     * @param string $includeSecondaryCourses
     * @return \StructType\UserList|bool
     */
    public function GetUsersBySubunit($nSubunitId, $includeCourses, $includeSurveys, $includeParticipants, $includeSecondaryCourses)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUsersBySubunit($nSubunitId, $includeCourses, $includeSurveys, $includeParticipants, $includeSecondaryCourses));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllPeriods
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns all defined evaluation periods, sorted by date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\PeriodList|bool
     */
    public function GetAllPeriods()
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllPeriods());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCoursesByUserId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns all courses for the specified user (ID). Returns an error, if the user has no courses.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nUserId
     * @return \StructType\CourseList|bool
     */
    public function GetCoursesByUserId($nUserId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCoursesByUserId($nUserId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCourse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns the course, referenced by the internal course ID, the external ID which was imported previously or the editable course ID. The boolean variables decide if the parent object "Course" also contains the child objects "Survey"
     * and "Participant".
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $courseId
     * @param string $idType
     * @param string $includeSurveys
     * @param string $includeParticipants
     * @return \StructType\Course|bool
     */
    public function GetCourse($courseId, $idType, $includeSurveys, $includeParticipants)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCourse($courseId, $idType, $includeSurveys, $includeParticipants));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPeriod
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a period referenced by its period ID, period name or period date (format YYYY-MM-DD).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sPeriodId
     * @param string $sPeriodIdType
     * @return \StructType\Period|bool
     */
    public function GetPeriod($sPeriodId, $sPeriodIdType)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPeriod($sPeriodId, $sPeriodIdType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllForms
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns all active forms of all users stored in the system. Restrictions can be used to get forms e.g. of specific subunits.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $includeCustomReports
     * @param string $includeUsageRestrictions
     * @param \StructType\UsageRestrictionList $usageRestrictionList
     * @return \StructType\SimpleFormList|bool
     */
    public function GetAllForms($includeCustomReports, $includeUsageRestrictions, \StructType\UsageRestrictionList $usageRestrictionList)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllForms($includeCustomReports, $includeUsageRestrictions, $usageRestrictionList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyTypes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Survey types are hard-coded single characters and will never be changed. Due to performance reasons, it is not recommended to call this transaction continuously in live systems.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\SurveyTypeList|bool
     */
    public function GetSurveyTypes()
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyTypes());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormByCourseIdAndPeriodId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Forms can be assigned to specific course types and periods in the system. Use this transaction to get the "approved" forms for a course.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nCourseId
     * @param string $nPeriodId
     * @return \StructType\SimpleFormList|bool
     */
    public function GetFormByCourseIdAndPeriodId($nCourseId, $nPeriodId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFormByCourseIdAndPeriodId($nCourseId, $nPeriodId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetForm
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns the questionnaire/form referenced by its internal form ID or the questionnaire short name. The objects returned include all question groups and questions. Secondary questionnaire properties such as filter settings are not
     * included. If the parameter "IncludeOnlyQuestions" is true, only questions will be returned and no layout elements like free text, horizontal lines, etc.. If the parameter "SkipPoleLabelsInheritance" is true, scaled questions will not inherit the pole
     * lables of prior (extended) pole labels fields automatically.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $idType
     * @param string $includeOnlyQuestions
     * @param string $skipPoleLabelsInheritance
     * @return \StructType\VFForm|bool
     */
    public function GetForm($formId, $idType, $includeOnlyQuestions, $skipPoleLabelsInheritance)
    {
        try {
            $this->setResult(self::getSoapClient()->GetForm($formId, $idType, $includeOnlyQuestions, $skipPoleLabelsInheritance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyById
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns the survey referenced by its survey ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nSurveyId
     * @return \StructType\Survey|bool
     */
    public function GetSurveyById($nSurveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyById($nSurveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveysByCourse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: One course can have more than one survey in different periods or with different forms. To reduce the number of surveys, it is possible to set the parameters for the form and the period. Possible values for m_nState in
     * SurveyList:<br/>0: Ready (waiting for data)<br/>1: Data available<br/>2: Data deleted<br/>4: Quantity of data too low<br/>5: data capturing<br/>6: Verification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nCourseId
     * @param string $nFormId
     * @param string $nPeriodId
     * @return \StructType\SurveyList|bool
     */
    public function GetSurveysByCourse($nCourseId, $nFormId, $nPeriodId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveysByCourse($nCourseId, $nFormId, $nPeriodId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPswdsBySurvey
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns the online access codes (PSWD) for the displayed survey ID encapsulated in a OnlineCode object. If the second parameter is 0, the predefined PSWDs will be returned. Should the number of requested PSWDs exceed the number of
     * existing PSWDs, this method automatically creates new PSWDs by default. All PSWDs are set to "sent" by default.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nSurveyId
     * @param string $nPswdCount
     * @param string $nCodeTypes
     * @param string $bForceNewPasswordGeneration
     * @param string $bSetPswdsToSent
     * @return \StructType\OnlineCodeList|bool
     */
    public function GetPswdsBySurvey($nSurveyId, $nPswdCount, $nCodeTypes, $bForceNewPasswordGeneration, $bSetPswdsToSent)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPswdsBySurvey($nSurveyId, $nPswdCount, $nCodeTypes, $bForceNewPasswordGeneration, $bSetPswdsToSent));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPDFReport
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates the PDF report for a survey and returns a hyperlink to the document.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nSurveyId
     * @param string $nUserId
     * @param string $nCustomPDFId
     * @param string $nLanguageID
     * @return string|bool
     */
    public function GetPDFReport($nSurveyId, $nUserId, $nCustomPDFId, $nLanguageID)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPDFReport($nSurveyId, $nUserId, $nCustomPDFId, $nLanguageID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubunits
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Gets all subunits which are stored in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\UnitList|bool
     */
    public function GetSubunits()
    {
        try {
            $this->setResult(self::getSoapClient()->GetSubunits());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubunit
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Gets a subunit by the name presented. Note: In the system it is possible to have two or more subunits with the same name, but in this function, we only return the first. The boolean variable determines whether the parent object
     * "subunit" will also contain child objects of the type "user".
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $subunitId
     * @param string $idType
     * @param string $includeInstructors
     * @return \StructType\Unit|bool
     */
    public function GetSubunit($subunitId, $idType, $includeInstructors)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSubunit($subunitId, $idType, $includeInstructors));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPDFPluginsByFormId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: This transaction returns a list of all available PDF Plugins for the presented form ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $userId
     * @return \StructType\PDFPluginList|bool
     */
    public function GetPDFPluginsByFormId($formId, $userId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPDFPluginsByFormId($formId, $userId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPDFQuestionnaire
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates a PDF questionnaire and returns the hyperlink to the file. If a survey ID is submitted, the questionnaire is personalized for the survey and can be used for scanning (hard copy procedure). For coversheet procedure, the second
     * parameter should not be set.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $surveyId
     * @param string $serialPrint
     * @param string $additionalcopies
     * @param string $serialNumberFrom
     * @param string $serialNumberTo
     * @return string|bool
     */
    public function GetPDFQuestionnaire($formId, $surveyId, $serialPrint, $additionalcopies, $serialNumberFrom, $serialNumberTo)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPDFQuestionnaire($formId, $surveyId, $serialPrint, $additionalcopies, $serialNumberFrom, $serialNumberTo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPDFCoversheet
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates a PDF coversheet and returns the hyperlink to the file. The coversheet is personalized for the survey and can be used for scanning (coversheet procedure).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @return string|bool
     */
    public function GetPDFCoversheet($surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPDFCoversheet($surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPDFPswd
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates a PDF with the PSWDs (cards) and returns the hyperlink to the file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @return string|bool
     */
    public function GetPDFPswd($surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPDFPswd($surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSPSSRawData
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates the SPSS export file of the survey and returns the link to the file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @return string|bool
     */
    public function GetSPSSRawData($surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSPSSRawData($surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCSVRawData
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates the CSV export file of the survey and returns the link to the file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @return string|bool
     */
    public function GetCSVRawData($surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCSVRawData($surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyRawData
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates an object which includes all sheet results (raw data) of the given survey. The SurveyRawData object also contains the survey object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param string $includeOpenEndedQuestions
     * @param \StructType\IDList $resultIDs
     * @return \StructType\SurveyRawData|bool
     */
    public function GetSurveyRawData($surveyId, $includeOpenEndedQuestions, \StructType\IDList $resultIDs)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyRawData($surveyId, $includeOpenEndedQuestions, $resultIDs));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyResults
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Creates an object which includes all statistical results for all questions and question groups (indicators) of the given survey. The SurveyResultRawData object also contains the survey object. Statistical results include: Response
     * count, mean, median, standard deviation, frequency distribution, abstention count, normed mean.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @return \StructType\SurveyResult|bool
     */
    public function GetSurveyResults($surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyResults($surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOnlineSurveyLinkByEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a link to the online survey for the presented email address and the internal survey ID. In order to automatically link the recipient to the survey, the parameter "AddRecipientToSurvey" should be set to "true". If this
     * parameter is set to "false" and the recipient is not already linked to the survey, this function will return an error. The 4th parameter determines if new PSWDs are to be created in case not enough PSWDs were predefined.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param string $emailAddress
     * @param string $addRecipientToSurvey
     * @param string $autoIncreasePSWDCount
     * @return string|bool
     */
    public function GetOnlineSurveyLinkByEmail($surveyId, $emailAddress, $addRecipientToSurvey, $autoIncreasePSWDCount)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOnlineSurveyLinkByEmail($surveyId, $emailAddress, $addRecipientToSurvey, $autoIncreasePSWDCount));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomReportsByForm
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: The operation returns a list of available PDF report definitions of a given form.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $idType
     * @return \StructType\CustomReportList|bool
     */
    public function GetCustomReportsByForm($formId, $idType)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomReportsByForm($formId, $idType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSimpleForm
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a simplified version of the form referenced to by the form ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $idType
     * @param string $includeCustomReports
     * @param string $includeUsageRestrictions
     * @return \StructType\SimpleForm|bool
     */
    public function GetSimpleForm($formId, $idType, $includeCustomReports, $includeUsageRestrictions)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSimpleForm($formId, $idType, $includeCustomReports, $includeUsageRestrictions));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVFD
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: The function exports a form into an .vfd (=VFD/VividForms form definition file ) file and returns a link to it.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $includeSecondaryData
     * @return string|bool
     */
    public function GetVFD($formId, $includeSecondaryData)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVFD($formId, $includeSecondaryData));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyRawDataByTime
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns raw result data of all surveys that received results in the defined timeframe. The returned results are not limited to the defined timeframe. All results of the relevant surveys will be returned.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $startTime
     * @param string $endTime
     * @param string $includeOpenEndedQuestions
     * @return \StructType\SurveyRawDataList|bool
     */
    public function GetSurveyRawDataByTime($startTime, $endTime, $includeOpenEndedQuestions)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyRawDataByTime($startTime, $endTime, $includeOpenEndedQuestions));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSessionForUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a session for a given user ID. The session object contains the session ID, the server URL and the user start page. This method can be used to authenticate users via SOAP.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userId
     * @param string $idType
     * @return \StructType\UserSession|bool
     */
    public function GetSessionForUser($userId, $idType)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSessionForUser($userId, $idType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCourseTypes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of course types. Optional only course types which are used for module evaluation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $onlyModuleCourseTypes
     * @return \StructType\CourseTypeList|bool
     */
    public function GetCourseTypes($onlyModuleCourseTypes)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCourseTypes($onlyModuleCourseTypes));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPswdsByRecipient
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns unused online access codes (PSWD) for the shown email address. The access codes have to be sent out previously so that an access code is already assigned to the recipient. Closed surveys are ignored.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userMailAddress
     * @return \StructType\OnlineCodeList|bool
     */
    public function GetPswdsByRecipient($userMailAddress)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPswdsByRecipient($userMailAddress));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetPercentOfCompletedSurveysByParticipant
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: The method returns the percentage of surveys a participant has completed in a given time frame and subunit. This method considers anonymous and non-anonymous online surveys as well as non-anonymous paper surveys. The participant data
     * need to be imported to a course prior to the survey creation.<br/><br/>The following Surveys are considered:<br/><br/>Surveys without scheduled tasks and a period which the start date of the given time frame is within the period.<br/>Surveys without
     * scheduled tasks and a period which its start date is within the given time frame.<br/><br/>For Surveys with scheduled tasks:<br/><br/>When both first scheduled task and close survey task are defined then:<br/>The start date of the given time frame is
     * within the tasks dates<br/>Or date of first task is within the given time frame.<br/><br/>When only first scheduled task is defined then:<br/>Task start date should be before the end date of given time frame.<br/><br/>When only last scheduled task
     * (survey close) is defined then:<br/>Task should be ended after starting the given time frame.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userMailAddress
     * @param string $startDate
     * @param string $endDate
     * @param string $subunitId
     * @param string $idType
     * @return int|bool
     */
    public function GetPercentOfCompletedSurveysByParticipant($userMailAddress, $startDate, $endDate, $subunitId, $idType)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPercentOfCompletedSurveysByParticipant($userMailAddress, $startDate, $endDate, $subunitId, $idType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAccessibleSubunitsForSubunitAdmin
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns all accessible subunits for the presented user id (only for subunit administrators).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nUserId
     * @return \StructType\UnitList|bool
     */
    public function GetAccessibleSubunitsForSubunitAdmin($nUserId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccessibleSubunitsForSubunitAdmin($nUserId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserVolumeLicenses
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: This function doesn't work on a standard system. It is not possible to get a volume license.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userId
     * @return \StructType\VolumeLicenseList|bool
     */
    public function GetUserVolumeLicenses($userId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserVolumeLicenses($userId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyOriginalScansPDF
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Create the original scans PDF for a survey / batch and return the link to the PDF.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param string $sheetId
     * @param string $batchId
     * @return string|bool
     */
    public function GetSurveyOriginalScansPDF($surveyId, $sheetId, $batchId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyOriginalScansPDF($surveyId, $sheetId, $batchId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebscanBatchList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Get a list of all unfinished scan upload batches of a specific user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userId
     * @param string $language
     * @return \StructType\WebscanBatchList|bool
     */
    public function GetWebscanBatchList($userId, $language)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebscanBatchList($userId, $language));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyIDsByParams
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Get a list of survey IDs by the given parameters (Name, Subunits, Instructors, Periods, Forms, CourseTypes, Courses, ProgramOfStudies, Statuses, Types). For the parameter "Name" a wildcard "[*]" may be used as a substitute for zero
     * or more characters.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SurveyParams $params
     * @return \StructType\StringList|bool
     */
    public function GetSurveyIDsByParams(\StructType\SurveyParams $params)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyIDsByParams($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFiltersByFormId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Get a list of filters for a specific form. The filters are used for hiding/deactivating questions in online surveys. The filters are also considered when paper-based surveys are processed. If a survey ID is given and filters on
     * survey level are defined, the survey level filters are returned. No filters are returned if a survey ID is given but there are no filters on survey level. In that case filters on form level are ignored. There are 3 values available to define the
     * filter action: 0 - disable; 1 - disable and hide; 2 - enable and show
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $surveyId
     * @return \StructType\FilterSetList|bool
     */
    public function GetFiltersByFormId($formId, $surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFiltersByFormId($formId, $surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEMailsByIDList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Get a list of emails by the given list of IDs. (Status: 0 - pending; 1 - delivered; 2 - undelivered)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IDList $mailIDList
     * @param string $status
     * @return \StructType\MailList|bool
     */
    public function GetEMailsByIDList(\StructType\IDList $mailIDList, $status)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEMailsByIDList($mailIDList, $status));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEMailSummaryByCreationDate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Get a summary of all pending, delivered and undelivered emails by a given date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $creationDate
     * @return \StructType\MailSummary|bool
     */
    public function GetEMailSummaryByCreationDate($creationDate)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEMailSummaryByCreationDate($creationDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVerifierInfoBySurvey
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns detailed information about the pending verification of the survey. There is data about the survey, batch, sheet, question and answer, including the coordinates of detected marks. With this data it is possible to monitor the
     * verification or to get all data and continue an external process.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @return \StructType\VerifierSurvey|bool
     */
    public function GetVerifierInfoBySurvey($surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVerifierInfoBySurvey($surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVerifierInfoBySerialNumber
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns detailed information about the pending verification of a single participant by serial number. There is data about the survey, batch, sheet, question and answer, including the coordinates of detected marks. With this data it
     * is possible to monitor the verification or to get all data and continue an external process.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param string $serialNumber
     * @param string $serialNumberCounter
     * @return \StructType\VerifierSurvey|bool
     */
    public function GetVerifierInfoBySerialNumber($surveyId, $serialNumber, $serialNumberCounter)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVerifierInfoBySerialNumber($surveyId, $serialNumber, $serialNumberCounter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVerifierInfoByParticipant
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns detailed information about the pending verification of a single participant by email address. There is data about the survey, batch, sheet, question and answer, including the coordinates of detected marks. With this data it
     * is possible to monitor the verification or to get all data and continue an external process.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param string $participantIdentifier
     * @return \StructType\VerifierSurvey|bool
     */
    public function GetVerifierInfoByParticipant($surveyId, $participantIdentifier)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVerifierInfoByParticipant($surveyId, $participantIdentifier));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVerifierInfoByBatch
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns detailed information about the pending verification of the batch. There is data about the survey, batch, sheet, question and answer, including the coordinates of detected marks. With this data it is possible to monitor the
     * verification or to get all data and continue an external process.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $batchId
     * @param string $batchIdType
     * @param string $surveyId
     * @return \StructType\VerifierBatch|bool
     */
    public function GetVerifierInfoByBatch($batchId, $batchIdType, $surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVerifierInfoByBatch($batchId, $batchIdType, $surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserSessionInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns the relevant information for an existing session. Optionally the session can be resumed.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sessionId
     * @param string $resumeSession
     * @return \StructType\UserSessionInfo|bool
     */
    public function GetUserSessionInfo($sessionId, $resumeSession)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserSessionInfo($sessionId, $resumeSession));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConfigurationInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns the relevant configuration options for an existing user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userId
     * @return \StructType\KeyValueList|bool
     */
    public function GetConfigurationInfo($userId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetConfigurationInfo($userId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserByLogin
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns user, referenced by login and password. If no user is found or the password is wrong a message is shown. 3 invalid login attempts for a specific login, lead to a 15 min blockade.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $login
     * @param string $password
     * @return \StructType\User|bool
     */
    public function GetUserByLogin($login, $password)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserByLogin($login, $password));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEvaluationSummaryByParticipant
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a summary of evaluation (e.g. survey details, scheduled tasks details, link to online survey, participation status) for surveys to which a participant was assigned. This method considers anonymous and non-anonymous online
     * surveys as well as non-anonymous paper surveys. The survey types can be limited with an optional parameter.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $participantMailAddress
     * @param string $surveyTypes
     * @param string $surveyOpenState
     * @return \StructType\SurveySummaryList|bool
     */
    public function GetEvaluationSummaryByParticipant($participantMailAddress, $surveyTypes, $surveyOpenState)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEvaluationSummaryByParticipant($participantMailAddress, $surveyTypes, $surveyOpenState));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPdfReportDefinition
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: PDF report definitions can be used to distribute full or partly survey reports to defined users. This method returns a PDF report definition for a form by the given ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $pDFReportDefinitionId
     * @return \StructType\PDFReportDefinition|bool
     */
    public function GetPdfReportDefinition($pDFReportDefinitionId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPdfReportDefinition($pDFReportDefinitionId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPdfReportDefinitionsByFormId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: PDF report definitions can be used to distribute full or partly survey reports to defined users. This method returns a list of PDF report definitions by the given form ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @return \StructType\PDFReportDefinitionList|bool
     */
    public function GetPdfReportDefinitionsByFormId($formId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPdfReportDefinitionsByFormId($formId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormTranslations
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: This method returns a list of form translations by the given form ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @return \StructType\FormTranslationList|bool
     */
    public function GetFormTranslations($formId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFormTranslations($formId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllTextTemplateIDs
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of all available text templates in the system. The content for the text template can be requested with the transaction "GetTextTemplateById".
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\StringList|bool
     */
    public function GetAllTextTemplateIDs()
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllTextTemplateIDs());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTextTemplateById
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a text template by the given Id. Optionally by giving a form ID, the form specific text template is delivered. The result includes the text template contents for all system languages.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $textTemplateId
     * @param string $formId
     * @return \StructType\TextTemplateList|bool
     */
    public function GetTextTemplateById($textTemplateId, $formId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTextTemplateById($textTemplateId, $formId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserByIdConsiderExternalID
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of system users, where all users in this list have the same external id referenced by an internal user ID, an external ID which was imported previously into the system or a the system user name. If no user is found, an
     * error is returned. The Boolean variables determine if the parent object user will also contain the child objects course, survey and participant.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userId
     * @param string $idType
     * @param string $includeCourses
     * @param string $includeSurveys
     * @param string $includeParticipants
     * @param string $includeSecondaryCourses
     * @return \StructType\UserList|bool
     */
    public function GetUserByIdConsiderExternalID($userId, $idType, $includeCourses, $includeSurveys, $includeParticipants, $includeSecondaryCourses)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserByIdConsiderExternalID($userId, $idType, $includeCourses, $includeSurveys, $includeParticipants, $includeSecondaryCourses));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPswdSummary
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns an object with summarized information for a given PSWD. The object contains the survey ID, the information if the PSWD was used and the participant object if isset.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $pswd
     * @return \StructType\PwsdSummary|bool
     */
    public function GetPswdSummary($pswd)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPswdSummary($pswd));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFoldersByUserId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of all folders for the given user Id of an active user account. This transaction may also be used for getting access to the reports of a report creator account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userId
     * @return \StructType\FolderList|bool
     */
    public function GetFoldersByUserId($userId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFoldersByUserId($userId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSurveysByFolderId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of surveys for a given folder Id. This transaction may also be used for getting access to the reports of a report creator account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $folderId
     * @return \StructType\SurveyList|bool
     */
    public function GetAllSurveysByFolderId($folderId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSurveysByFolderId($folderId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIndicatorsByFormId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of all indicators for a given form Id. As long as there no free indicators exist, the indicators for question groups with dimension values are returned. Optionally by giving a survey Id, the survey specific values for
     * mean and standard deviation are delivered.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $formId
     * @param string $surveyId
     * @return \StructType\IndicatorList|bool
     */
    public function GetIndicatorsByFormId($formId, $surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIndicatorsByFormId($formId, $surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomUserSetting
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Gets a setting for the given key. The settings are bound to the current SOAP user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $settingKey
     * @return \StructType\CustomUserSetting|bool
     */
    public function GetCustomUserSetting($settingKey)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomUserSetting($settingKey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomUserSettingsList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of all settings. The settings are bound to the current SOAP user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\CustomUserSettingsList|bool
     */
    public function GetCustomUserSettingsList()
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomUserSettingsList());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyNotices
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of all survey notices for the given survey ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @return \StructType\NoticeList|bool
     */
    public function GetSurveyNotices($surveyId)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyNotices($surveyId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLicenseInformation
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of relevant license information, which might be used to distinguish between different system environments.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\KeyValueList|bool
     */
    public function GetLicenseInformation()
    {
        try {
            $this->setResult(self::getSoapClient()->GetLicenseInformation());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormsInfoByParams
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of forms information by the given parameters (SelectedFields, Users, SearchQuery, IncludeFormsOfOtherSubunitAdministrators, IncludeStatus, IncludeDeactivatedForms, ExcludeActiveForms, FolderId, IncludeChildForms). For
     * the parameter "SearchQuery" a wildcard "[*]" may be used as a substitute for zero or more characters. The SearchQuery searches in short name, description and IDs of the forms.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FormParams $params
     * @return \StructType\StringList|bool
     */
    public function GetFormsInfoByParams(\StructType\FormParams $params)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFormsInfoByParams($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyResponseDistribution
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns the distribution of responses (online or paper based) for one or more survey IDs. The list can be left blank in order to have a summary for the whole system. The data can either be grouped by survey ID or aggregated over all
     * surveys. The time span can be limited by entering a start and / or an end time.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IDList $surveyIDs
     * @param string $onlineResponses
     * @param string $groupBySurveyId
     * @param string $dataAggregationUnit
     * @param string $startTime
     * @param string $endTime
     * @return \StructType\StringList|bool
     */
    public function GetSurveyResponseDistribution(\StructType\IDList $surveyIDs, $onlineResponses, $groupBySurveyId, $dataAggregationUnit, $startTime, $endTime)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyResponseDistribution($surveyIDs, $onlineResponses, $groupBySurveyId, $dataAggregationUnit, $startTime, $endTime));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserIdsByParams
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of user IDs by the given parameters (UserIds, Types, LoginName, ExternalID, Title, FirstName, SurName, UnitName, Email, Subunits, ActiveUsers). For the parameters LoginName, ExternalID, Title, FirstName, SurName,
     * UnitName, or Email a wildcard "[*]" may be used as a substitute for zero or more characters. If ExtendedResponseAsJSON is set, a json string is returned with more information about the user. The result can be ordered by each returned field.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserParams $params
     * @return \StructType\StringList|bool
     */
    public function GetUserIdsByParams(\StructType\UserParams $params)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserIdsByParams($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCourseIdsByParams
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of course IDs by the given parameters (Name, CourseIds, Instructors, Subunits, Periods, CourseTypes, ProgramOfStudies, CourseCode, Room, ExternalID, CustomFieldEntry). For the parameters Name, ProgramOfStudies,
     * CourseCode, Room, ExternalID or CustomFieldEntry a wildcard "[*]" may be used as a substitute for zero or more characters. If ExtendedResponseAsJSON is set, a json string is returned with more information about the course. The result can be ordered
     * by each returned field.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CourseParams $params
     * @return \StructType\StringList|bool
     */
    public function GetCourseIdsByParams(\StructType\CourseParams $params)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCourseIdsByParams($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReaderScanBatchList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list (JSON) with detailed information of all scanned batches in the Scanstation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReaderScanBatchParams $params
     * @return \StructType\StringList|bool
     */
    public function GetReaderScanBatchList(\StructType\ReaderScanBatchParams $params)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReaderScanBatchList($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParticipationTrackingList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list (JSON) with all participation tracking information on the basis of the given parameters. As an extension to existing transactions the request is not limited to a specific participant.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ParticipationTrackingParams $params
     * @return \StructType\StringList|bool
     */
    public function GetParticipationTrackingList(\StructType\ParticipationTrackingParams $params)
    {
        try {
            $this->setResult(self::getSoapClient()->GetParticipationTrackingList($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyResponseRateInformation
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list (JSON) with all response rate information for each calculation method (number of PSWDs created, number of PSWDs sent, number of course participants) on the basis of the given survey IDs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IDList $params
     * @return \StructType\StringList|bool
     */
    public function GetSurveyResponseRateInformation(\StructType\IDList $params)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyResponseRateInformation($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllAvailableTransactionsByUserLogin
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of all transactions and the information if the specified user has the transaction right to call it.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $soapLoginName
     * @return \StructType\KeyValueList|bool
     */
    public function GetAllAvailableTransactionsByUserLogin($soapLoginName)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllAvailableTransactionsByUserLogin($soapLoginName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataBySQLQuery
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Internal Transaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $query
     * @return \StructType\StringList|bool
     */
    public function GetDataBySQLQuery($query)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDataBySQLQuery($query));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllProgramsOfStudy
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of program of studies by the given parameters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IDList $subunitIds
     * @return \StructType\StringList|bool
     */
    public function GetAllProgramsOfStudy(\StructType\IDList $subunitIds)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllProgramsOfStudy($subunitIds));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEntitiesByKeyword
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Returns a list of entity information by the given keyword. This transaction allows a full text search for information within the most important entities (Subunits, Users, Courses, Surveys, Participants, Logs, Deliveries, Notices,
     * Results). For the parameter "Keyword" a wildcard "[*]" may be used as a substitute for zero or more characters.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $keyword
     * @param \StructType\EntityList $entityList
     * @return \StructType\StringList|bool
     */
    public function GetEntitiesByKeyword($keyword, \StructType\EntityList $entityList)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEntitiesByKeyword($keyword, $entityList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return int|string|\StructType\Course|\StructType\CourseList|\StructType\CourseTypeList|\StructType\CustomReportList|\StructType\CustomUserSetting|\StructType\CustomUserSettingsList|\StructType\FilterSetList|\StructType\FolderList|\StructType\FormTranslationList|\StructType\IndicatorList|\StructType\KeyValueList|\StructType\MailList|\StructType\MailSummary|\StructType\NoticeList|\StructType\OnlineCodeList|\StructType\OnlineSurveyKeyList|\StructType\PDFPluginList|\StructType\PDFReportDefinition|\StructType\PDFReportDefinitionList|\StructType\Period|\StructType\PeriodList|\StructType\PwsdSummary|\StructType\SimpleForm|\StructType\SimpleFormList|\StructType\StringList|\StructType\Survey|\StructType\SurveyList|\StructType\SurveyRawData|\StructType\SurveyRawDataList|\StructType\SurveyResult|\StructType\SurveySummaryList|\StructType\SurveyTypeList|\StructType\TextTemplateList|\StructType\Unit|\StructType\UnitList|\StructType\User|\StructType\UserList|\StructType\UserSession|\StructType\UserSessionInfo|\StructType\VerifierBatch|\StructType\VerifierSurvey|\StructType\VFForm|\StructType\VolumeLicenseList|\StructType\WebscanBatchList
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
