<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Activate ServiceType
 * @subpackage Services
 */
class Activate extends AbstractSoapClientBase
{
    /**
     * Sets the Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Header $header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderHeader(\StructType\Header $header, $nameSpace = 'soapserver-v71-2152.wsdl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Header', $header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ActivateOptionalQuestionsForSurvey
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Enables/disables extending of the questionnaire of a specific survey with additional questions. Additionally it is possible to remind the instructor, that he is able to customize the questionnaire. If the second parameter is set to
     * true, the instructor is provided with an information email, that contains a link to the editing environment. This functionality is called Instructor's Optional Questions or "Meldemaskenverfahren" in German.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param string $sendEmail
     * @param string $mode
     * @return boolean|bool
     */
    public function ActivateOptionalQuestionsForSurvey($surveyId, $sendEmail, $mode)
    {
        try {
            $this->setResult(self::getSoapClient()->ActivateOptionalQuestionsForSurvey($surveyId, $sendEmail, $mode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ActivateOptionalQuestionsForSurveys
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Same as ActivateOptionalQuestionsForSurvey, but accepts a List/Array of SurveyIDs and therefore gives the possibility to enable, remind or disable optional questions for a group of surveys.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IDList $surveyIDList
     * @param string $sendEmail
     * @param string $mode
     * @return boolean|bool
     */
    public function ActivateOptionalQuestionsForSurveys(\StructType\IDList $surveyIDList, $sendEmail, $mode)
    {
        try {
            $this->setResult(self::getSoapClient()->ActivateOptionalQuestionsForSurveys($surveyIDList, $sendEmail, $mode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ActivateOptionalQuestionsForSurveyAddQuestions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Header
     * - SOAPHeaderNamespaces: soapserver-v71-2152.wsdl
     * - SOAPHeaderTypes: \StructType\Header
     * - SOAPHeaders: required
     * - documentation: Same as ActivateOptionalQuestionsForSurvey, but gives the opportunity to add some question groups and question directly with the same SOAP operation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $surveyId
     * @param \StructType\ItemGroupList $itemGroupList
     * @return boolean|bool
     */
    public function ActivateOptionalQuestionsForSurveyAddQuestions($surveyId, \StructType\ItemGroupList $itemGroupList)
    {
        try {
            $this->setResult(self::getSoapClient()->ActivateOptionalQuestionsForSurveyAddQuestions($surveyId, $itemGroupList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
