<?php

namespace EnumType;

/**
 * This class stands for OnlineLayoutType EnumType
 * @subpackage Enumerations
 */
class OnlineLayoutType
{
    /**
     * Constant for value 'COMPLETE'
     * @return string 'COMPLETE'
     */
    const VALUE_COMPLETE = 'COMPLETE';
    /**
     * Constant for value 'CHAPTER'
     * @return string 'CHAPTER'
     */
    const VALUE_CHAPTER = 'CHAPTER';
    /**
     * Constant for value 'PAGE'
     * @return string 'PAGE'
     */
    const VALUE_PAGE = 'PAGE';
    /**
     * Constant for value 'QUESTION'
     * @return string 'QUESTION'
     */
    const VALUE_QUESTION = 'QUESTION';
    /**
     * Constant for value 'PAPER'
     * @return string 'PAPER'
     */
    const VALUE_PAPER = 'PAPER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMPLETE
     * @uses self::VALUE_CHAPTER
     * @uses self::VALUE_PAGE
     * @uses self::VALUE_QUESTION
     * @uses self::VALUE_PAPER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMPLETE,
            self::VALUE_CHAPTER,
            self::VALUE_PAGE,
            self::VALUE_QUESTION,
            self::VALUE_PAPER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
