<?php

namespace EnumType;

/**
 * This class stands for FormSelectField EnumType
 * @subpackage Enumerations
 */
class FormSelectField
{
    /**
     * Constant for value 'ShortName'
     * @return string 'ShortName'
     */
    const VALUE_SHORT_NAME = 'ShortName';
    /**
     * Constant for value 'Description'
     * @return string 'Description'
     */
    const VALUE_DESCRIPTION = 'Description';
    /**
     * Constant for value 'OwnerId'
     * @return string 'OwnerId'
     */
    const VALUE_OWNER_ID = 'OwnerId';
    /**
     * Constant for value 'OriginalId'
     * @return string 'OriginalId'
     */
    const VALUE_ORIGINAL_ID = 'OriginalId';
    /**
     * Constant for value 'CreateDate'
     * @return string 'CreateDate'
     */
    const VALUE_CREATE_DATE = 'CreateDate';
    /**
     * Constant for value 'ChangeDate'
     * @return string 'ChangeDate'
     */
    const VALUE_CHANGE_DATE = 'ChangeDate';
    /**
     * Constant for value 'IsUsed'
     * @return string 'IsUsed'
     */
    const VALUE_IS_USED = 'IsUsed';
    /**
     * Constant for value 'IsParent'
     * @return string 'IsParent'
     */
    const VALUE_IS_PARENT = 'IsParent';
    /**
     * Constant for value 'MainLanguageId'
     * @return string 'MainLanguageId'
     */
    const VALUE_MAIN_LANGUAGE_ID = 'MainLanguageId';
    /**
     * Constant for value 'FormEngine'
     * @return string 'FormEngine'
     */
    const VALUE_FORM_ENGINE = 'FormEngine';
    /**
     * Constant for value 'IsMirror'
     * @return string 'IsMirror'
     */
    const VALUE_IS_MIRROR = 'IsMirror';
    /**
     * Constant for value 'OnlineTempSave'
     * @return string 'OnlineTempSave'
     */
    const VALUE_ONLINE_TEMP_SAVE = 'OnlineTempSave';
    /**
     * Constant for value 'HeadLogoId'
     * @return string 'HeadLogoId'
     */
    const VALUE_HEAD_LOGO_ID = 'HeadLogoId';
    /**
     * Constant for value 'AnswerBoxSize'
     * @return string 'AnswerBoxSize'
     */
    const VALUE_ANSWER_BOX_SIZE = 'AnswerBoxSize';
    /**
     * Constant for value 'PageFormat'
     * @return string 'PageFormat'
     */
    const VALUE_PAGE_FORMAT = 'PageFormat';
    /**
     * Constant for value 'ShowNumeration'
     * @return string 'ShowNumeration'
     */
    const VALUE_SHOW_NUMERATION = 'ShowNumeration';
    /**
     * Constant for value 'PageOrientation'
     * @return string 'PageOrientation'
     */
    const VALUE_PAGE_ORIENTATION = 'PageOrientation';
    /**
     * Constant for value 'EngineSubType'
     * @return string 'EngineSubType'
     */
    const VALUE_ENGINE_SUB_TYPE = 'EngineSubType';
    /**
     * Constant for value 'FormOptions'
     * @return string 'FormOptions'
     */
    const VALUE_FORM_OPTIONS = 'FormOptions';
    /**
     * Constant for value 'ExtraOptions'
     * @return string 'ExtraOptions'
     */
    const VALUE_EXTRA_OPTIONS = 'ExtraOptions';
    /**
     * Constant for value 'URL'
     * @return string 'URL'
     */
    const VALUE_URL = 'URL';
    /**
     * Constant for value 'HasCustom'
     * @return string 'HasCustom'
     */
    const VALUE_HAS_CUSTOM = 'HasCustom';
    /**
     * Constant for value 'PageCount'
     * @return string 'PageCount'
     */
    const VALUE_PAGE_COUNT = 'PageCount';
    /**
     * Constant for value 'TeleFormId'
     * @return string 'TeleFormId'
     */
    const VALUE_TELE_FORM_ID = 'TeleFormId';
    /**
     * Constant for value 'LockForm'
     * @return string 'LockForm'
     */
    const VALUE_LOCK_FORM = 'LockForm';
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Range'
     * @return string 'Range'
     */
    const VALUE_RANGE = 'Range';
    /**
     * Constant for value 'SurveyType'
     * @return string 'SurveyType'
     */
    const VALUE_SURVEY_TYPE = 'SurveyType';
    /**
     * Constant for value 'SurveySumReport'
     * @return string 'SurveySumReport'
     */
    const VALUE_SURVEY_SUM_REPORT = 'SurveySumReport';
    /**
     * Constant for value 'OnlineWizard'
     * @return string 'OnlineWizard'
     */
    const VALUE_ONLINE_WIZARD = 'OnlineWizard';
    /**
     * Constant for value 'Template'
     * @return string 'Template'
     */
    const VALUE_TEMPLATE = 'Template';
    /**
     * Constant for value 'RowHeight'
     * @return string 'RowHeight'
     */
    const VALUE_ROW_HEIGHT = 'RowHeight';
    /**
     * Constant for value 'FontFamily'
     * @return string 'FontFamily'
     */
    const VALUE_FONT_FAMILY = 'FontFamily';
    /**
     * Constant for value 'DefaultFontSize'
     * @return string 'DefaultFontSize'
     */
    const VALUE_DEFAULT_FONT_SIZE = 'DefaultFontSize';
    /**
     * Constant for value 'Extensible'
     * @return string 'Extensible'
     */
    const VALUE_EXTENSIBLE = 'Extensible';
    /**
     * Constant for value 'Version'
     * @return string 'Version'
     */
    const VALUE_VERSION = 'Version';
    /**
     * Constant for value 'MaxPages'
     * @return string 'MaxPages'
     */
    const VALUE_MAX_PAGES = 'MaxPages';
    /**
     * Constant for value 'DefaultLeft'
     * @return string 'DefaultLeft'
     */
    const VALUE_DEFAULT_LEFT = 'DefaultLeft';
    /**
     * Constant for value 'DefaultRight'
     * @return string 'DefaultRight'
     */
    const VALUE_DEFAULT_RIGHT = 'DefaultRight';
    /**
     * Constant for value 'DefaultAbstention'
     * @return string 'DefaultAbstention'
     */
    const VALUE_DEFAULT_ABSTENTION = 'DefaultAbstention';
    /**
     * Constant for value 'PDFVersion'
     * @return string 'PDFVersion'
     */
    const VALUE_PDFVERSION = 'PDFVersion';
    /**
     * Constant for value 'OrganisationField'
     * @return string 'OrganisationField'
     */
    const VALUE_ORGANISATION_FIELD = 'OrganisationField';
    /**
     * Constant for value 'AuthorField'
     * @return string 'AuthorField'
     */
    const VALUE_AUTHOR_FIELD = 'AuthorField';
    /**
     * Constant for value 'SubunitField'
     * @return string 'SubunitField'
     */
    const VALUE_SUBUNIT_FIELD = 'SubunitField';
    /**
     * Constant for value 'CourseField'
     * @return string 'CourseField'
     */
    const VALUE_COURSE_FIELD = 'CourseField';
    /**
     * Constant for value 'MarkField'
     * @return string 'MarkField'
     */
    const VALUE_MARK_FIELD = 'MarkField';
    /**
     * Constant for value 'CorrectionField'
     * @return string 'CorrectionField'
     */
    const VALUE_CORRECTION_FIELD = 'CorrectionField';
    /**
     * Constant for value 'MaxQuestions'
     * @return string 'MaxQuestions'
     */
    const VALUE_MAX_QUESTIONS = 'MaxQuestions';
    /**
     * Constant for value 'IsOnlinePrint'
     * @return string 'IsOnlinePrint'
     */
    const VALUE_IS_ONLINE_PRINT = 'IsOnlinePrint';
    /**
     * Constant for value 'EditorVersion'
     * @return string 'EditorVersion'
     */
    const VALUE_EDITOR_VERSION = 'EditorVersion';
    /**
     * Constant for value 'Certificate'
     * @return string 'Certificate'
     */
    const VALUE_CERTIFICATE = 'Certificate';
    /**
     * Constant for value 'ResultView'
     * @return string 'ResultView'
     */
    const VALUE_RESULT_VIEW = 'ResultView';
    /**
     * Constant for value 'ResultViewOpenQuestions'
     * @return string 'ResultViewOpenQuestions'
     */
    const VALUE_RESULT_VIEW_OPEN_QUESTIONS = 'ResultViewOpenQuestions';
    /**
     * Constant for value 'AddItemsOnlyToBottom'
     * @return string 'AddItemsOnlyToBottom'
     */
    const VALUE_ADD_ITEMS_ONLY_TO_BOTTOM = 'AddItemsOnlyToBottom';
    /**
     * Constant for value 'ShowOnlineSurveyDetails'
     * @return string 'ShowOnlineSurveyDetails'
     */
    const VALUE_SHOW_ONLINE_SURVEY_DETAILS = 'ShowOnlineSurveyDetails';
    /**
     * Constant for value 'DefaultReportId'
     * @return string 'DefaultReportId'
     */
    const VALUE_DEFAULT_REPORT_ID = 'DefaultReportId';
    /**
     * Constant for value 'Colorscheme'
     * @return string 'Colorscheme'
     */
    const VALUE_COLORSCHEME = 'Colorscheme';
    /**
     * Constant for value 'HeadHeight'
     * @return string 'HeadHeight'
     */
    const VALUE_HEAD_HEIGHT = 'HeadHeight';
    /**
     * Constant for value 'HeadLogoPositionH'
     * @return string 'HeadLogoPositionH'
     */
    const VALUE_HEAD_LOGO_POSITION_H = 'HeadLogoPositionH';
    /**
     * Constant for value 'HeadLogoPositionV'
     * @return string 'HeadLogoPositionV'
     */
    const VALUE_HEAD_LOGO_POSITION_V = 'HeadLogoPositionV';
    /**
     * Constant for value 'HeadLogoSize'
     * @return string 'HeadLogoSize'
     */
    const VALUE_HEAD_LOGO_SIZE = 'HeadLogoSize';
    /**
     * Constant for value 'Field_Row3_Field1'
     * @return string 'Field_Row3_Field1'
     */
    const VALUE_FIELD_ROW_3_FIELD_1 = 'Field_Row3_Field1';
    /**
     * Constant for value 'Field_Row3_Field2'
     * @return string 'Field_Row3_Field2'
     */
    const VALUE_FIELD_ROW_3_FIELD_2 = 'Field_Row3_Field2';
    /**
     * Constant for value 'Field_Row4_Field1'
     * @return string 'Field_Row4_Field1'
     */
    const VALUE_FIELD_ROW_4_FIELD_1 = 'Field_Row4_Field1';
    /**
     * Constant for value 'Field_Row4_Field2'
     * @return string 'Field_Row4_Field2'
     */
    const VALUE_FIELD_ROW_4_FIELD_2 = 'Field_Row4_Field2';
    /**
     * Constant for value 'Field_Row5_Field1'
     * @return string 'Field_Row5_Field1'
     */
    const VALUE_FIELD_ROW_5_FIELD_1 = 'Field_Row5_Field1';
    /**
     * Constant for value 'Field_Row5_Field2'
     * @return string 'Field_Row5_Field2'
     */
    const VALUE_FIELD_ROW_5_FIELD_2 = 'Field_Row5_Field2';
    /**
     * Constant for value 'Field_Row6_Field1'
     * @return string 'Field_Row6_Field1'
     */
    const VALUE_FIELD_ROW_6_FIELD_1 = 'Field_Row6_Field1';
    /**
     * Constant for value 'Field_Row6_Field2'
     * @return string 'Field_Row6_Field2'
     */
    const VALUE_FIELD_ROW_6_FIELD_2 = 'Field_Row6_Field2';
    /**
     * Constant for value 'Field_Row7_Field1'
     * @return string 'Field_Row7_Field1'
     */
    const VALUE_FIELD_ROW_7_FIELD_1 = 'Field_Row7_Field1';
    /**
     * Constant for value 'Field_Row7_Field2'
     * @return string 'Field_Row7_Field2'
     */
    const VALUE_FIELD_ROW_7_FIELD_2 = 'Field_Row7_Field2';
    /**
     * Constant for value 'Field_Row8_Field1'
     * @return string 'Field_Row8_Field1'
     */
    const VALUE_FIELD_ROW_8_FIELD_1 = 'Field_Row8_Field1';
    /**
     * Constant for value 'Field_Row8_Field2'
     * @return string 'Field_Row8_Field2'
     */
    const VALUE_FIELD_ROW_8_FIELD_2 = 'Field_Row8_Field2';
    /**
     * Constant for value 'Field_Row9_Field1'
     * @return string 'Field_Row9_Field1'
     */
    const VALUE_FIELD_ROW_9_FIELD_1 = 'Field_Row9_Field1';
    /**
     * Constant for value 'Field_Row9_Field2'
     * @return string 'Field_Row9_Field2'
     */
    const VALUE_FIELD_ROW_9_FIELD_2 = 'Field_Row9_Field2';
    /**
     * Constant for value 'Field_Row10_Field1'
     * @return string 'Field_Row10_Field1'
     */
    const VALUE_FIELD_ROW_10_FIELD_1 = 'Field_Row10_Field1';
    /**
     * Constant for value 'Field_Row10_Field2'
     * @return string 'Field_Row10_Field2'
     */
    const VALUE_FIELD_ROW_10_FIELD_2 = 'Field_Row10_Field2';
    /**
     * Constant for value 'Config'
     * @return string 'Config'
     */
    const VALUE_CONFIG = 'Config';
    /**
     * Constant for value 'Layout'
     * @return string 'Layout'
     */
    const VALUE_LAYOUT = 'Layout';
    /**
     * Constant for value 'SCAnswerPosition'
     * @return string 'SCAnswerPosition'
     */
    const VALUE_SCANSWER_POSITION = 'SCAnswerPosition';
    /**
     * Constant for value 'FormFolderName'
     * @return string 'FormFolderName'
     */
    const VALUE_FORM_FOLDER_NAME = 'FormFolderName';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SHORT_NAME
     * @uses self::VALUE_DESCRIPTION
     * @uses self::VALUE_OWNER_ID
     * @uses self::VALUE_ORIGINAL_ID
     * @uses self::VALUE_CREATE_DATE
     * @uses self::VALUE_CHANGE_DATE
     * @uses self::VALUE_IS_USED
     * @uses self::VALUE_IS_PARENT
     * @uses self::VALUE_MAIN_LANGUAGE_ID
     * @uses self::VALUE_FORM_ENGINE
     * @uses self::VALUE_IS_MIRROR
     * @uses self::VALUE_ONLINE_TEMP_SAVE
     * @uses self::VALUE_HEAD_LOGO_ID
     * @uses self::VALUE_ANSWER_BOX_SIZE
     * @uses self::VALUE_PAGE_FORMAT
     * @uses self::VALUE_SHOW_NUMERATION
     * @uses self::VALUE_PAGE_ORIENTATION
     * @uses self::VALUE_ENGINE_SUB_TYPE
     * @uses self::VALUE_FORM_OPTIONS
     * @uses self::VALUE_EXTRA_OPTIONS
     * @uses self::VALUE_URL
     * @uses self::VALUE_HAS_CUSTOM
     * @uses self::VALUE_PAGE_COUNT
     * @uses self::VALUE_TELE_FORM_ID
     * @uses self::VALUE_LOCK_FORM
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_RANGE
     * @uses self::VALUE_SURVEY_TYPE
     * @uses self::VALUE_SURVEY_SUM_REPORT
     * @uses self::VALUE_ONLINE_WIZARD
     * @uses self::VALUE_TEMPLATE
     * @uses self::VALUE_ROW_HEIGHT
     * @uses self::VALUE_FONT_FAMILY
     * @uses self::VALUE_DEFAULT_FONT_SIZE
     * @uses self::VALUE_EXTENSIBLE
     * @uses self::VALUE_VERSION
     * @uses self::VALUE_MAX_PAGES
     * @uses self::VALUE_DEFAULT_LEFT
     * @uses self::VALUE_DEFAULT_RIGHT
     * @uses self::VALUE_DEFAULT_ABSTENTION
     * @uses self::VALUE_PDFVERSION
     * @uses self::VALUE_ORGANISATION_FIELD
     * @uses self::VALUE_AUTHOR_FIELD
     * @uses self::VALUE_SUBUNIT_FIELD
     * @uses self::VALUE_COURSE_FIELD
     * @uses self::VALUE_MARK_FIELD
     * @uses self::VALUE_CORRECTION_FIELD
     * @uses self::VALUE_MAX_QUESTIONS
     * @uses self::VALUE_IS_ONLINE_PRINT
     * @uses self::VALUE_EDITOR_VERSION
     * @uses self::VALUE_CERTIFICATE
     * @uses self::VALUE_RESULT_VIEW
     * @uses self::VALUE_RESULT_VIEW_OPEN_QUESTIONS
     * @uses self::VALUE_ADD_ITEMS_ONLY_TO_BOTTOM
     * @uses self::VALUE_SHOW_ONLINE_SURVEY_DETAILS
     * @uses self::VALUE_DEFAULT_REPORT_ID
     * @uses self::VALUE_COLORSCHEME
     * @uses self::VALUE_HEAD_HEIGHT
     * @uses self::VALUE_HEAD_LOGO_POSITION_H
     * @uses self::VALUE_HEAD_LOGO_POSITION_V
     * @uses self::VALUE_HEAD_LOGO_SIZE
     * @uses self::VALUE_FIELD_ROW_3_FIELD_1
     * @uses self::VALUE_FIELD_ROW_3_FIELD_2
     * @uses self::VALUE_FIELD_ROW_4_FIELD_1
     * @uses self::VALUE_FIELD_ROW_4_FIELD_2
     * @uses self::VALUE_FIELD_ROW_5_FIELD_1
     * @uses self::VALUE_FIELD_ROW_5_FIELD_2
     * @uses self::VALUE_FIELD_ROW_6_FIELD_1
     * @uses self::VALUE_FIELD_ROW_6_FIELD_2
     * @uses self::VALUE_FIELD_ROW_7_FIELD_1
     * @uses self::VALUE_FIELD_ROW_7_FIELD_2
     * @uses self::VALUE_FIELD_ROW_8_FIELD_1
     * @uses self::VALUE_FIELD_ROW_8_FIELD_2
     * @uses self::VALUE_FIELD_ROW_9_FIELD_1
     * @uses self::VALUE_FIELD_ROW_9_FIELD_2
     * @uses self::VALUE_FIELD_ROW_10_FIELD_1
     * @uses self::VALUE_FIELD_ROW_10_FIELD_2
     * @uses self::VALUE_CONFIG
     * @uses self::VALUE_LAYOUT
     * @uses self::VALUE_SCANSWER_POSITION
     * @uses self::VALUE_FORM_FOLDER_NAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHORT_NAME,
            self::VALUE_DESCRIPTION,
            self::VALUE_OWNER_ID,
            self::VALUE_ORIGINAL_ID,
            self::VALUE_CREATE_DATE,
            self::VALUE_CHANGE_DATE,
            self::VALUE_IS_USED,
            self::VALUE_IS_PARENT,
            self::VALUE_MAIN_LANGUAGE_ID,
            self::VALUE_FORM_ENGINE,
            self::VALUE_IS_MIRROR,
            self::VALUE_ONLINE_TEMP_SAVE,
            self::VALUE_HEAD_LOGO_ID,
            self::VALUE_ANSWER_BOX_SIZE,
            self::VALUE_PAGE_FORMAT,
            self::VALUE_SHOW_NUMERATION,
            self::VALUE_PAGE_ORIENTATION,
            self::VALUE_ENGINE_SUB_TYPE,
            self::VALUE_FORM_OPTIONS,
            self::VALUE_EXTRA_OPTIONS,
            self::VALUE_URL,
            self::VALUE_HAS_CUSTOM,
            self::VALUE_PAGE_COUNT,
            self::VALUE_TELE_FORM_ID,
            self::VALUE_LOCK_FORM,
            self::VALUE_ACTIVE,
            self::VALUE_RANGE,
            self::VALUE_SURVEY_TYPE,
            self::VALUE_SURVEY_SUM_REPORT,
            self::VALUE_ONLINE_WIZARD,
            self::VALUE_TEMPLATE,
            self::VALUE_ROW_HEIGHT,
            self::VALUE_FONT_FAMILY,
            self::VALUE_DEFAULT_FONT_SIZE,
            self::VALUE_EXTENSIBLE,
            self::VALUE_VERSION,
            self::VALUE_MAX_PAGES,
            self::VALUE_DEFAULT_LEFT,
            self::VALUE_DEFAULT_RIGHT,
            self::VALUE_DEFAULT_ABSTENTION,
            self::VALUE_PDFVERSION,
            self::VALUE_ORGANISATION_FIELD,
            self::VALUE_AUTHOR_FIELD,
            self::VALUE_SUBUNIT_FIELD,
            self::VALUE_COURSE_FIELD,
            self::VALUE_MARK_FIELD,
            self::VALUE_CORRECTION_FIELD,
            self::VALUE_MAX_QUESTIONS,
            self::VALUE_IS_ONLINE_PRINT,
            self::VALUE_EDITOR_VERSION,
            self::VALUE_CERTIFICATE,
            self::VALUE_RESULT_VIEW,
            self::VALUE_RESULT_VIEW_OPEN_QUESTIONS,
            self::VALUE_ADD_ITEMS_ONLY_TO_BOTTOM,
            self::VALUE_SHOW_ONLINE_SURVEY_DETAILS,
            self::VALUE_DEFAULT_REPORT_ID,
            self::VALUE_COLORSCHEME,
            self::VALUE_HEAD_HEIGHT,
            self::VALUE_HEAD_LOGO_POSITION_H,
            self::VALUE_HEAD_LOGO_POSITION_V,
            self::VALUE_HEAD_LOGO_SIZE,
            self::VALUE_FIELD_ROW_3_FIELD_1,
            self::VALUE_FIELD_ROW_3_FIELD_2,
            self::VALUE_FIELD_ROW_4_FIELD_1,
            self::VALUE_FIELD_ROW_4_FIELD_2,
            self::VALUE_FIELD_ROW_5_FIELD_1,
            self::VALUE_FIELD_ROW_5_FIELD_2,
            self::VALUE_FIELD_ROW_6_FIELD_1,
            self::VALUE_FIELD_ROW_6_FIELD_2,
            self::VALUE_FIELD_ROW_7_FIELD_1,
            self::VALUE_FIELD_ROW_7_FIELD_2,
            self::VALUE_FIELD_ROW_8_FIELD_1,
            self::VALUE_FIELD_ROW_8_FIELD_2,
            self::VALUE_FIELD_ROW_9_FIELD_1,
            self::VALUE_FIELD_ROW_9_FIELD_2,
            self::VALUE_FIELD_ROW_10_FIELD_1,
            self::VALUE_FIELD_ROW_10_FIELD_2,
            self::VALUE_CONFIG,
            self::VALUE_LAYOUT,
            self::VALUE_SCANSWER_POSITION,
            self::VALUE_FORM_FOLDER_NAME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
