<?php

namespace EnumType;

/**
 * This class stands for FormSearchType EnumType
 * @subpackage Enumerations
 */
class FormSearchType
{
    /**
     * Constant for value 'Form'
     * @return string 'Form'
     */
    const VALUE_FORM = 'Form';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'Question'
     * @return string 'Question'
     */
    const VALUE_QUESTION = 'Question';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value ''
     * @return string ''
     */
    const VALUE_ = '';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FORM
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_QUESTION
     * @uses self::VALUE_ALL
     * @uses self::VALUE_
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FORM,
            self::VALUE_GROUP,
            self::VALUE_QUESTION,
            self::VALUE_ALL,
            self::VALUE_,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
