<?php

namespace EnumType;

/**
 * This class stands for FormProcedure EnumType
 * @subpackage Enumerations
 */
class FormProcedure
{
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'CENTRALEVALUATION'
     * @return string 'CENTRALEVALUATION'
     */
    const VALUE_CENTRALEVALUATION = 'CENTRALEVALUATION';
    /**
     * Constant for value 'DECENTRALEVALUATION'
     * @return string 'DECENTRALEVALUATION'
     */
    const VALUE_DECENTRALEVALUATION = 'DECENTRALEVALUATION';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_CENTRALEVALUATION
     * @uses self::VALUE_DECENTRALEVALUATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_CENTRALEVALUATION,
            self::VALUE_DECENTRALEVALUATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
