<?php

namespace EnumType;

/**
 * This class stands for EntityListValue EnumType
 * @subpackage Enumerations
 */
class EntityListValue
{
    /**
     * Constant for value 'Subunit'
     * @return string 'Subunit'
     */
    const VALUE_SUBUNIT = 'Subunit';
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'Course'
     * @return string 'Course'
     */
    const VALUE_COURSE = 'Course';
    /**
     * Constant for value 'Survey'
     * @return string 'Survey'
     */
    const VALUE_SURVEY = 'Survey';
    /**
     * Constant for value 'Participant'
     * @return string 'Participant'
     */
    const VALUE_PARTICIPANT = 'Participant';
    /**
     * Constant for value 'Log'
     * @return string 'Log'
     */
    const VALUE_LOG = 'Log';
    /**
     * Constant for value 'Delivery'
     * @return string 'Delivery'
     */
    const VALUE_DELIVERY = 'Delivery';
    /**
     * Constant for value 'Notices'
     * @return string 'Notices'
     */
    const VALUE_NOTICES = 'Notices';
    /**
     * Constant for value 'Results'
     * @return string 'Results'
     */
    const VALUE_RESULTS = 'Results';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUBUNIT
     * @uses self::VALUE_USER
     * @uses self::VALUE_COURSE
     * @uses self::VALUE_SURVEY
     * @uses self::VALUE_PARTICIPANT
     * @uses self::VALUE_LOG
     * @uses self::VALUE_DELIVERY
     * @uses self::VALUE_NOTICES
     * @uses self::VALUE_RESULTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUBUNIT,
            self::VALUE_USER,
            self::VALUE_COURSE,
            self::VALUE_SURVEY,
            self::VALUE_PARTICIPANT,
            self::VALUE_LOG,
            self::VALUE_DELIVERY,
            self::VALUE_NOTICES,
            self::VALUE_RESULTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
