<?php

namespace EnumType;

/**
 * This class stands for DateUnit EnumType
 * @subpackage Enumerations
 */
class DateUnit
{
    /**
     * Constant for value 'year'
     * @return string 'year'
     */
    const VALUE_YEAR = 'year';
    /**
     * Constant for value 'month'
     * @return string 'month'
     */
    const VALUE_MONTH = 'month';
    /**
     * Constant for value 'week'
     * @return string 'week'
     */
    const VALUE_WEEK = 'week';
    /**
     * Constant for value 'day'
     * @return string 'day'
     */
    const VALUE_DAY = 'day';
    /**
     * Constant for value 'hour'
     * @return string 'hour'
     */
    const VALUE_HOUR = 'hour';
    /**
     * Constant for value 'minute'
     * @return string 'minute'
     */
    const VALUE_MINUTE = 'minute';
    /**
     * Constant for value 'second'
     * @return string 'second'
     */
    const VALUE_SECOND = 'second';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_YEAR
     * @uses self::VALUE_MONTH
     * @uses self::VALUE_WEEK
     * @uses self::VALUE_DAY
     * @uses self::VALUE_HOUR
     * @uses self::VALUE_MINUTE
     * @uses self::VALUE_SECOND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_YEAR,
            self::VALUE_MONTH,
            self::VALUE_WEEK,
            self::VALUE_DAY,
            self::VALUE_HOUR,
            self::VALUE_MINUTE,
            self::VALUE_SECOND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
