<?php

namespace EnumType;

/**
 * This class stands for BatchIdType EnumType
 * @subpackage Enumerations
 */
class BatchIdType
{
    /**
     * Constant for value 'VERIFIER_BATCH'
     * @return string 'VERIFIER_BATCH'
     */
    const VALUE_VERIFIER_BATCH = 'VERIFIER_BATCH';
    /**
     * Constant for value 'SCAN_BATCH'
     * @return string 'SCAN_BATCH'
     */
    const VALUE_SCAN_BATCH = 'SCAN_BATCH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VERIFIER_BATCH
     * @uses self::VALUE_SCAN_BATCH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VERIFIER_BATCH,
            self::VALUE_SCAN_BATCH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
