<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PAYMENT_WAY_PER_IDENTITY StructType
 * @subpackage Structs
 */
class PAYMENT_WAY_PER_IDENTITY extends AbstractStructBase
{
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The IDENTITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDENTITY;
    /**
     * The PARTY_TYPE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARTY_TYPE_DB;
    /**
     * The WAY_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WAY_ID;
    /**
     * The DEFAULT_PAYMENT_WAY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEFAULT_PAYMENT_WAY;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * The ADDRESSES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ADDRESSES
     */
    public $ADDRESSES;
    /**
     * Constructor method for PAYMENT_WAY_PER_IDENTITY
     * @uses PAYMENT_WAY_PER_IDENTITY::setCOMPANY()
     * @uses PAYMENT_WAY_PER_IDENTITY::setIDENTITY()
     * @uses PAYMENT_WAY_PER_IDENTITY::setPARTY_TYPE_DB()
     * @uses PAYMENT_WAY_PER_IDENTITY::setWAY_ID()
     * @uses PAYMENT_WAY_PER_IDENTITY::setDEFAULT_PAYMENT_WAY()
     * @uses PAYMENT_WAY_PER_IDENTITY::setOPERATION()
     * @uses PAYMENT_WAY_PER_IDENTITY::setADDRESSES()
     * @param string $cOMPANY
     * @param string $iDENTITY
     * @param string $pARTY_TYPE_DB
     * @param string $wAY_ID
     * @param string $dEFAULT_PAYMENT_WAY
     * @param string $oPERATION
     * @param \StructType\ADDRESSES $aDDRESSES
     */
    public function __construct($cOMPANY = null, $iDENTITY = null, $pARTY_TYPE_DB = null, $wAY_ID = null, $dEFAULT_PAYMENT_WAY = null, $oPERATION = null, \StructType\ADDRESSES $aDDRESSES = null)
    {
        $this
            ->setCOMPANY($cOMPANY)
            ->setIDENTITY($iDENTITY)
            ->setPARTY_TYPE_DB($pARTY_TYPE_DB)
            ->setWAY_ID($wAY_ID)
            ->setDEFAULT_PAYMENT_WAY($dEFAULT_PAYMENT_WAY)
            ->setOPERATION($oPERATION)
            ->setADDRESSES($aDDRESSES);
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\PAYMENT_WAY_PER_IDENTITY
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get IDENTITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDENTITY()
    {
        return isset($this->IDENTITY) ? $this->IDENTITY : null;
    }
    /**
     * Set IDENTITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDENTITY
     * @return \StructType\PAYMENT_WAY_PER_IDENTITY
     */
    public function setIDENTITY($iDENTITY = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTITY) && !is_string($iDENTITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTITY)), __LINE__);
        }
        if (is_null($iDENTITY) || (is_array($iDENTITY) && empty($iDENTITY))) {
            unset($this->IDENTITY);
        } else {
            $this->IDENTITY = $iDENTITY;
        }
        return $this;
    }
    /**
     * Get PARTY_TYPE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARTY_TYPE_DB()
    {
        return isset($this->PARTY_TYPE_DB) ? $this->PARTY_TYPE_DB : null;
    }
    /**
     * Set PARTY_TYPE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARTY_TYPE_DB
     * @return \StructType\PAYMENT_WAY_PER_IDENTITY
     */
    public function setPARTY_TYPE_DB($pARTY_TYPE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pARTY_TYPE_DB) && !is_string($pARTY_TYPE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARTY_TYPE_DB)), __LINE__);
        }
        if (is_null($pARTY_TYPE_DB) || (is_array($pARTY_TYPE_DB) && empty($pARTY_TYPE_DB))) {
            unset($this->PARTY_TYPE_DB);
        } else {
            $this->PARTY_TYPE_DB = $pARTY_TYPE_DB;
        }
        return $this;
    }
    /**
     * Get WAY_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWAY_ID()
    {
        return isset($this->WAY_ID) ? $this->WAY_ID : null;
    }
    /**
     * Set WAY_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wAY_ID
     * @return \StructType\PAYMENT_WAY_PER_IDENTITY
     */
    public function setWAY_ID($wAY_ID = null)
    {
        // validation for constraint: string
        if (!is_null($wAY_ID) && !is_string($wAY_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wAY_ID)), __LINE__);
        }
        if (is_null($wAY_ID) || (is_array($wAY_ID) && empty($wAY_ID))) {
            unset($this->WAY_ID);
        } else {
            $this->WAY_ID = $wAY_ID;
        }
        return $this;
    }
    /**
     * Get DEFAULT_PAYMENT_WAY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEFAULT_PAYMENT_WAY()
    {
        return isset($this->DEFAULT_PAYMENT_WAY) ? $this->DEFAULT_PAYMENT_WAY : null;
    }
    /**
     * Set DEFAULT_PAYMENT_WAY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEFAULT_PAYMENT_WAY
     * @return \StructType\PAYMENT_WAY_PER_IDENTITY
     */
    public function setDEFAULT_PAYMENT_WAY($dEFAULT_PAYMENT_WAY = null)
    {
        // validation for constraint: string
        if (!is_null($dEFAULT_PAYMENT_WAY) && !is_string($dEFAULT_PAYMENT_WAY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEFAULT_PAYMENT_WAY)), __LINE__);
        }
        if (is_null($dEFAULT_PAYMENT_WAY) || (is_array($dEFAULT_PAYMENT_WAY) && empty($dEFAULT_PAYMENT_WAY))) {
            unset($this->DEFAULT_PAYMENT_WAY);
        } else {
            $this->DEFAULT_PAYMENT_WAY = $dEFAULT_PAYMENT_WAY;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\PAYMENT_WAY_PER_IDENTITY
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Get ADDRESSES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ADDRESSES|null
     */
    public function getADDRESSES()
    {
        return isset($this->ADDRESSES) ? $this->ADDRESSES : null;
    }
    /**
     * Set ADDRESSES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ADDRESSES $aDDRESSES
     * @return \StructType\PAYMENT_WAY_PER_IDENTITY
     */
    public function setADDRESSES(\StructType\ADDRESSES $aDDRESSES = null)
    {
        if (is_null($aDDRESSES) || (is_array($aDDRESSES) && empty($aDDRESSES))) {
            unset($this->ADDRESSES);
        } else {
            $this->ADDRESSES = $aDDRESSES;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PAYMENT_WAY_PER_IDENTITY
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
