<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICE_PDF_INFO StructType
 * @subpackage Structs
 */
class INVOICE_PDF_INFO extends AbstractStructBase
{
    /**
     * The RESULT_KEY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RESULT_KEY;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The PDF_SIZE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PDF_SIZE;
    /**
     * The LAYOUT_NAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LAYOUT_NAME;
    /**
     * The LANG_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LANG_CODE;
    /**
     * The NOTES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NOTES;
    /**
     * The CREATED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREATED;
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The INVOICE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $INVOICE_ID;
    /**
     * The SERIES_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $SERIES_ID;
    /**
     * The INVOICE_NO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $INVOICE_NO;
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The CUSTOMER_NAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $CUSTOMER_NAME;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * Constructor method for INVOICE_PDF_INFO
     * @uses INVOICE_PDF_INFO::setRESULT_KEY()
     * @uses INVOICE_PDF_INFO::setID()
     * @uses INVOICE_PDF_INFO::setPDF_SIZE()
     * @uses INVOICE_PDF_INFO::setLAYOUT_NAME()
     * @uses INVOICE_PDF_INFO::setLANG_CODE()
     * @uses INVOICE_PDF_INFO::setNOTES()
     * @uses INVOICE_PDF_INFO::setCREATED()
     * @uses INVOICE_PDF_INFO::setCOMPANY()
     * @uses INVOICE_PDF_INFO::setINVOICE_ID()
     * @uses INVOICE_PDF_INFO::setSERIES_ID()
     * @uses INVOICE_PDF_INFO::setINVOICE_NO()
     * @uses INVOICE_PDF_INFO::setCUSTOMER_ID()
     * @uses INVOICE_PDF_INFO::setCUSTOMER_NAME()
     * @uses INVOICE_PDF_INFO::setOPERATION()
     * @param float $rESULT_KEY
     * @param string $iD
     * @param float $pDF_SIZE
     * @param string $lAYOUT_NAME
     * @param string $lANG_CODE
     * @param string $nOTES
     * @param string $cREATED
     * @param string $cOMPANY
     * @param int $iNVOICE_ID
     * @param string $sERIES_ID
     * @param string $iNVOICE_NO
     * @param string $cUSTOMER_ID
     * @param string $cUSTOMER_NAME
     * @param string $oPERATION
     */
    public function __construct($rESULT_KEY = null, $iD = null, $pDF_SIZE = null, $lAYOUT_NAME = null, $lANG_CODE = null, $nOTES = null, $cREATED = null, $cOMPANY = null, $iNVOICE_ID = null, $sERIES_ID = null, $iNVOICE_NO = null, $cUSTOMER_ID = null, $cUSTOMER_NAME = null, $oPERATION = null)
    {
        $this
            ->setRESULT_KEY($rESULT_KEY)
            ->setID($iD)
            ->setPDF_SIZE($pDF_SIZE)
            ->setLAYOUT_NAME($lAYOUT_NAME)
            ->setLANG_CODE($lANG_CODE)
            ->setNOTES($nOTES)
            ->setCREATED($cREATED)
            ->setCOMPANY($cOMPANY)
            ->setINVOICE_ID($iNVOICE_ID)
            ->setSERIES_ID($sERIES_ID)
            ->setINVOICE_NO($iNVOICE_NO)
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setCUSTOMER_NAME($cUSTOMER_NAME)
            ->setOPERATION($oPERATION);
    }
    /**
     * Get RESULT_KEY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRESULT_KEY()
    {
        return isset($this->RESULT_KEY) ? $this->RESULT_KEY : null;
    }
    /**
     * Set RESULT_KEY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $rESULT_KEY
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setRESULT_KEY($rESULT_KEY = null)
    {
        if (is_null($rESULT_KEY) || (is_array($rESULT_KEY) && empty($rESULT_KEY))) {
            unset($this->RESULT_KEY);
        } else {
            $this->RESULT_KEY = $rESULT_KEY;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get PDF_SIZE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPDF_SIZE()
    {
        return isset($this->PDF_SIZE) ? $this->PDF_SIZE : null;
    }
    /**
     * Set PDF_SIZE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pDF_SIZE
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setPDF_SIZE($pDF_SIZE = null)
    {
        if (is_null($pDF_SIZE) || (is_array($pDF_SIZE) && empty($pDF_SIZE))) {
            unset($this->PDF_SIZE);
        } else {
            $this->PDF_SIZE = $pDF_SIZE;
        }
        return $this;
    }
    /**
     * Get LAYOUT_NAME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLAYOUT_NAME()
    {
        return isset($this->LAYOUT_NAME) ? $this->LAYOUT_NAME : null;
    }
    /**
     * Set LAYOUT_NAME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lAYOUT_NAME
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setLAYOUT_NAME($lAYOUT_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($lAYOUT_NAME) && !is_string($lAYOUT_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lAYOUT_NAME)), __LINE__);
        }
        if (is_null($lAYOUT_NAME) || (is_array($lAYOUT_NAME) && empty($lAYOUT_NAME))) {
            unset($this->LAYOUT_NAME);
        } else {
            $this->LAYOUT_NAME = $lAYOUT_NAME;
        }
        return $this;
    }
    /**
     * Get LANG_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLANG_CODE()
    {
        return isset($this->LANG_CODE) ? $this->LANG_CODE : null;
    }
    /**
     * Set LANG_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lANG_CODE
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setLANG_CODE($lANG_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($lANG_CODE) && !is_string($lANG_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lANG_CODE)), __LINE__);
        }
        if (is_null($lANG_CODE) || (is_array($lANG_CODE) && empty($lANG_CODE))) {
            unset($this->LANG_CODE);
        } else {
            $this->LANG_CODE = $lANG_CODE;
        }
        return $this;
    }
    /**
     * Get NOTES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNOTES()
    {
        return isset($this->NOTES) ? $this->NOTES : null;
    }
    /**
     * Set NOTES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nOTES
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setNOTES($nOTES = null)
    {
        // validation for constraint: string
        if (!is_null($nOTES) && !is_string($nOTES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nOTES)), __LINE__);
        }
        if (is_null($nOTES) || (is_array($nOTES) && empty($nOTES))) {
            unset($this->NOTES);
        } else {
            $this->NOTES = $nOTES;
        }
        return $this;
    }
    /**
     * Get CREATED value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREATED()
    {
        return isset($this->CREATED) ? $this->CREATED : null;
    }
    /**
     * Set CREATED value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREATED
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setCREATED($cREATED = null)
    {
        // validation for constraint: string
        if (!is_null($cREATED) && !is_string($cREATED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREATED)), __LINE__);
        }
        if (is_null($cREATED) || (is_array($cREATED) && empty($cREATED))) {
            unset($this->CREATED);
        } else {
            $this->CREATED = $cREATED;
        }
        return $this;
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get INVOICE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getINVOICE_ID()
    {
        return isset($this->INVOICE_ID) ? $this->INVOICE_ID : null;
    }
    /**
     * Set INVOICE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iNVOICE_ID
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setINVOICE_ID($iNVOICE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iNVOICE_ID) && !is_numeric($iNVOICE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iNVOICE_ID)), __LINE__);
        }
        if (is_null($iNVOICE_ID) || (is_array($iNVOICE_ID) && empty($iNVOICE_ID))) {
            unset($this->INVOICE_ID);
        } else {
            $this->INVOICE_ID = $iNVOICE_ID;
        }
        return $this;
    }
    /**
     * Get SERIES_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSERIES_ID()
    {
        return isset($this->SERIES_ID) ? $this->SERIES_ID : null;
    }
    /**
     * Set SERIES_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sERIES_ID
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setSERIES_ID($sERIES_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sERIES_ID) && strlen($sERIES_ID) > 20) || (is_array($sERIES_ID) && count($sERIES_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($sERIES_ID) ? strlen($sERIES_ID) : count($sERIES_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sERIES_ID) && !is_string($sERIES_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sERIES_ID)), __LINE__);
        }
        if (is_null($sERIES_ID) || (is_array($sERIES_ID) && empty($sERIES_ID))) {
            unset($this->SERIES_ID);
        } else {
            $this->SERIES_ID = $sERIES_ID;
        }
        return $this;
    }
    /**
     * Get INVOICE_NO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINVOICE_NO()
    {
        return isset($this->INVOICE_NO) ? $this->INVOICE_NO : null;
    }
    /**
     * Set INVOICE_NO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNVOICE_NO
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setINVOICE_NO($iNVOICE_NO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iNVOICE_NO) && strlen($iNVOICE_NO) > 20) || (is_array($iNVOICE_NO) && count($iNVOICE_NO) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($iNVOICE_NO) ? strlen($iNVOICE_NO) : count($iNVOICE_NO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNVOICE_NO) && !is_string($iNVOICE_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVOICE_NO)), __LINE__);
        }
        if (is_null($iNVOICE_NO) || (is_array($iNVOICE_NO) && empty($iNVOICE_NO))) {
            unset($this->INVOICE_NO);
        } else {
            $this->INVOICE_NO = $iNVOICE_NO;
        }
        return $this;
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get CUSTOMER_NAME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_NAME()
    {
        return isset($this->CUSTOMER_NAME) ? $this->CUSTOMER_NAME : null;
    }
    /**
     * Set CUSTOMER_NAME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_NAME
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setCUSTOMER_NAME($cUSTOMER_NAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_NAME) && strlen($cUSTOMER_NAME) > 200) || (is_array($cUSTOMER_NAME) && count($cUSTOMER_NAME) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($cUSTOMER_NAME) ? strlen($cUSTOMER_NAME) : count($cUSTOMER_NAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_NAME) && !is_string($cUSTOMER_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_NAME)), __LINE__);
        }
        if (is_null($cUSTOMER_NAME) || (is_array($cUSTOMER_NAME) && empty($cUSTOMER_NAME))) {
            unset($this->CUSTOMER_NAME);
        } else {
            $this->CUSTOMER_NAME = $cUSTOMER_NAME;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\INVOICE_PDF_INFO
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\INVOICE_PDF_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
