<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IDENTITY_PAY_INFO StructType
 * @subpackage Structs
 */
class IDENTITY_PAY_INFO extends AbstractStructBase
{
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The IDENTITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDENTITY;
    /**
     * The PARTY_TYPE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARTY_TYPE_DB;
    /**
     * The PRIORITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PRIORITY;
    /**
     * The BLOCKED_FOR_PAYMENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BLOCKED_FOR_PAYMENT;
    /**
     * The OTHER_PAYEE_IDENTITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OTHER_PAYEE_IDENTITY;
    /**
     * The INTEREST_TEMPLATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INTEREST_TEMPLATE;
    /**
     * The REMINDER_TEMPLATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $REMINDER_TEMPLATE;
    /**
     * The PAYMENT_DELAY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PAYMENT_DELAY;
    /**
     * The AMOUNT_TOLERANCE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AMOUNT_TOLERANCE;
    /**
     * The PERCENT_TOLERANCE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PERCENT_TOLERANCE;
    /**
     * The DISC_DAYS_TOLERANCE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DISC_DAYS_TOLERANCE;
    /**
     * The NETTING_ALLOWED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NETTING_ALLOWED;
    /**
     * The FORMAT_NO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FORMAT_NO;
    /**
     * The PAYMENT_ADVICE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PAYMENT_ADVICE_DB;
    /**
     * The DEDUCTION_GROUP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEDUCTION_GROUP;
    /**
     * The CORPORATION_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CORPORATION_ID;
    /**
     * The MEMBER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MEMBER_ID;
    /**
     * The SEND_REMINDER_TO_PAYER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SEND_REMINDER_TO_PAYER;
    /**
     * The SEND_INTEREST_INV_TO_PAYER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SEND_INTEREST_INV_TO_PAYER;
    /**
     * The RULE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RULE_ID;
    /**
     * The PAYMENT_RECEIPT_TYPE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PAYMENT_RECEIPT_TYPE_DB;
    /**
     * The TEMPLATE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TEMPLATE_ID;
    /**
     * The CHECK_RECIPIENT_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CHECK_RECIPIENT_DB;
    /**
     * The SEND_STMT_OF_ACC_TO_PAYER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SEND_STMT_OF_ACC_TO_PAYER;
    /**
     * The AR_CONTACT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AR_CONTACT;
    /**
     * The COMM_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $COMM_ID;
    /**
     * The OUTPUT_MEDIA_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OUTPUT_MEDIA_DB;
    /**
     * The DEFAULT_PAYMENT_METHOD
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEFAULT_PAYMENT_METHOD;
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The SUPPLIER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPPLIER_ID;
    /**
     * The NEXT_PAYMENT_MATCHING_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NEXT_PAYMENT_MATCHING_ID;
    /**
     * The IS_ONE_INV_PER_PAY_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IS_ONE_INV_PER_PAY_DB;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * The PAYMENT_WAYS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PAYMENT_WAYS
     */
    public $PAYMENT_WAYS;
    /**
     * Constructor method for IDENTITY_PAY_INFO
     * @uses IDENTITY_PAY_INFO::setCOMPANY()
     * @uses IDENTITY_PAY_INFO::setIDENTITY()
     * @uses IDENTITY_PAY_INFO::setPARTY_TYPE_DB()
     * @uses IDENTITY_PAY_INFO::setPRIORITY()
     * @uses IDENTITY_PAY_INFO::setBLOCKED_FOR_PAYMENT()
     * @uses IDENTITY_PAY_INFO::setOTHER_PAYEE_IDENTITY()
     * @uses IDENTITY_PAY_INFO::setINTEREST_TEMPLATE()
     * @uses IDENTITY_PAY_INFO::setREMINDER_TEMPLATE()
     * @uses IDENTITY_PAY_INFO::setPAYMENT_DELAY()
     * @uses IDENTITY_PAY_INFO::setAMOUNT_TOLERANCE()
     * @uses IDENTITY_PAY_INFO::setPERCENT_TOLERANCE()
     * @uses IDENTITY_PAY_INFO::setDISC_DAYS_TOLERANCE()
     * @uses IDENTITY_PAY_INFO::setNETTING_ALLOWED()
     * @uses IDENTITY_PAY_INFO::setFORMAT_NO()
     * @uses IDENTITY_PAY_INFO::setPAYMENT_ADVICE_DB()
     * @uses IDENTITY_PAY_INFO::setDEDUCTION_GROUP()
     * @uses IDENTITY_PAY_INFO::setCORPORATION_ID()
     * @uses IDENTITY_PAY_INFO::setMEMBER_ID()
     * @uses IDENTITY_PAY_INFO::setSEND_REMINDER_TO_PAYER()
     * @uses IDENTITY_PAY_INFO::setSEND_INTEREST_INV_TO_PAYER()
     * @uses IDENTITY_PAY_INFO::setRULE_ID()
     * @uses IDENTITY_PAY_INFO::setPAYMENT_RECEIPT_TYPE_DB()
     * @uses IDENTITY_PAY_INFO::setTEMPLATE_ID()
     * @uses IDENTITY_PAY_INFO::setCHECK_RECIPIENT_DB()
     * @uses IDENTITY_PAY_INFO::setSEND_STMT_OF_ACC_TO_PAYER()
     * @uses IDENTITY_PAY_INFO::setAR_CONTACT()
     * @uses IDENTITY_PAY_INFO::setCOMM_ID()
     * @uses IDENTITY_PAY_INFO::setOUTPUT_MEDIA_DB()
     * @uses IDENTITY_PAY_INFO::setDEFAULT_PAYMENT_METHOD()
     * @uses IDENTITY_PAY_INFO::setCUSTOMER_ID()
     * @uses IDENTITY_PAY_INFO::setSUPPLIER_ID()
     * @uses IDENTITY_PAY_INFO::setNEXT_PAYMENT_MATCHING_ID()
     * @uses IDENTITY_PAY_INFO::setIS_ONE_INV_PER_PAY_DB()
     * @uses IDENTITY_PAY_INFO::setOPERATION()
     * @uses IDENTITY_PAY_INFO::setPAYMENT_WAYS()
     * @param string $cOMPANY
     * @param string $iDENTITY
     * @param string $pARTY_TYPE_DB
     * @param float $pRIORITY
     * @param string $bLOCKED_FOR_PAYMENT
     * @param string $oTHER_PAYEE_IDENTITY
     * @param string $iNTEREST_TEMPLATE
     * @param string $rEMINDER_TEMPLATE
     * @param float $pAYMENT_DELAY
     * @param float $aMOUNT_TOLERANCE
     * @param float $pERCENT_TOLERANCE
     * @param float $dISC_DAYS_TOLERANCE
     * @param string $nETTING_ALLOWED
     * @param float $fORMAT_NO
     * @param string $pAYMENT_ADVICE_DB
     * @param string $dEDUCTION_GROUP
     * @param string $cORPORATION_ID
     * @param string $mEMBER_ID
     * @param string $sEND_REMINDER_TO_PAYER
     * @param string $sEND_INTEREST_INV_TO_PAYER
     * @param string $rULE_ID
     * @param string $pAYMENT_RECEIPT_TYPE_DB
     * @param string $tEMPLATE_ID
     * @param string $cHECK_RECIPIENT_DB
     * @param string $sEND_STMT_OF_ACC_TO_PAYER
     * @param string $aR_CONTACT
     * @param float $cOMM_ID
     * @param string $oUTPUT_MEDIA_DB
     * @param string $dEFAULT_PAYMENT_METHOD
     * @param string $cUSTOMER_ID
     * @param string $sUPPLIER_ID
     * @param float $nEXT_PAYMENT_MATCHING_ID
     * @param string $iS_ONE_INV_PER_PAY_DB
     * @param string $oPERATION
     * @param \StructType\PAYMENT_WAYS $pAYMENT_WAYS
     */
    public function __construct($cOMPANY = null, $iDENTITY = null, $pARTY_TYPE_DB = null, $pRIORITY = null, $bLOCKED_FOR_PAYMENT = null, $oTHER_PAYEE_IDENTITY = null, $iNTEREST_TEMPLATE = null, $rEMINDER_TEMPLATE = null, $pAYMENT_DELAY = null, $aMOUNT_TOLERANCE = null, $pERCENT_TOLERANCE = null, $dISC_DAYS_TOLERANCE = null, $nETTING_ALLOWED = null, $fORMAT_NO = null, $pAYMENT_ADVICE_DB = null, $dEDUCTION_GROUP = null, $cORPORATION_ID = null, $mEMBER_ID = null, $sEND_REMINDER_TO_PAYER = null, $sEND_INTEREST_INV_TO_PAYER = null, $rULE_ID = null, $pAYMENT_RECEIPT_TYPE_DB = null, $tEMPLATE_ID = null, $cHECK_RECIPIENT_DB = null, $sEND_STMT_OF_ACC_TO_PAYER = null, $aR_CONTACT = null, $cOMM_ID = null, $oUTPUT_MEDIA_DB = null, $dEFAULT_PAYMENT_METHOD = null, $cUSTOMER_ID = null, $sUPPLIER_ID = null, $nEXT_PAYMENT_MATCHING_ID = null, $iS_ONE_INV_PER_PAY_DB = null, $oPERATION = null, \StructType\PAYMENT_WAYS $pAYMENT_WAYS = null)
    {
        $this
            ->setCOMPANY($cOMPANY)
            ->setIDENTITY($iDENTITY)
            ->setPARTY_TYPE_DB($pARTY_TYPE_DB)
            ->setPRIORITY($pRIORITY)
            ->setBLOCKED_FOR_PAYMENT($bLOCKED_FOR_PAYMENT)
            ->setOTHER_PAYEE_IDENTITY($oTHER_PAYEE_IDENTITY)
            ->setINTEREST_TEMPLATE($iNTEREST_TEMPLATE)
            ->setREMINDER_TEMPLATE($rEMINDER_TEMPLATE)
            ->setPAYMENT_DELAY($pAYMENT_DELAY)
            ->setAMOUNT_TOLERANCE($aMOUNT_TOLERANCE)
            ->setPERCENT_TOLERANCE($pERCENT_TOLERANCE)
            ->setDISC_DAYS_TOLERANCE($dISC_DAYS_TOLERANCE)
            ->setNETTING_ALLOWED($nETTING_ALLOWED)
            ->setFORMAT_NO($fORMAT_NO)
            ->setPAYMENT_ADVICE_DB($pAYMENT_ADVICE_DB)
            ->setDEDUCTION_GROUP($dEDUCTION_GROUP)
            ->setCORPORATION_ID($cORPORATION_ID)
            ->setMEMBER_ID($mEMBER_ID)
            ->setSEND_REMINDER_TO_PAYER($sEND_REMINDER_TO_PAYER)
            ->setSEND_INTEREST_INV_TO_PAYER($sEND_INTEREST_INV_TO_PAYER)
            ->setRULE_ID($rULE_ID)
            ->setPAYMENT_RECEIPT_TYPE_DB($pAYMENT_RECEIPT_TYPE_DB)
            ->setTEMPLATE_ID($tEMPLATE_ID)
            ->setCHECK_RECIPIENT_DB($cHECK_RECIPIENT_DB)
            ->setSEND_STMT_OF_ACC_TO_PAYER($sEND_STMT_OF_ACC_TO_PAYER)
            ->setAR_CONTACT($aR_CONTACT)
            ->setCOMM_ID($cOMM_ID)
            ->setOUTPUT_MEDIA_DB($oUTPUT_MEDIA_DB)
            ->setDEFAULT_PAYMENT_METHOD($dEFAULT_PAYMENT_METHOD)
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setSUPPLIER_ID($sUPPLIER_ID)
            ->setNEXT_PAYMENT_MATCHING_ID($nEXT_PAYMENT_MATCHING_ID)
            ->setIS_ONE_INV_PER_PAY_DB($iS_ONE_INV_PER_PAY_DB)
            ->setOPERATION($oPERATION)
            ->setPAYMENT_WAYS($pAYMENT_WAYS);
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get IDENTITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDENTITY()
    {
        return isset($this->IDENTITY) ? $this->IDENTITY : null;
    }
    /**
     * Set IDENTITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDENTITY
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setIDENTITY($iDENTITY = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTITY) && !is_string($iDENTITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTITY)), __LINE__);
        }
        if (is_null($iDENTITY) || (is_array($iDENTITY) && empty($iDENTITY))) {
            unset($this->IDENTITY);
        } else {
            $this->IDENTITY = $iDENTITY;
        }
        return $this;
    }
    /**
     * Get PARTY_TYPE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARTY_TYPE_DB()
    {
        return isset($this->PARTY_TYPE_DB) ? $this->PARTY_TYPE_DB : null;
    }
    /**
     * Set PARTY_TYPE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARTY_TYPE_DB
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setPARTY_TYPE_DB($pARTY_TYPE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pARTY_TYPE_DB) && !is_string($pARTY_TYPE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARTY_TYPE_DB)), __LINE__);
        }
        if (is_null($pARTY_TYPE_DB) || (is_array($pARTY_TYPE_DB) && empty($pARTY_TYPE_DB))) {
            unset($this->PARTY_TYPE_DB);
        } else {
            $this->PARTY_TYPE_DB = $pARTY_TYPE_DB;
        }
        return $this;
    }
    /**
     * Get PRIORITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPRIORITY()
    {
        return isset($this->PRIORITY) ? $this->PRIORITY : null;
    }
    /**
     * Set PRIORITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pRIORITY
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setPRIORITY($pRIORITY = null)
    {
        if (is_null($pRIORITY) || (is_array($pRIORITY) && empty($pRIORITY))) {
            unset($this->PRIORITY);
        } else {
            $this->PRIORITY = $pRIORITY;
        }
        return $this;
    }
    /**
     * Get BLOCKED_FOR_PAYMENT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBLOCKED_FOR_PAYMENT()
    {
        return isset($this->BLOCKED_FOR_PAYMENT) ? $this->BLOCKED_FOR_PAYMENT : null;
    }
    /**
     * Set BLOCKED_FOR_PAYMENT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bLOCKED_FOR_PAYMENT
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setBLOCKED_FOR_PAYMENT($bLOCKED_FOR_PAYMENT = null)
    {
        // validation for constraint: string
        if (!is_null($bLOCKED_FOR_PAYMENT) && !is_string($bLOCKED_FOR_PAYMENT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bLOCKED_FOR_PAYMENT)), __LINE__);
        }
        if (is_null($bLOCKED_FOR_PAYMENT) || (is_array($bLOCKED_FOR_PAYMENT) && empty($bLOCKED_FOR_PAYMENT))) {
            unset($this->BLOCKED_FOR_PAYMENT);
        } else {
            $this->BLOCKED_FOR_PAYMENT = $bLOCKED_FOR_PAYMENT;
        }
        return $this;
    }
    /**
     * Get OTHER_PAYEE_IDENTITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOTHER_PAYEE_IDENTITY()
    {
        return isset($this->OTHER_PAYEE_IDENTITY) ? $this->OTHER_PAYEE_IDENTITY : null;
    }
    /**
     * Set OTHER_PAYEE_IDENTITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oTHER_PAYEE_IDENTITY
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setOTHER_PAYEE_IDENTITY($oTHER_PAYEE_IDENTITY = null)
    {
        // validation for constraint: string
        if (!is_null($oTHER_PAYEE_IDENTITY) && !is_string($oTHER_PAYEE_IDENTITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oTHER_PAYEE_IDENTITY)), __LINE__);
        }
        if (is_null($oTHER_PAYEE_IDENTITY) || (is_array($oTHER_PAYEE_IDENTITY) && empty($oTHER_PAYEE_IDENTITY))) {
            unset($this->OTHER_PAYEE_IDENTITY);
        } else {
            $this->OTHER_PAYEE_IDENTITY = $oTHER_PAYEE_IDENTITY;
        }
        return $this;
    }
    /**
     * Get INTEREST_TEMPLATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINTEREST_TEMPLATE()
    {
        return isset($this->INTEREST_TEMPLATE) ? $this->INTEREST_TEMPLATE : null;
    }
    /**
     * Set INTEREST_TEMPLATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNTEREST_TEMPLATE
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setINTEREST_TEMPLATE($iNTEREST_TEMPLATE = null)
    {
        // validation for constraint: string
        if (!is_null($iNTEREST_TEMPLATE) && !is_string($iNTEREST_TEMPLATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNTEREST_TEMPLATE)), __LINE__);
        }
        if (is_null($iNTEREST_TEMPLATE) || (is_array($iNTEREST_TEMPLATE) && empty($iNTEREST_TEMPLATE))) {
            unset($this->INTEREST_TEMPLATE);
        } else {
            $this->INTEREST_TEMPLATE = $iNTEREST_TEMPLATE;
        }
        return $this;
    }
    /**
     * Get REMINDER_TEMPLATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getREMINDER_TEMPLATE()
    {
        return isset($this->REMINDER_TEMPLATE) ? $this->REMINDER_TEMPLATE : null;
    }
    /**
     * Set REMINDER_TEMPLATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rEMINDER_TEMPLATE
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setREMINDER_TEMPLATE($rEMINDER_TEMPLATE = null)
    {
        // validation for constraint: string
        if (!is_null($rEMINDER_TEMPLATE) && !is_string($rEMINDER_TEMPLATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rEMINDER_TEMPLATE)), __LINE__);
        }
        if (is_null($rEMINDER_TEMPLATE) || (is_array($rEMINDER_TEMPLATE) && empty($rEMINDER_TEMPLATE))) {
            unset($this->REMINDER_TEMPLATE);
        } else {
            $this->REMINDER_TEMPLATE = $rEMINDER_TEMPLATE;
        }
        return $this;
    }
    /**
     * Get PAYMENT_DELAY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPAYMENT_DELAY()
    {
        return isset($this->PAYMENT_DELAY) ? $this->PAYMENT_DELAY : null;
    }
    /**
     * Set PAYMENT_DELAY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pAYMENT_DELAY
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setPAYMENT_DELAY($pAYMENT_DELAY = null)
    {
        if (is_null($pAYMENT_DELAY) || (is_array($pAYMENT_DELAY) && empty($pAYMENT_DELAY))) {
            unset($this->PAYMENT_DELAY);
        } else {
            $this->PAYMENT_DELAY = $pAYMENT_DELAY;
        }
        return $this;
    }
    /**
     * Get AMOUNT_TOLERANCE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAMOUNT_TOLERANCE()
    {
        return isset($this->AMOUNT_TOLERANCE) ? $this->AMOUNT_TOLERANCE : null;
    }
    /**
     * Set AMOUNT_TOLERANCE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aMOUNT_TOLERANCE
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setAMOUNT_TOLERANCE($aMOUNT_TOLERANCE = null)
    {
        if (is_null($aMOUNT_TOLERANCE) || (is_array($aMOUNT_TOLERANCE) && empty($aMOUNT_TOLERANCE))) {
            unset($this->AMOUNT_TOLERANCE);
        } else {
            $this->AMOUNT_TOLERANCE = $aMOUNT_TOLERANCE;
        }
        return $this;
    }
    /**
     * Get PERCENT_TOLERANCE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPERCENT_TOLERANCE()
    {
        return isset($this->PERCENT_TOLERANCE) ? $this->PERCENT_TOLERANCE : null;
    }
    /**
     * Set PERCENT_TOLERANCE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pERCENT_TOLERANCE
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setPERCENT_TOLERANCE($pERCENT_TOLERANCE = null)
    {
        if (is_null($pERCENT_TOLERANCE) || (is_array($pERCENT_TOLERANCE) && empty($pERCENT_TOLERANCE))) {
            unset($this->PERCENT_TOLERANCE);
        } else {
            $this->PERCENT_TOLERANCE = $pERCENT_TOLERANCE;
        }
        return $this;
    }
    /**
     * Get DISC_DAYS_TOLERANCE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDISC_DAYS_TOLERANCE()
    {
        return isset($this->DISC_DAYS_TOLERANCE) ? $this->DISC_DAYS_TOLERANCE : null;
    }
    /**
     * Set DISC_DAYS_TOLERANCE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dISC_DAYS_TOLERANCE
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setDISC_DAYS_TOLERANCE($dISC_DAYS_TOLERANCE = null)
    {
        if (is_null($dISC_DAYS_TOLERANCE) || (is_array($dISC_DAYS_TOLERANCE) && empty($dISC_DAYS_TOLERANCE))) {
            unset($this->DISC_DAYS_TOLERANCE);
        } else {
            $this->DISC_DAYS_TOLERANCE = $dISC_DAYS_TOLERANCE;
        }
        return $this;
    }
    /**
     * Get NETTING_ALLOWED value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNETTING_ALLOWED()
    {
        return isset($this->NETTING_ALLOWED) ? $this->NETTING_ALLOWED : null;
    }
    /**
     * Set NETTING_ALLOWED value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nETTING_ALLOWED
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setNETTING_ALLOWED($nETTING_ALLOWED = null)
    {
        // validation for constraint: string
        if (!is_null($nETTING_ALLOWED) && !is_string($nETTING_ALLOWED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nETTING_ALLOWED)), __LINE__);
        }
        if (is_null($nETTING_ALLOWED) || (is_array($nETTING_ALLOWED) && empty($nETTING_ALLOWED))) {
            unset($this->NETTING_ALLOWED);
        } else {
            $this->NETTING_ALLOWED = $nETTING_ALLOWED;
        }
        return $this;
    }
    /**
     * Get FORMAT_NO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFORMAT_NO()
    {
        return isset($this->FORMAT_NO) ? $this->FORMAT_NO : null;
    }
    /**
     * Set FORMAT_NO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fORMAT_NO
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setFORMAT_NO($fORMAT_NO = null)
    {
        if (is_null($fORMAT_NO) || (is_array($fORMAT_NO) && empty($fORMAT_NO))) {
            unset($this->FORMAT_NO);
        } else {
            $this->FORMAT_NO = $fORMAT_NO;
        }
        return $this;
    }
    /**
     * Get PAYMENT_ADVICE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPAYMENT_ADVICE_DB()
    {
        return isset($this->PAYMENT_ADVICE_DB) ? $this->PAYMENT_ADVICE_DB : null;
    }
    /**
     * Set PAYMENT_ADVICE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pAYMENT_ADVICE_DB
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setPAYMENT_ADVICE_DB($pAYMENT_ADVICE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pAYMENT_ADVICE_DB) && !is_string($pAYMENT_ADVICE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pAYMENT_ADVICE_DB)), __LINE__);
        }
        if (is_null($pAYMENT_ADVICE_DB) || (is_array($pAYMENT_ADVICE_DB) && empty($pAYMENT_ADVICE_DB))) {
            unset($this->PAYMENT_ADVICE_DB);
        } else {
            $this->PAYMENT_ADVICE_DB = $pAYMENT_ADVICE_DB;
        }
        return $this;
    }
    /**
     * Get DEDUCTION_GROUP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEDUCTION_GROUP()
    {
        return isset($this->DEDUCTION_GROUP) ? $this->DEDUCTION_GROUP : null;
    }
    /**
     * Set DEDUCTION_GROUP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEDUCTION_GROUP
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setDEDUCTION_GROUP($dEDUCTION_GROUP = null)
    {
        // validation for constraint: string
        if (!is_null($dEDUCTION_GROUP) && !is_string($dEDUCTION_GROUP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEDUCTION_GROUP)), __LINE__);
        }
        if (is_null($dEDUCTION_GROUP) || (is_array($dEDUCTION_GROUP) && empty($dEDUCTION_GROUP))) {
            unset($this->DEDUCTION_GROUP);
        } else {
            $this->DEDUCTION_GROUP = $dEDUCTION_GROUP;
        }
        return $this;
    }
    /**
     * Get CORPORATION_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCORPORATION_ID()
    {
        return isset($this->CORPORATION_ID) ? $this->CORPORATION_ID : null;
    }
    /**
     * Set CORPORATION_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cORPORATION_ID
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setCORPORATION_ID($cORPORATION_ID = null)
    {
        // validation for constraint: string
        if (!is_null($cORPORATION_ID) && !is_string($cORPORATION_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cORPORATION_ID)), __LINE__);
        }
        if (is_null($cORPORATION_ID) || (is_array($cORPORATION_ID) && empty($cORPORATION_ID))) {
            unset($this->CORPORATION_ID);
        } else {
            $this->CORPORATION_ID = $cORPORATION_ID;
        }
        return $this;
    }
    /**
     * Get MEMBER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMEMBER_ID()
    {
        return isset($this->MEMBER_ID) ? $this->MEMBER_ID : null;
    }
    /**
     * Set MEMBER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mEMBER_ID
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setMEMBER_ID($mEMBER_ID = null)
    {
        // validation for constraint: string
        if (!is_null($mEMBER_ID) && !is_string($mEMBER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mEMBER_ID)), __LINE__);
        }
        if (is_null($mEMBER_ID) || (is_array($mEMBER_ID) && empty($mEMBER_ID))) {
            unset($this->MEMBER_ID);
        } else {
            $this->MEMBER_ID = $mEMBER_ID;
        }
        return $this;
    }
    /**
     * Get SEND_REMINDER_TO_PAYER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSEND_REMINDER_TO_PAYER()
    {
        return isset($this->SEND_REMINDER_TO_PAYER) ? $this->SEND_REMINDER_TO_PAYER : null;
    }
    /**
     * Set SEND_REMINDER_TO_PAYER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sEND_REMINDER_TO_PAYER
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setSEND_REMINDER_TO_PAYER($sEND_REMINDER_TO_PAYER = null)
    {
        // validation for constraint: string
        if (!is_null($sEND_REMINDER_TO_PAYER) && !is_string($sEND_REMINDER_TO_PAYER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sEND_REMINDER_TO_PAYER)), __LINE__);
        }
        if (is_null($sEND_REMINDER_TO_PAYER) || (is_array($sEND_REMINDER_TO_PAYER) && empty($sEND_REMINDER_TO_PAYER))) {
            unset($this->SEND_REMINDER_TO_PAYER);
        } else {
            $this->SEND_REMINDER_TO_PAYER = $sEND_REMINDER_TO_PAYER;
        }
        return $this;
    }
    /**
     * Get SEND_INTEREST_INV_TO_PAYER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSEND_INTEREST_INV_TO_PAYER()
    {
        return isset($this->SEND_INTEREST_INV_TO_PAYER) ? $this->SEND_INTEREST_INV_TO_PAYER : null;
    }
    /**
     * Set SEND_INTEREST_INV_TO_PAYER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sEND_INTEREST_INV_TO_PAYER
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setSEND_INTEREST_INV_TO_PAYER($sEND_INTEREST_INV_TO_PAYER = null)
    {
        // validation for constraint: string
        if (!is_null($sEND_INTEREST_INV_TO_PAYER) && !is_string($sEND_INTEREST_INV_TO_PAYER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sEND_INTEREST_INV_TO_PAYER)), __LINE__);
        }
        if (is_null($sEND_INTEREST_INV_TO_PAYER) || (is_array($sEND_INTEREST_INV_TO_PAYER) && empty($sEND_INTEREST_INV_TO_PAYER))) {
            unset($this->SEND_INTEREST_INV_TO_PAYER);
        } else {
            $this->SEND_INTEREST_INV_TO_PAYER = $sEND_INTEREST_INV_TO_PAYER;
        }
        return $this;
    }
    /**
     * Get RULE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRULE_ID()
    {
        return isset($this->RULE_ID) ? $this->RULE_ID : null;
    }
    /**
     * Set RULE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rULE_ID
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setRULE_ID($rULE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($rULE_ID) && !is_string($rULE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rULE_ID)), __LINE__);
        }
        if (is_null($rULE_ID) || (is_array($rULE_ID) && empty($rULE_ID))) {
            unset($this->RULE_ID);
        } else {
            $this->RULE_ID = $rULE_ID;
        }
        return $this;
    }
    /**
     * Get PAYMENT_RECEIPT_TYPE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPAYMENT_RECEIPT_TYPE_DB()
    {
        return isset($this->PAYMENT_RECEIPT_TYPE_DB) ? $this->PAYMENT_RECEIPT_TYPE_DB : null;
    }
    /**
     * Set PAYMENT_RECEIPT_TYPE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pAYMENT_RECEIPT_TYPE_DB
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setPAYMENT_RECEIPT_TYPE_DB($pAYMENT_RECEIPT_TYPE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pAYMENT_RECEIPT_TYPE_DB) && !is_string($pAYMENT_RECEIPT_TYPE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pAYMENT_RECEIPT_TYPE_DB)), __LINE__);
        }
        if (is_null($pAYMENT_RECEIPT_TYPE_DB) || (is_array($pAYMENT_RECEIPT_TYPE_DB) && empty($pAYMENT_RECEIPT_TYPE_DB))) {
            unset($this->PAYMENT_RECEIPT_TYPE_DB);
        } else {
            $this->PAYMENT_RECEIPT_TYPE_DB = $pAYMENT_RECEIPT_TYPE_DB;
        }
        return $this;
    }
    /**
     * Get TEMPLATE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTEMPLATE_ID()
    {
        return isset($this->TEMPLATE_ID) ? $this->TEMPLATE_ID : null;
    }
    /**
     * Set TEMPLATE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tEMPLATE_ID
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setTEMPLATE_ID($tEMPLATE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($tEMPLATE_ID) && !is_string($tEMPLATE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tEMPLATE_ID)), __LINE__);
        }
        if (is_null($tEMPLATE_ID) || (is_array($tEMPLATE_ID) && empty($tEMPLATE_ID))) {
            unset($this->TEMPLATE_ID);
        } else {
            $this->TEMPLATE_ID = $tEMPLATE_ID;
        }
        return $this;
    }
    /**
     * Get CHECK_RECIPIENT_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCHECK_RECIPIENT_DB()
    {
        return isset($this->CHECK_RECIPIENT_DB) ? $this->CHECK_RECIPIENT_DB : null;
    }
    /**
     * Set CHECK_RECIPIENT_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cHECK_RECIPIENT_DB
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setCHECK_RECIPIENT_DB($cHECK_RECIPIENT_DB = null)
    {
        // validation for constraint: string
        if (!is_null($cHECK_RECIPIENT_DB) && !is_string($cHECK_RECIPIENT_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cHECK_RECIPIENT_DB)), __LINE__);
        }
        if (is_null($cHECK_RECIPIENT_DB) || (is_array($cHECK_RECIPIENT_DB) && empty($cHECK_RECIPIENT_DB))) {
            unset($this->CHECK_RECIPIENT_DB);
        } else {
            $this->CHECK_RECIPIENT_DB = $cHECK_RECIPIENT_DB;
        }
        return $this;
    }
    /**
     * Get SEND_STMT_OF_ACC_TO_PAYER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSEND_STMT_OF_ACC_TO_PAYER()
    {
        return isset($this->SEND_STMT_OF_ACC_TO_PAYER) ? $this->SEND_STMT_OF_ACC_TO_PAYER : null;
    }
    /**
     * Set SEND_STMT_OF_ACC_TO_PAYER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sEND_STMT_OF_ACC_TO_PAYER
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setSEND_STMT_OF_ACC_TO_PAYER($sEND_STMT_OF_ACC_TO_PAYER = null)
    {
        // validation for constraint: string
        if (!is_null($sEND_STMT_OF_ACC_TO_PAYER) && !is_string($sEND_STMT_OF_ACC_TO_PAYER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sEND_STMT_OF_ACC_TO_PAYER)), __LINE__);
        }
        if (is_null($sEND_STMT_OF_ACC_TO_PAYER) || (is_array($sEND_STMT_OF_ACC_TO_PAYER) && empty($sEND_STMT_OF_ACC_TO_PAYER))) {
            unset($this->SEND_STMT_OF_ACC_TO_PAYER);
        } else {
            $this->SEND_STMT_OF_ACC_TO_PAYER = $sEND_STMT_OF_ACC_TO_PAYER;
        }
        return $this;
    }
    /**
     * Get AR_CONTACT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAR_CONTACT()
    {
        return isset($this->AR_CONTACT) ? $this->AR_CONTACT : null;
    }
    /**
     * Set AR_CONTACT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aR_CONTACT
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setAR_CONTACT($aR_CONTACT = null)
    {
        // validation for constraint: string
        if (!is_null($aR_CONTACT) && !is_string($aR_CONTACT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aR_CONTACT)), __LINE__);
        }
        if (is_null($aR_CONTACT) || (is_array($aR_CONTACT) && empty($aR_CONTACT))) {
            unset($this->AR_CONTACT);
        } else {
            $this->AR_CONTACT = $aR_CONTACT;
        }
        return $this;
    }
    /**
     * Get COMM_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCOMM_ID()
    {
        return isset($this->COMM_ID) ? $this->COMM_ID : null;
    }
    /**
     * Set COMM_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cOMM_ID
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setCOMM_ID($cOMM_ID = null)
    {
        if (is_null($cOMM_ID) || (is_array($cOMM_ID) && empty($cOMM_ID))) {
            unset($this->COMM_ID);
        } else {
            $this->COMM_ID = $cOMM_ID;
        }
        return $this;
    }
    /**
     * Get OUTPUT_MEDIA_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOUTPUT_MEDIA_DB()
    {
        return isset($this->OUTPUT_MEDIA_DB) ? $this->OUTPUT_MEDIA_DB : null;
    }
    /**
     * Set OUTPUT_MEDIA_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oUTPUT_MEDIA_DB
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setOUTPUT_MEDIA_DB($oUTPUT_MEDIA_DB = null)
    {
        // validation for constraint: string
        if (!is_null($oUTPUT_MEDIA_DB) && !is_string($oUTPUT_MEDIA_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oUTPUT_MEDIA_DB)), __LINE__);
        }
        if (is_null($oUTPUT_MEDIA_DB) || (is_array($oUTPUT_MEDIA_DB) && empty($oUTPUT_MEDIA_DB))) {
            unset($this->OUTPUT_MEDIA_DB);
        } else {
            $this->OUTPUT_MEDIA_DB = $oUTPUT_MEDIA_DB;
        }
        return $this;
    }
    /**
     * Get DEFAULT_PAYMENT_METHOD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEFAULT_PAYMENT_METHOD()
    {
        return isset($this->DEFAULT_PAYMENT_METHOD) ? $this->DEFAULT_PAYMENT_METHOD : null;
    }
    /**
     * Set DEFAULT_PAYMENT_METHOD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEFAULT_PAYMENT_METHOD
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setDEFAULT_PAYMENT_METHOD($dEFAULT_PAYMENT_METHOD = null)
    {
        // validation for constraint: string
        if (!is_null($dEFAULT_PAYMENT_METHOD) && !is_string($dEFAULT_PAYMENT_METHOD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEFAULT_PAYMENT_METHOD)), __LINE__);
        }
        if (is_null($dEFAULT_PAYMENT_METHOD) || (is_array($dEFAULT_PAYMENT_METHOD) && empty($dEFAULT_PAYMENT_METHOD))) {
            unset($this->DEFAULT_PAYMENT_METHOD);
        } else {
            $this->DEFAULT_PAYMENT_METHOD = $dEFAULT_PAYMENT_METHOD;
        }
        return $this;
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get SUPPLIER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPPLIER_ID()
    {
        return isset($this->SUPPLIER_ID) ? $this->SUPPLIER_ID : null;
    }
    /**
     * Set SUPPLIER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPPLIER_ID
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setSUPPLIER_ID($sUPPLIER_ID = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLIER_ID) && !is_string($sUPPLIER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPPLIER_ID)), __LINE__);
        }
        if (is_null($sUPPLIER_ID) || (is_array($sUPPLIER_ID) && empty($sUPPLIER_ID))) {
            unset($this->SUPPLIER_ID);
        } else {
            $this->SUPPLIER_ID = $sUPPLIER_ID;
        }
        return $this;
    }
    /**
     * Get NEXT_PAYMENT_MATCHING_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNEXT_PAYMENT_MATCHING_ID()
    {
        return isset($this->NEXT_PAYMENT_MATCHING_ID) ? $this->NEXT_PAYMENT_MATCHING_ID : null;
    }
    /**
     * Set NEXT_PAYMENT_MATCHING_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $nEXT_PAYMENT_MATCHING_ID
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setNEXT_PAYMENT_MATCHING_ID($nEXT_PAYMENT_MATCHING_ID = null)
    {
        if (is_null($nEXT_PAYMENT_MATCHING_ID) || (is_array($nEXT_PAYMENT_MATCHING_ID) && empty($nEXT_PAYMENT_MATCHING_ID))) {
            unset($this->NEXT_PAYMENT_MATCHING_ID);
        } else {
            $this->NEXT_PAYMENT_MATCHING_ID = $nEXT_PAYMENT_MATCHING_ID;
        }
        return $this;
    }
    /**
     * Get IS_ONE_INV_PER_PAY_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIS_ONE_INV_PER_PAY_DB()
    {
        return isset($this->IS_ONE_INV_PER_PAY_DB) ? $this->IS_ONE_INV_PER_PAY_DB : null;
    }
    /**
     * Set IS_ONE_INV_PER_PAY_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iS_ONE_INV_PER_PAY_DB
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setIS_ONE_INV_PER_PAY_DB($iS_ONE_INV_PER_PAY_DB = null)
    {
        // validation for constraint: string
        if (!is_null($iS_ONE_INV_PER_PAY_DB) && !is_string($iS_ONE_INV_PER_PAY_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iS_ONE_INV_PER_PAY_DB)), __LINE__);
        }
        if (is_null($iS_ONE_INV_PER_PAY_DB) || (is_array($iS_ONE_INV_PER_PAY_DB) && empty($iS_ONE_INV_PER_PAY_DB))) {
            unset($this->IS_ONE_INV_PER_PAY_DB);
        } else {
            $this->IS_ONE_INV_PER_PAY_DB = $iS_ONE_INV_PER_PAY_DB;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Get PAYMENT_WAYS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PAYMENT_WAYS|null
     */
    public function getPAYMENT_WAYS()
    {
        return isset($this->PAYMENT_WAYS) ? $this->PAYMENT_WAYS : null;
    }
    /**
     * Set PAYMENT_WAYS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PAYMENT_WAYS $pAYMENT_WAYS
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public function setPAYMENT_WAYS(\StructType\PAYMENT_WAYS $pAYMENT_WAYS = null)
    {
        if (is_null($pAYMENT_WAYS) || (is_array($pAYMENT_WAYS) && empty($pAYMENT_WAYS))) {
            unset($this->PAYMENT_WAYS);
        } else {
            $this->PAYMENT_WAYS = $pAYMENT_WAYS;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IDENTITY_PAY_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
