<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CUSTOMER_TAX_INFO StructType
 * @subpackage Structs
 */
class CUSTOMER_TAX_INFO extends AbstractStructBase
{
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The ADDRESS_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ADDRESS_ID;
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The TAX_REGIME_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_REGIME_DB;
    /**
     * The TAX_WITHHOLDING_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_WITHHOLDING_DB;
    /**
     * The TAX_ROUNDING_METHOD_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_ROUNDING_METHOD_DB;
    /**
     * The TAX_ROUNDING_LEVEL_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_ROUNDING_LEVEL_DB;
    /**
     * The WITHHOLDING_BASE_AMOUNT_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WITHHOLDING_BASE_AMOUNT_DB;
    /**
     * The TAX_EXEMPT_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_EXEMPT_DB;
    /**
     * The TAX_EXEMPT_VALID_FROM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_EXEMPT_VALID_FROM;
    /**
     * The TAX_EXEMPT_VALID_TO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_EXEMPT_VALID_TO;
    /**
     * The TAX_OFFICE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_OFFICE_ID;
    /**
     * The RATE_DATE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RATE_DATE_DB;
    /**
     * The TAX_RATE_DATE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_RATE_DATE_DB;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * The DELIVERY_SUPPLY_COUNTRIES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DELIVERY_SUPPLY_COUNTRIES
     */
    public $DELIVERY_SUPPLY_COUNTRIES;
    /**
     * Constructor method for CUSTOMER_TAX_INFO
     * @uses CUSTOMER_TAX_INFO::setCUSTOMER_ID()
     * @uses CUSTOMER_TAX_INFO::setADDRESS_ID()
     * @uses CUSTOMER_TAX_INFO::setCOMPANY()
     * @uses CUSTOMER_TAX_INFO::setTAX_REGIME_DB()
     * @uses CUSTOMER_TAX_INFO::setTAX_WITHHOLDING_DB()
     * @uses CUSTOMER_TAX_INFO::setTAX_ROUNDING_METHOD_DB()
     * @uses CUSTOMER_TAX_INFO::setTAX_ROUNDING_LEVEL_DB()
     * @uses CUSTOMER_TAX_INFO::setWITHHOLDING_BASE_AMOUNT_DB()
     * @uses CUSTOMER_TAX_INFO::setTAX_EXEMPT_DB()
     * @uses CUSTOMER_TAX_INFO::setTAX_EXEMPT_VALID_FROM()
     * @uses CUSTOMER_TAX_INFO::setTAX_EXEMPT_VALID_TO()
     * @uses CUSTOMER_TAX_INFO::setTAX_OFFICE_ID()
     * @uses CUSTOMER_TAX_INFO::setRATE_DATE_DB()
     * @uses CUSTOMER_TAX_INFO::setTAX_RATE_DATE_DB()
     * @uses CUSTOMER_TAX_INFO::setOPERATION()
     * @uses CUSTOMER_TAX_INFO::setDELIVERY_SUPPLY_COUNTRIES()
     * @param string $cUSTOMER_ID
     * @param string $aDDRESS_ID
     * @param string $cOMPANY
     * @param string $tAX_REGIME_DB
     * @param string $tAX_WITHHOLDING_DB
     * @param string $tAX_ROUNDING_METHOD_DB
     * @param string $tAX_ROUNDING_LEVEL_DB
     * @param string $wITHHOLDING_BASE_AMOUNT_DB
     * @param string $tAX_EXEMPT_DB
     * @param string $tAX_EXEMPT_VALID_FROM
     * @param string $tAX_EXEMPT_VALID_TO
     * @param string $tAX_OFFICE_ID
     * @param string $rATE_DATE_DB
     * @param string $tAX_RATE_DATE_DB
     * @param string $oPERATION
     * @param \StructType\DELIVERY_SUPPLY_COUNTRIES $dELIVERY_SUPPLY_COUNTRIES
     */
    public function __construct($cUSTOMER_ID = null, $aDDRESS_ID = null, $cOMPANY = null, $tAX_REGIME_DB = null, $tAX_WITHHOLDING_DB = null, $tAX_ROUNDING_METHOD_DB = null, $tAX_ROUNDING_LEVEL_DB = null, $wITHHOLDING_BASE_AMOUNT_DB = null, $tAX_EXEMPT_DB = null, $tAX_EXEMPT_VALID_FROM = null, $tAX_EXEMPT_VALID_TO = null, $tAX_OFFICE_ID = null, $rATE_DATE_DB = null, $tAX_RATE_DATE_DB = null, $oPERATION = null, \StructType\DELIVERY_SUPPLY_COUNTRIES $dELIVERY_SUPPLY_COUNTRIES = null)
    {
        $this
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setADDRESS_ID($aDDRESS_ID)
            ->setCOMPANY($cOMPANY)
            ->setTAX_REGIME_DB($tAX_REGIME_DB)
            ->setTAX_WITHHOLDING_DB($tAX_WITHHOLDING_DB)
            ->setTAX_ROUNDING_METHOD_DB($tAX_ROUNDING_METHOD_DB)
            ->setTAX_ROUNDING_LEVEL_DB($tAX_ROUNDING_LEVEL_DB)
            ->setWITHHOLDING_BASE_AMOUNT_DB($wITHHOLDING_BASE_AMOUNT_DB)
            ->setTAX_EXEMPT_DB($tAX_EXEMPT_DB)
            ->setTAX_EXEMPT_VALID_FROM($tAX_EXEMPT_VALID_FROM)
            ->setTAX_EXEMPT_VALID_TO($tAX_EXEMPT_VALID_TO)
            ->setTAX_OFFICE_ID($tAX_OFFICE_ID)
            ->setRATE_DATE_DB($rATE_DATE_DB)
            ->setTAX_RATE_DATE_DB($tAX_RATE_DATE_DB)
            ->setOPERATION($oPERATION)
            ->setDELIVERY_SUPPLY_COUNTRIES($dELIVERY_SUPPLY_COUNTRIES);
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get ADDRESS_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getADDRESS_ID()
    {
        return isset($this->ADDRESS_ID) ? $this->ADDRESS_ID : null;
    }
    /**
     * Set ADDRESS_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aDDRESS_ID
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setADDRESS_ID($aDDRESS_ID = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS_ID) && !is_string($aDDRESS_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS_ID)), __LINE__);
        }
        if (is_null($aDDRESS_ID) || (is_array($aDDRESS_ID) && empty($aDDRESS_ID))) {
            unset($this->ADDRESS_ID);
        } else {
            $this->ADDRESS_ID = $aDDRESS_ID;
        }
        return $this;
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get TAX_REGIME_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_REGIME_DB()
    {
        return isset($this->TAX_REGIME_DB) ? $this->TAX_REGIME_DB : null;
    }
    /**
     * Set TAX_REGIME_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_REGIME_DB
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_REGIME_DB($tAX_REGIME_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_REGIME_DB) && !is_string($tAX_REGIME_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_REGIME_DB)), __LINE__);
        }
        if (is_null($tAX_REGIME_DB) || (is_array($tAX_REGIME_DB) && empty($tAX_REGIME_DB))) {
            unset($this->TAX_REGIME_DB);
        } else {
            $this->TAX_REGIME_DB = $tAX_REGIME_DB;
        }
        return $this;
    }
    /**
     * Get TAX_WITHHOLDING_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_WITHHOLDING_DB()
    {
        return isset($this->TAX_WITHHOLDING_DB) ? $this->TAX_WITHHOLDING_DB : null;
    }
    /**
     * Set TAX_WITHHOLDING_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_WITHHOLDING_DB
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_WITHHOLDING_DB($tAX_WITHHOLDING_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_WITHHOLDING_DB) && !is_string($tAX_WITHHOLDING_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_WITHHOLDING_DB)), __LINE__);
        }
        if (is_null($tAX_WITHHOLDING_DB) || (is_array($tAX_WITHHOLDING_DB) && empty($tAX_WITHHOLDING_DB))) {
            unset($this->TAX_WITHHOLDING_DB);
        } else {
            $this->TAX_WITHHOLDING_DB = $tAX_WITHHOLDING_DB;
        }
        return $this;
    }
    /**
     * Get TAX_ROUNDING_METHOD_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_ROUNDING_METHOD_DB()
    {
        return isset($this->TAX_ROUNDING_METHOD_DB) ? $this->TAX_ROUNDING_METHOD_DB : null;
    }
    /**
     * Set TAX_ROUNDING_METHOD_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_ROUNDING_METHOD_DB
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_ROUNDING_METHOD_DB($tAX_ROUNDING_METHOD_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_ROUNDING_METHOD_DB) && !is_string($tAX_ROUNDING_METHOD_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_ROUNDING_METHOD_DB)), __LINE__);
        }
        if (is_null($tAX_ROUNDING_METHOD_DB) || (is_array($tAX_ROUNDING_METHOD_DB) && empty($tAX_ROUNDING_METHOD_DB))) {
            unset($this->TAX_ROUNDING_METHOD_DB);
        } else {
            $this->TAX_ROUNDING_METHOD_DB = $tAX_ROUNDING_METHOD_DB;
        }
        return $this;
    }
    /**
     * Get TAX_ROUNDING_LEVEL_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_ROUNDING_LEVEL_DB()
    {
        return isset($this->TAX_ROUNDING_LEVEL_DB) ? $this->TAX_ROUNDING_LEVEL_DB : null;
    }
    /**
     * Set TAX_ROUNDING_LEVEL_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_ROUNDING_LEVEL_DB
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_ROUNDING_LEVEL_DB($tAX_ROUNDING_LEVEL_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_ROUNDING_LEVEL_DB) && !is_string($tAX_ROUNDING_LEVEL_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_ROUNDING_LEVEL_DB)), __LINE__);
        }
        if (is_null($tAX_ROUNDING_LEVEL_DB) || (is_array($tAX_ROUNDING_LEVEL_DB) && empty($tAX_ROUNDING_LEVEL_DB))) {
            unset($this->TAX_ROUNDING_LEVEL_DB);
        } else {
            $this->TAX_ROUNDING_LEVEL_DB = $tAX_ROUNDING_LEVEL_DB;
        }
        return $this;
    }
    /**
     * Get WITHHOLDING_BASE_AMOUNT_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWITHHOLDING_BASE_AMOUNT_DB()
    {
        return isset($this->WITHHOLDING_BASE_AMOUNT_DB) ? $this->WITHHOLDING_BASE_AMOUNT_DB : null;
    }
    /**
     * Set WITHHOLDING_BASE_AMOUNT_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wITHHOLDING_BASE_AMOUNT_DB
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setWITHHOLDING_BASE_AMOUNT_DB($wITHHOLDING_BASE_AMOUNT_DB = null)
    {
        // validation for constraint: string
        if (!is_null($wITHHOLDING_BASE_AMOUNT_DB) && !is_string($wITHHOLDING_BASE_AMOUNT_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wITHHOLDING_BASE_AMOUNT_DB)), __LINE__);
        }
        if (is_null($wITHHOLDING_BASE_AMOUNT_DB) || (is_array($wITHHOLDING_BASE_AMOUNT_DB) && empty($wITHHOLDING_BASE_AMOUNT_DB))) {
            unset($this->WITHHOLDING_BASE_AMOUNT_DB);
        } else {
            $this->WITHHOLDING_BASE_AMOUNT_DB = $wITHHOLDING_BASE_AMOUNT_DB;
        }
        return $this;
    }
    /**
     * Get TAX_EXEMPT_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_EXEMPT_DB()
    {
        return isset($this->TAX_EXEMPT_DB) ? $this->TAX_EXEMPT_DB : null;
    }
    /**
     * Set TAX_EXEMPT_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_EXEMPT_DB
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_EXEMPT_DB($tAX_EXEMPT_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_EXEMPT_DB) && !is_string($tAX_EXEMPT_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_EXEMPT_DB)), __LINE__);
        }
        if (is_null($tAX_EXEMPT_DB) || (is_array($tAX_EXEMPT_DB) && empty($tAX_EXEMPT_DB))) {
            unset($this->TAX_EXEMPT_DB);
        } else {
            $this->TAX_EXEMPT_DB = $tAX_EXEMPT_DB;
        }
        return $this;
    }
    /**
     * Get TAX_EXEMPT_VALID_FROM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_EXEMPT_VALID_FROM()
    {
        return isset($this->TAX_EXEMPT_VALID_FROM) ? $this->TAX_EXEMPT_VALID_FROM : null;
    }
    /**
     * Set TAX_EXEMPT_VALID_FROM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_EXEMPT_VALID_FROM
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_EXEMPT_VALID_FROM($tAX_EXEMPT_VALID_FROM = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_EXEMPT_VALID_FROM) && !is_string($tAX_EXEMPT_VALID_FROM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_EXEMPT_VALID_FROM)), __LINE__);
        }
        if (is_null($tAX_EXEMPT_VALID_FROM) || (is_array($tAX_EXEMPT_VALID_FROM) && empty($tAX_EXEMPT_VALID_FROM))) {
            unset($this->TAX_EXEMPT_VALID_FROM);
        } else {
            $this->TAX_EXEMPT_VALID_FROM = $tAX_EXEMPT_VALID_FROM;
        }
        return $this;
    }
    /**
     * Get TAX_EXEMPT_VALID_TO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_EXEMPT_VALID_TO()
    {
        return isset($this->TAX_EXEMPT_VALID_TO) ? $this->TAX_EXEMPT_VALID_TO : null;
    }
    /**
     * Set TAX_EXEMPT_VALID_TO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_EXEMPT_VALID_TO
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_EXEMPT_VALID_TO($tAX_EXEMPT_VALID_TO = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_EXEMPT_VALID_TO) && !is_string($tAX_EXEMPT_VALID_TO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_EXEMPT_VALID_TO)), __LINE__);
        }
        if (is_null($tAX_EXEMPT_VALID_TO) || (is_array($tAX_EXEMPT_VALID_TO) && empty($tAX_EXEMPT_VALID_TO))) {
            unset($this->TAX_EXEMPT_VALID_TO);
        } else {
            $this->TAX_EXEMPT_VALID_TO = $tAX_EXEMPT_VALID_TO;
        }
        return $this;
    }
    /**
     * Get TAX_OFFICE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_OFFICE_ID()
    {
        return isset($this->TAX_OFFICE_ID) ? $this->TAX_OFFICE_ID : null;
    }
    /**
     * Set TAX_OFFICE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_OFFICE_ID
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_OFFICE_ID($tAX_OFFICE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_OFFICE_ID) && !is_string($tAX_OFFICE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_OFFICE_ID)), __LINE__);
        }
        if (is_null($tAX_OFFICE_ID) || (is_array($tAX_OFFICE_ID) && empty($tAX_OFFICE_ID))) {
            unset($this->TAX_OFFICE_ID);
        } else {
            $this->TAX_OFFICE_ID = $tAX_OFFICE_ID;
        }
        return $this;
    }
    /**
     * Get RATE_DATE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRATE_DATE_DB()
    {
        return isset($this->RATE_DATE_DB) ? $this->RATE_DATE_DB : null;
    }
    /**
     * Set RATE_DATE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rATE_DATE_DB
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setRATE_DATE_DB($rATE_DATE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($rATE_DATE_DB) && !is_string($rATE_DATE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rATE_DATE_DB)), __LINE__);
        }
        if (is_null($rATE_DATE_DB) || (is_array($rATE_DATE_DB) && empty($rATE_DATE_DB))) {
            unset($this->RATE_DATE_DB);
        } else {
            $this->RATE_DATE_DB = $rATE_DATE_DB;
        }
        return $this;
    }
    /**
     * Get TAX_RATE_DATE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_RATE_DATE_DB()
    {
        return isset($this->TAX_RATE_DATE_DB) ? $this->TAX_RATE_DATE_DB : null;
    }
    /**
     * Set TAX_RATE_DATE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_RATE_DATE_DB
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setTAX_RATE_DATE_DB($tAX_RATE_DATE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_RATE_DATE_DB) && !is_string($tAX_RATE_DATE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_RATE_DATE_DB)), __LINE__);
        }
        if (is_null($tAX_RATE_DATE_DB) || (is_array($tAX_RATE_DATE_DB) && empty($tAX_RATE_DATE_DB))) {
            unset($this->TAX_RATE_DATE_DB);
        } else {
            $this->TAX_RATE_DATE_DB = $tAX_RATE_DATE_DB;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Get DELIVERY_SUPPLY_COUNTRIES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DELIVERY_SUPPLY_COUNTRIES|null
     */
    public function getDELIVERY_SUPPLY_COUNTRIES()
    {
        return isset($this->DELIVERY_SUPPLY_COUNTRIES) ? $this->DELIVERY_SUPPLY_COUNTRIES : null;
    }
    /**
     * Set DELIVERY_SUPPLY_COUNTRIES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DELIVERY_SUPPLY_COUNTRIES $dELIVERY_SUPPLY_COUNTRIES
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public function setDELIVERY_SUPPLY_COUNTRIES(\StructType\DELIVERY_SUPPLY_COUNTRIES $dELIVERY_SUPPLY_COUNTRIES = null)
    {
        if (is_null($dELIVERY_SUPPLY_COUNTRIES) || (is_array($dELIVERY_SUPPLY_COUNTRIES) && empty($dELIVERY_SUPPLY_COUNTRIES))) {
            unset($this->DELIVERY_SUPPLY_COUNTRIES);
        } else {
            $this->DELIVERY_SUPPLY_COUNTRIES = $dELIVERY_SUPPLY_COUNTRIES;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CUSTOMER_TAX_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
