<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CUSTOMER_INFO StructType
 * @subpackage Structs
 */
class CUSTOMER_INFO extends AbstractStructBase
{
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The NAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NAME;
    /**
     * The CREATION_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREATION_DATE;
    /**
     * The ASSOCIATION_NO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ASSOCIATION_NO;
    /**
     * The PARTY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARTY;
    /**
     * The DEFAULT_DOMAIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEFAULT_DOMAIN;
    /**
     * The DEFAULT_LANGUAGE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEFAULT_LANGUAGE_DB;
    /**
     * The COUNTRY_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $COUNTRY_DB;
    /**
     * The PARTY_TYPE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARTY_TYPE_DB;
    /**
     * The CORPORATE_FORM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CORPORATE_FORM;
    /**
     * The IDENTIFIER_REFERENCE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDENTIFIER_REFERENCE;
    /**
     * The IDENTIFIER_REF_VALIDATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDENTIFIER_REF_VALIDATION;
    /**
     * The IDENTIFIER_REF_VALIDATION_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDENTIFIER_REF_VALIDATION_DB;
    /**
     * The PICTURE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PICTURE_ID;
    /**
     * The ONE_TIME_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ONE_TIME_DB;
    /**
     * The CUSTOMER_CATEGORY_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CUSTOMER_CATEGORY_DB;
    /**
     * The C_APPROVED_CRM_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $C_APPROVED_CRM_DB;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * The ADDRESSES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ADDRESSES
     */
    public $ADDRESSES;
    /**
     * The CUSTOMER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CUSTOMER
     */
    public $CUSTOMER;
    /**
     * The CONTACTS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CONTACTS
     */
    public $CONTACTS;
    /**
     * The COMM_METHODS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\COMM_METHODS
     */
    public $COMM_METHODS;
    /**
     * The INVOICE_INFOS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\INVOICE_INFOS
     */
    public $INVOICE_INFOS;
    /**
     * The FARMS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FARMS
     */
    public $FARMS;
    /**
     * Constructor method for CUSTOMER_INFO
     * @uses CUSTOMER_INFO::setCUSTOMER_ID()
     * @uses CUSTOMER_INFO::setNAME()
     * @uses CUSTOMER_INFO::setCREATION_DATE()
     * @uses CUSTOMER_INFO::setASSOCIATION_NO()
     * @uses CUSTOMER_INFO::setPARTY()
     * @uses CUSTOMER_INFO::setDEFAULT_DOMAIN()
     * @uses CUSTOMER_INFO::setDEFAULT_LANGUAGE_DB()
     * @uses CUSTOMER_INFO::setCOUNTRY_DB()
     * @uses CUSTOMER_INFO::setPARTY_TYPE_DB()
     * @uses CUSTOMER_INFO::setCORPORATE_FORM()
     * @uses CUSTOMER_INFO::setIDENTIFIER_REFERENCE()
     * @uses CUSTOMER_INFO::setIDENTIFIER_REF_VALIDATION()
     * @uses CUSTOMER_INFO::setIDENTIFIER_REF_VALIDATION_DB()
     * @uses CUSTOMER_INFO::setPICTURE_ID()
     * @uses CUSTOMER_INFO::setONE_TIME_DB()
     * @uses CUSTOMER_INFO::setCUSTOMER_CATEGORY_DB()
     * @uses CUSTOMER_INFO::setC_APPROVED_CRM_DB()
     * @uses CUSTOMER_INFO::setOPERATION()
     * @uses CUSTOMER_INFO::setADDRESSES()
     * @uses CUSTOMER_INFO::setCUSTOMER()
     * @uses CUSTOMER_INFO::setCONTACTS()
     * @uses CUSTOMER_INFO::setCOMM_METHODS()
     * @uses CUSTOMER_INFO::setINVOICE_INFOS()
     * @uses CUSTOMER_INFO::setFARMS()
     * @param string $cUSTOMER_ID
     * @param string $nAME
     * @param string $cREATION_DATE
     * @param string $aSSOCIATION_NO
     * @param string $pARTY
     * @param string $dEFAULT_DOMAIN
     * @param string $dEFAULT_LANGUAGE_DB
     * @param string $cOUNTRY_DB
     * @param string $pARTY_TYPE_DB
     * @param string $cORPORATE_FORM
     * @param string $iDENTIFIER_REFERENCE
     * @param string $iDENTIFIER_REF_VALIDATION
     * @param string $iDENTIFIER_REF_VALIDATION_DB
     * @param float $pICTURE_ID
     * @param string $oNE_TIME_DB
     * @param string $cUSTOMER_CATEGORY_DB
     * @param string $c_APPROVED_CRM_DB
     * @param string $oPERATION
     * @param \StructType\ADDRESSES $aDDRESSES
     * @param \StructType\CUSTOMER $cUSTOMER
     * @param \StructType\CONTACTS $cONTACTS
     * @param \StructType\COMM_METHODS $cOMM_METHODS
     * @param \StructType\INVOICE_INFOS $iNVOICE_INFOS
     * @param \StructType\FARMS $fARMS
     */
    public function __construct($cUSTOMER_ID = null, $nAME = null, $cREATION_DATE = null, $aSSOCIATION_NO = null, $pARTY = null, $dEFAULT_DOMAIN = null, $dEFAULT_LANGUAGE_DB = null, $cOUNTRY_DB = null, $pARTY_TYPE_DB = null, $cORPORATE_FORM = null, $iDENTIFIER_REFERENCE = null, $iDENTIFIER_REF_VALIDATION = null, $iDENTIFIER_REF_VALIDATION_DB = null, $pICTURE_ID = null, $oNE_TIME_DB = null, $cUSTOMER_CATEGORY_DB = null, $c_APPROVED_CRM_DB = null, $oPERATION = null, \StructType\ADDRESSES $aDDRESSES = null, \StructType\CUSTOMER $cUSTOMER = null, \StructType\CONTACTS $cONTACTS = null, \StructType\COMM_METHODS $cOMM_METHODS = null, \StructType\INVOICE_INFOS $iNVOICE_INFOS = null, \StructType\FARMS $fARMS = null)
    {
        $this
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setNAME($nAME)
            ->setCREATION_DATE($cREATION_DATE)
            ->setASSOCIATION_NO($aSSOCIATION_NO)
            ->setPARTY($pARTY)
            ->setDEFAULT_DOMAIN($dEFAULT_DOMAIN)
            ->setDEFAULT_LANGUAGE_DB($dEFAULT_LANGUAGE_DB)
            ->setCOUNTRY_DB($cOUNTRY_DB)
            ->setPARTY_TYPE_DB($pARTY_TYPE_DB)
            ->setCORPORATE_FORM($cORPORATE_FORM)
            ->setIDENTIFIER_REFERENCE($iDENTIFIER_REFERENCE)
            ->setIDENTIFIER_REF_VALIDATION($iDENTIFIER_REF_VALIDATION)
            ->setIDENTIFIER_REF_VALIDATION_DB($iDENTIFIER_REF_VALIDATION_DB)
            ->setPICTURE_ID($pICTURE_ID)
            ->setONE_TIME_DB($oNE_TIME_DB)
            ->setCUSTOMER_CATEGORY_DB($cUSTOMER_CATEGORY_DB)
            ->setC_APPROVED_CRM_DB($c_APPROVED_CRM_DB)
            ->setOPERATION($oPERATION)
            ->setADDRESSES($aDDRESSES)
            ->setCUSTOMER($cUSTOMER)
            ->setCONTACTS($cONTACTS)
            ->setCOMM_METHODS($cOMM_METHODS)
            ->setINVOICE_INFOS($iNVOICE_INFOS)
            ->setFARMS($fARMS);
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\CUSTOMER_INFO
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get NAME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNAME()
    {
        return isset($this->NAME) ? $this->NAME : null;
    }
    /**
     * Set NAME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nAME
     * @return \StructType\CUSTOMER_INFO
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nAME)), __LINE__);
        }
        if (is_null($nAME) || (is_array($nAME) && empty($nAME))) {
            unset($this->NAME);
        } else {
            $this->NAME = $nAME;
        }
        return $this;
    }
    /**
     * Get CREATION_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREATION_DATE()
    {
        return isset($this->CREATION_DATE) ? $this->CREATION_DATE : null;
    }
    /**
     * Set CREATION_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREATION_DATE
     * @return \StructType\CUSTOMER_INFO
     */
    public function setCREATION_DATE($cREATION_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($cREATION_DATE) && !is_string($cREATION_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREATION_DATE)), __LINE__);
        }
        if (is_null($cREATION_DATE) || (is_array($cREATION_DATE) && empty($cREATION_DATE))) {
            unset($this->CREATION_DATE);
        } else {
            $this->CREATION_DATE = $cREATION_DATE;
        }
        return $this;
    }
    /**
     * Get ASSOCIATION_NO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getASSOCIATION_NO()
    {
        return isset($this->ASSOCIATION_NO) ? $this->ASSOCIATION_NO : null;
    }
    /**
     * Set ASSOCIATION_NO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aSSOCIATION_NO
     * @return \StructType\CUSTOMER_INFO
     */
    public function setASSOCIATION_NO($aSSOCIATION_NO = null)
    {
        // validation for constraint: string
        if (!is_null($aSSOCIATION_NO) && !is_string($aSSOCIATION_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aSSOCIATION_NO)), __LINE__);
        }
        if (is_null($aSSOCIATION_NO) || (is_array($aSSOCIATION_NO) && empty($aSSOCIATION_NO))) {
            unset($this->ASSOCIATION_NO);
        } else {
            $this->ASSOCIATION_NO = $aSSOCIATION_NO;
        }
        return $this;
    }
    /**
     * Get PARTY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARTY()
    {
        return isset($this->PARTY) ? $this->PARTY : null;
    }
    /**
     * Set PARTY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARTY
     * @return \StructType\CUSTOMER_INFO
     */
    public function setPARTY($pARTY = null)
    {
        // validation for constraint: string
        if (!is_null($pARTY) && !is_string($pARTY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARTY)), __LINE__);
        }
        if (is_null($pARTY) || (is_array($pARTY) && empty($pARTY))) {
            unset($this->PARTY);
        } else {
            $this->PARTY = $pARTY;
        }
        return $this;
    }
    /**
     * Get DEFAULT_DOMAIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEFAULT_DOMAIN()
    {
        return isset($this->DEFAULT_DOMAIN) ? $this->DEFAULT_DOMAIN : null;
    }
    /**
     * Set DEFAULT_DOMAIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEFAULT_DOMAIN
     * @return \StructType\CUSTOMER_INFO
     */
    public function setDEFAULT_DOMAIN($dEFAULT_DOMAIN = null)
    {
        // validation for constraint: string
        if (!is_null($dEFAULT_DOMAIN) && !is_string($dEFAULT_DOMAIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEFAULT_DOMAIN)), __LINE__);
        }
        if (is_null($dEFAULT_DOMAIN) || (is_array($dEFAULT_DOMAIN) && empty($dEFAULT_DOMAIN))) {
            unset($this->DEFAULT_DOMAIN);
        } else {
            $this->DEFAULT_DOMAIN = $dEFAULT_DOMAIN;
        }
        return $this;
    }
    /**
     * Get DEFAULT_LANGUAGE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEFAULT_LANGUAGE_DB()
    {
        return isset($this->DEFAULT_LANGUAGE_DB) ? $this->DEFAULT_LANGUAGE_DB : null;
    }
    /**
     * Set DEFAULT_LANGUAGE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEFAULT_LANGUAGE_DB
     * @return \StructType\CUSTOMER_INFO
     */
    public function setDEFAULT_LANGUAGE_DB($dEFAULT_LANGUAGE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($dEFAULT_LANGUAGE_DB) && !is_string($dEFAULT_LANGUAGE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEFAULT_LANGUAGE_DB)), __LINE__);
        }
        if (is_null($dEFAULT_LANGUAGE_DB) || (is_array($dEFAULT_LANGUAGE_DB) && empty($dEFAULT_LANGUAGE_DB))) {
            unset($this->DEFAULT_LANGUAGE_DB);
        } else {
            $this->DEFAULT_LANGUAGE_DB = $dEFAULT_LANGUAGE_DB;
        }
        return $this;
    }
    /**
     * Get COUNTRY_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOUNTRY_DB()
    {
        return isset($this->COUNTRY_DB) ? $this->COUNTRY_DB : null;
    }
    /**
     * Set COUNTRY_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOUNTRY_DB
     * @return \StructType\CUSTOMER_INFO
     */
    public function setCOUNTRY_DB($cOUNTRY_DB = null)
    {
        // validation for constraint: string
        if (!is_null($cOUNTRY_DB) && !is_string($cOUNTRY_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOUNTRY_DB)), __LINE__);
        }
        if (is_null($cOUNTRY_DB) || (is_array($cOUNTRY_DB) && empty($cOUNTRY_DB))) {
            unset($this->COUNTRY_DB);
        } else {
            $this->COUNTRY_DB = $cOUNTRY_DB;
        }
        return $this;
    }
    /**
     * Get PARTY_TYPE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARTY_TYPE_DB()
    {
        return isset($this->PARTY_TYPE_DB) ? $this->PARTY_TYPE_DB : null;
    }
    /**
     * Set PARTY_TYPE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARTY_TYPE_DB
     * @return \StructType\CUSTOMER_INFO
     */
    public function setPARTY_TYPE_DB($pARTY_TYPE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pARTY_TYPE_DB) && !is_string($pARTY_TYPE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARTY_TYPE_DB)), __LINE__);
        }
        if (is_null($pARTY_TYPE_DB) || (is_array($pARTY_TYPE_DB) && empty($pARTY_TYPE_DB))) {
            unset($this->PARTY_TYPE_DB);
        } else {
            $this->PARTY_TYPE_DB = $pARTY_TYPE_DB;
        }
        return $this;
    }
    /**
     * Get CORPORATE_FORM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCORPORATE_FORM()
    {
        return isset($this->CORPORATE_FORM) ? $this->CORPORATE_FORM : null;
    }
    /**
     * Set CORPORATE_FORM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cORPORATE_FORM
     * @return \StructType\CUSTOMER_INFO
     */
    public function setCORPORATE_FORM($cORPORATE_FORM = null)
    {
        // validation for constraint: string
        if (!is_null($cORPORATE_FORM) && !is_string($cORPORATE_FORM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cORPORATE_FORM)), __LINE__);
        }
        if (is_null($cORPORATE_FORM) || (is_array($cORPORATE_FORM) && empty($cORPORATE_FORM))) {
            unset($this->CORPORATE_FORM);
        } else {
            $this->CORPORATE_FORM = $cORPORATE_FORM;
        }
        return $this;
    }
    /**
     * Get IDENTIFIER_REFERENCE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDENTIFIER_REFERENCE()
    {
        return isset($this->IDENTIFIER_REFERENCE) ? $this->IDENTIFIER_REFERENCE : null;
    }
    /**
     * Set IDENTIFIER_REFERENCE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDENTIFIER_REFERENCE
     * @return \StructType\CUSTOMER_INFO
     */
    public function setIDENTIFIER_REFERENCE($iDENTIFIER_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTIFIER_REFERENCE) && !is_string($iDENTIFIER_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTIFIER_REFERENCE)), __LINE__);
        }
        if (is_null($iDENTIFIER_REFERENCE) || (is_array($iDENTIFIER_REFERENCE) && empty($iDENTIFIER_REFERENCE))) {
            unset($this->IDENTIFIER_REFERENCE);
        } else {
            $this->IDENTIFIER_REFERENCE = $iDENTIFIER_REFERENCE;
        }
        return $this;
    }
    /**
     * Get IDENTIFIER_REF_VALIDATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDENTIFIER_REF_VALIDATION()
    {
        return isset($this->IDENTIFIER_REF_VALIDATION) ? $this->IDENTIFIER_REF_VALIDATION : null;
    }
    /**
     * Set IDENTIFIER_REF_VALIDATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDENTIFIER_REF_VALIDATION
     * @return \StructType\CUSTOMER_INFO
     */
    public function setIDENTIFIER_REF_VALIDATION($iDENTIFIER_REF_VALIDATION = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTIFIER_REF_VALIDATION) && !is_string($iDENTIFIER_REF_VALIDATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTIFIER_REF_VALIDATION)), __LINE__);
        }
        if (is_null($iDENTIFIER_REF_VALIDATION) || (is_array($iDENTIFIER_REF_VALIDATION) && empty($iDENTIFIER_REF_VALIDATION))) {
            unset($this->IDENTIFIER_REF_VALIDATION);
        } else {
            $this->IDENTIFIER_REF_VALIDATION = $iDENTIFIER_REF_VALIDATION;
        }
        return $this;
    }
    /**
     * Get IDENTIFIER_REF_VALIDATION_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDENTIFIER_REF_VALIDATION_DB()
    {
        return isset($this->IDENTIFIER_REF_VALIDATION_DB) ? $this->IDENTIFIER_REF_VALIDATION_DB : null;
    }
    /**
     * Set IDENTIFIER_REF_VALIDATION_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDENTIFIER_REF_VALIDATION_DB
     * @return \StructType\CUSTOMER_INFO
     */
    public function setIDENTIFIER_REF_VALIDATION_DB($iDENTIFIER_REF_VALIDATION_DB = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTIFIER_REF_VALIDATION_DB) && !is_string($iDENTIFIER_REF_VALIDATION_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTIFIER_REF_VALIDATION_DB)), __LINE__);
        }
        if (is_null($iDENTIFIER_REF_VALIDATION_DB) || (is_array($iDENTIFIER_REF_VALIDATION_DB) && empty($iDENTIFIER_REF_VALIDATION_DB))) {
            unset($this->IDENTIFIER_REF_VALIDATION_DB);
        } else {
            $this->IDENTIFIER_REF_VALIDATION_DB = $iDENTIFIER_REF_VALIDATION_DB;
        }
        return $this;
    }
    /**
     * Get PICTURE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPICTURE_ID()
    {
        return isset($this->PICTURE_ID) ? $this->PICTURE_ID : null;
    }
    /**
     * Set PICTURE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pICTURE_ID
     * @return \StructType\CUSTOMER_INFO
     */
    public function setPICTURE_ID($pICTURE_ID = null)
    {
        if (is_null($pICTURE_ID) || (is_array($pICTURE_ID) && empty($pICTURE_ID))) {
            unset($this->PICTURE_ID);
        } else {
            $this->PICTURE_ID = $pICTURE_ID;
        }
        return $this;
    }
    /**
     * Get ONE_TIME_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getONE_TIME_DB()
    {
        return isset($this->ONE_TIME_DB) ? $this->ONE_TIME_DB : null;
    }
    /**
     * Set ONE_TIME_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oNE_TIME_DB
     * @return \StructType\CUSTOMER_INFO
     */
    public function setONE_TIME_DB($oNE_TIME_DB = null)
    {
        // validation for constraint: string
        if (!is_null($oNE_TIME_DB) && !is_string($oNE_TIME_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oNE_TIME_DB)), __LINE__);
        }
        if (is_null($oNE_TIME_DB) || (is_array($oNE_TIME_DB) && empty($oNE_TIME_DB))) {
            unset($this->ONE_TIME_DB);
        } else {
            $this->ONE_TIME_DB = $oNE_TIME_DB;
        }
        return $this;
    }
    /**
     * Get CUSTOMER_CATEGORY_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_CATEGORY_DB()
    {
        return isset($this->CUSTOMER_CATEGORY_DB) ? $this->CUSTOMER_CATEGORY_DB : null;
    }
    /**
     * Set CUSTOMER_CATEGORY_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_CATEGORY_DB
     * @return \StructType\CUSTOMER_INFO
     */
    public function setCUSTOMER_CATEGORY_DB($cUSTOMER_CATEGORY_DB = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_CATEGORY_DB) && !is_string($cUSTOMER_CATEGORY_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_CATEGORY_DB)), __LINE__);
        }
        if (is_null($cUSTOMER_CATEGORY_DB) || (is_array($cUSTOMER_CATEGORY_DB) && empty($cUSTOMER_CATEGORY_DB))) {
            unset($this->CUSTOMER_CATEGORY_DB);
        } else {
            $this->CUSTOMER_CATEGORY_DB = $cUSTOMER_CATEGORY_DB;
        }
        return $this;
    }
    /**
     * Get C_APPROVED_CRM_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getC_APPROVED_CRM_DB()
    {
        return isset($this->C_APPROVED_CRM_DB) ? $this->C_APPROVED_CRM_DB : null;
    }
    /**
     * Set C_APPROVED_CRM_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $c_APPROVED_CRM_DB
     * @return \StructType\CUSTOMER_INFO
     */
    public function setC_APPROVED_CRM_DB($c_APPROVED_CRM_DB = null)
    {
        // validation for constraint: string
        if (!is_null($c_APPROVED_CRM_DB) && !is_string($c_APPROVED_CRM_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($c_APPROVED_CRM_DB)), __LINE__);
        }
        if (is_null($c_APPROVED_CRM_DB) || (is_array($c_APPROVED_CRM_DB) && empty($c_APPROVED_CRM_DB))) {
            unset($this->C_APPROVED_CRM_DB);
        } else {
            $this->C_APPROVED_CRM_DB = $c_APPROVED_CRM_DB;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\CUSTOMER_INFO
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Get ADDRESSES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ADDRESSES|null
     */
    public function getADDRESSES()
    {
        return isset($this->ADDRESSES) ? $this->ADDRESSES : null;
    }
    /**
     * Set ADDRESSES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ADDRESSES $aDDRESSES
     * @return \StructType\CUSTOMER_INFO
     */
    public function setADDRESSES(\StructType\ADDRESSES $aDDRESSES = null)
    {
        if (is_null($aDDRESSES) || (is_array($aDDRESSES) && empty($aDDRESSES))) {
            unset($this->ADDRESSES);
        } else {
            $this->ADDRESSES = $aDDRESSES;
        }
        return $this;
    }
    /**
     * Get CUSTOMER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CUSTOMER|null
     */
    public function getCUSTOMER()
    {
        return isset($this->CUSTOMER) ? $this->CUSTOMER : null;
    }
    /**
     * Set CUSTOMER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CUSTOMER $cUSTOMER
     * @return \StructType\CUSTOMER_INFO
     */
    public function setCUSTOMER(\StructType\CUSTOMER $cUSTOMER = null)
    {
        if (is_null($cUSTOMER) || (is_array($cUSTOMER) && empty($cUSTOMER))) {
            unset($this->CUSTOMER);
        } else {
            $this->CUSTOMER = $cUSTOMER;
        }
        return $this;
    }
    /**
     * Get CONTACTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CONTACTS|null
     */
    public function getCONTACTS()
    {
        return isset($this->CONTACTS) ? $this->CONTACTS : null;
    }
    /**
     * Set CONTACTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CONTACTS $cONTACTS
     * @return \StructType\CUSTOMER_INFO
     */
    public function setCONTACTS(\StructType\CONTACTS $cONTACTS = null)
    {
        if (is_null($cONTACTS) || (is_array($cONTACTS) && empty($cONTACTS))) {
            unset($this->CONTACTS);
        } else {
            $this->CONTACTS = $cONTACTS;
        }
        return $this;
    }
    /**
     * Get COMM_METHODS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\COMM_METHODS|null
     */
    public function getCOMM_METHODS()
    {
        return isset($this->COMM_METHODS) ? $this->COMM_METHODS : null;
    }
    /**
     * Set COMM_METHODS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\COMM_METHODS $cOMM_METHODS
     * @return \StructType\CUSTOMER_INFO
     */
    public function setCOMM_METHODS(\StructType\COMM_METHODS $cOMM_METHODS = null)
    {
        if (is_null($cOMM_METHODS) || (is_array($cOMM_METHODS) && empty($cOMM_METHODS))) {
            unset($this->COMM_METHODS);
        } else {
            $this->COMM_METHODS = $cOMM_METHODS;
        }
        return $this;
    }
    /**
     * Get INVOICE_INFOS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\INVOICE_INFOS|null
     */
    public function getINVOICE_INFOS()
    {
        return isset($this->INVOICE_INFOS) ? $this->INVOICE_INFOS : null;
    }
    /**
     * Set INVOICE_INFOS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\INVOICE_INFOS $iNVOICE_INFOS
     * @return \StructType\CUSTOMER_INFO
     */
    public function setINVOICE_INFOS(\StructType\INVOICE_INFOS $iNVOICE_INFOS = null)
    {
        if (is_null($iNVOICE_INFOS) || (is_array($iNVOICE_INFOS) && empty($iNVOICE_INFOS))) {
            unset($this->INVOICE_INFOS);
        } else {
            $this->INVOICE_INFOS = $iNVOICE_INFOS;
        }
        return $this;
    }
    /**
     * Get FARMS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FARMS|null
     */
    public function getFARMS()
    {
        return isset($this->FARMS) ? $this->FARMS : null;
    }
    /**
     * Set FARMS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FARMS $fARMS
     * @return \StructType\CUSTOMER_INFO
     */
    public function setFARMS(\StructType\FARMS $fARMS = null)
    {
        if (is_null($fARMS) || (is_array($fARMS) && empty($fARMS))) {
            unset($this->FARMS);
        } else {
            $this->FARMS = $fARMS;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CUSTOMER_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
